/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.core.client.impl;

public class StringBuilderImpl {
    private int arrayLen = 0;
    private String[] stringArray = new String[0];
    private int stringLength = 0;

    private static native String join(String[] var0);

    private static native String setLength(String[] var0, int var1);

    public void append(String toAppend) {
        int appendLength;
        if (toAppend == null) {
            toAppend = "null";
        }
        if ((appendLength = toAppend.length()) > 0) {
            this.stringArray[this.arrayLen++] = toAppend;
            this.stringLength += appendLength;
            if (this.arrayLen > 1024) {
                this.toString();
                StringBuilderImpl.setLength(this.stringArray, 1024);
            }
        }
    }

    public int length() {
        return this.stringLength;
    }

    public void replace(int start, int end, String toInsert) {
        String s = this.toString();
        this.stringArray = new String[]{s.substring(0, start), toInsert, s.substring(end)};
        this.arrayLen = 3;
        this.stringLength += toInsert.length() - (end - start);
    }

    public String toString() {
        if (this.arrayLen != 1) {
            StringBuilderImpl.setLength(this.stringArray, this.arrayLen);
            String s = StringBuilderImpl.join(this.stringArray);
            this.stringArray = new String[]{s};
            this.arrayLen = 1;
        }
        return this.stringArray[0];
    }

    public static class ImplArray
    extends StringBuilderImpl {
        private String[] array = new String[0];

        private static native void setArrayLength(String[] var0, int var1);

        public ImplArray() {
            ImplArray.setArrayLength(this.array, 0);
        }

        public native void append(String var1);

        public int length() {
            return this.toString().length();
        }

        public void replace(int start, int end, String toInsert) {
            String s = this.toString();
            this.array = new String[]{s.substring(0, start), toInsert, s.substring(end)};
        }

        public native String toString();
    }

    public static class ImplPush
    extends StringBuilderImpl {
        private String[] array = new String[0];

        public native void append(String var1);

        public int length() {
            return this.toString().length();
        }

        public void replace(int start, int end, String toInsert) {
            String s = this.toString();
            this.array = new String[]{s.substring(0, start), toInsert, s.substring(end)};
        }

        public native String toString();
    }

    public static class ImplStringAppend
    extends StringBuilderImpl {
        private String string = "";

        public void append(String s) {
            this.string = this.string + s;
        }

        public int length() {
            return this.string.length();
        }

        public void replace(int start, int end, String toInsert) {
            this.string = this.string.substring(0, start) + toInsert + this.string.substring(end);
        }

        public String toString() {
            return this.string;
        }
    }
}

