/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.rg;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.dev.util.Util;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.resources.client.impl.ImageResourcePrototype;
import com.google.gwt.resources.ext.AbstractResourceGenerator;
import com.google.gwt.resources.ext.ClientBundleFields;
import com.google.gwt.resources.ext.ClientBundleRequirements;
import com.google.gwt.resources.ext.ResourceContext;
import com.google.gwt.resources.ext.ResourceGeneratorUtil;
import com.google.gwt.resources.rg.ImageBundleBuilder;
import com.google.gwt.resources.rg.UnsuitableForStripException;
import com.google.gwt.user.rebind.StringSourceWriter;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public final class ImageResourceGenerator
extends AbstractResourceGenerator {
    private boolean prepared;
    private CachedState shared;
    private LocalState local;
    private JType stringType;

    public String createAssignment(TreeLogger logger, ResourceContext context, JMethod method) throws UnableToCompleteException {
        String name = method.getName();
        StringSourceWriter sw = new StringSourceWriter();
        sw.println("new " + ImageResourcePrototype.class.getName() + "(");
        sw.indent();
        sw.println('\"' + name + "\",");
        ImageBundleBuilder.ImageRect rect = this.shared.imageRectsByName.get(name);
        assert (rect != null) : "No ImageRect ever computed for " + name;
        String[] urlExpressions = this.local.urlExpressionsByImageRect.get(rect);
        assert (urlExpressions != null) : "No URL expression for " + name;
        assert (urlExpressions.length == 2);
        if (urlExpressions[1] == null) {
            sw.println(urlExpressions[0] + ",");
        } else {
            sw.println("com.google.gwt.i18n.client.LocaleInfo.getCurrentLocale().isRTL() ?" + urlExpressions[1] + " : " + urlExpressions[0] + ",");
        }
        sw.println(rect.getLeft() + ", " + rect.getTop() + ", " + rect.getWidth() + ", " + rect.getHeight() + ", " + rect.isAnimated() + ", " + rect.isLossy());
        sw.outdent();
        sw.print(")");
        return sw.toString();
    }

    public void createFields(TreeLogger logger, ResourceContext context, ClientBundleFields fields) throws UnableToCompleteException {
        if (!this.prepared) {
            this.finalizeArrangements(logger, context);
        }
        for (ImageBundleBuilder.ImageRect rect : this.shared.imageRectsByName.values()) {
            ImageBundleBuilder builder = this.shared.buildersByImageRect.get(rect);
            URL[] contents = builder == null ? this.shared.urlsByExternalImageRect.get(rect) : this.shared.urlsByBuilder.get(builder);
            assert (contents != null && contents.length == 2);
            String[] urlExpressions = new String[]{this.maybeDeploy(context, fields, contents[0]), this.maybeDeploy(context, fields, contents[1])};
            this.local.urlExpressionsByImageRect.put(rect, urlExpressions);
        }
    }

    public void finish(TreeLogger logger, ResourceContext context) throws UnableToCompleteException {
        this.local = null;
    }

    public void init(TreeLogger logger, ResourceContext context) {
        String key = context.getClientBundleType().getQualifiedSourceName() + ":" + context.supportsDataUrls();
        this.shared = context.getCachedData(key, CachedState.class);
        boolean bl = this.prepared = this.shared != null;
        if (this.prepared) {
            logger.log(TreeLogger.DEBUG, "Using cached data");
        } else {
            this.shared = new CachedState();
            context.putCachedData(key, this.shared);
        }
        this.local = new LocalState();
        this.stringType = context.getGeneratorContext().getTypeOracle().findType(String.class.getCanonicalName());
        assert (this.stringType != null) : "No String type";
    }

    public void prepare(TreeLogger logger, ResourceContext context, ClientBundleRequirements requirements, JMethod method) throws UnableToCompleteException {
        ImageBundleBuilder.ImageRect rect;
        if (this.prepared) {
            return;
        }
        URL[] resources = ResourceGeneratorUtil.findResources(logger, context, method);
        if (resources.length != 1) {
            logger.log(TreeLogger.ERROR, "Exactly one image may be specified", null);
            throw new UnableToCompleteException();
        }
        ImageBundleBuilder builder = this.getBuilder(method);
        URL resource = resources[0];
        String name = method.getName();
        try {
            rect = builder.assimilate(logger, name, resource);
            if (context.supportsDataUrls() || this.getRepeatStyle(method) == ImageResource.RepeatStyle.Both) {
                builder.removeMapping(name);
                rect.setPosition(0, 0);
                throw new UnsuitableForStripException(rect);
            }
            this.shared.buildersByImageRect.put(rect, builder);
        }
        catch (UnsuitableForStripException e) {
            rect = e.getImageRect();
            URL normalContents = rect.isAnimated() || rect.isLossy() ? resource : this.reencodeToTempFile(logger, rect);
            this.shared.urlsByExternalImageRect.put(rect, new URL[]{normalContents, null});
        }
        this.shared.imageRectsByName.put(name, rect);
        if (this.getFlipRtl(method)) {
            this.shared.rtlImages.add(rect);
        }
    }

    private void finalizeArrangements(TreeLogger logger, ResourceContext context) throws UnableToCompleteException {
        block6: for (Map.Entry<ImageResource.RepeatStyle, ImageBundleBuilder> entry : this.shared.buildersByRepeatStyle.entrySet()) {
            ImageBundleBuilder.Arranger arranger;
            ImageResource.RepeatStyle repeatStyle = entry.getKey();
            ImageBundleBuilder builder = entry.getValue();
            switch (repeatStyle) {
                case None: {
                    arranger = new ImageBundleBuilder.BestFitArranger();
                    break;
                }
                case Horizontal: {
                    arranger = new ImageBundleBuilder.VerticalArranger();
                    break;
                }
                case Vertical: {
                    arranger = new ImageBundleBuilder.HorizontalArranger();
                    break;
                }
                case Both: {
                    continue block6;
                }
                default: {
                    logger.log(TreeLogger.ERROR, "Unknown RepeatStyle" + (Object)((Object)repeatStyle));
                    throw new UnableToCompleteException();
                }
            }
            URL normalContents = this.renderToTempFile(logger, builder, arranger);
            this.shared.urlsByBuilder.put(builder, new URL[]{normalContents, null});
        }
        if (this.shared.rtlImages.size() > 0) {
            HashSet<ImageBundleBuilder> rtlBuilders = new HashSet<ImageBundleBuilder>();
            for (ImageBundleBuilder.ImageRect rtlImage : this.shared.rtlImages) {
                AffineTransform tx = new AffineTransform();
                tx.setTransform(-1.0, 0.0, 0.0, 1.0, rtlImage.getWidth(), 0.0);
                rtlImage.setTransform(tx);
                if (this.shared.buildersByImageRect.containsKey(rtlImage)) {
                    rtlBuilders.add(this.shared.buildersByImageRect.get(rtlImage));
                    continue;
                }
                URL[] contents = this.shared.urlsByExternalImageRect.get(rtlImage);
                assert (contents != null);
                contents[1] = this.reencodeToTempFile(logger, rtlImage);
            }
            for (ImageBundleBuilder builder : rtlBuilders) {
                URL[] contents = this.shared.urlsByBuilder.get(builder);
                assert (contents != null && contents.length == 2);
                contents[1] = this.renderToTempFile(logger, builder, new ImageBundleBuilder.IdentityArranger());
            }
        }
    }

    private ImageBundleBuilder getBuilder(JMethod method) {
        ImageResource.RepeatStyle repeatStyle = this.getRepeatStyle(method);
        ImageBundleBuilder builder = this.shared.buildersByRepeatStyle.get((Object)repeatStyle);
        if (builder == null) {
            builder = new ImageBundleBuilder();
            this.shared.buildersByRepeatStyle.put(repeatStyle, builder);
        }
        return builder;
    }

    private boolean getFlipRtl(JMethod method) {
        ImageResource.ImageOptions options = (ImageResource.ImageOptions)method.getAnnotation(ImageResource.ImageOptions.class);
        if (options == null) {
            return false;
        }
        return options.flipRtl();
    }

    private ImageResource.RepeatStyle getRepeatStyle(JMethod method) {
        ImageResource.ImageOptions options = (ImageResource.ImageOptions)method.getAnnotation(ImageResource.ImageOptions.class);
        if (options == null) {
            return ImageResource.RepeatStyle.None;
        }
        return options.repeatStyle();
    }

    private String maybeDeploy(ResourceContext context, ClientBundleFields fields, URL resource) throws UnableToCompleteException {
        if (resource == null) {
            return null;
        }
        String toReturn = this.local.fieldNamesByUrl.get(resource);
        if (toReturn == null) {
            String urlExpression = context.deploy(resource, false);
            toReturn = fields.define(this.stringType, "internedUrl" + this.local.fieldNamesByUrl.size(), urlExpression, true, true);
            this.local.fieldNamesByUrl.put(resource, toReturn);
        }
        return toReturn;
    }

    private URL reencodeToTempFile(TreeLogger logger, ImageBundleBuilder.ImageRect rect) throws UnableToCompleteException {
        try {
            byte[] imageBytes = ImageBundleBuilder.toPng(logger, rect);
            if (imageBytes == null) {
                return null;
            }
            File file = File.createTempFile(ImageResourceGenerator.class.getSimpleName(), ".png");
            file.deleteOnExit();
            Util.writeBytesToFile((TreeLogger)logger, (File)file, (byte[])imageBytes);
            return file.toURI().toURL();
        }
        catch (IOException ex) {
            logger.log(TreeLogger.ERROR, "Unable to write re-encoded PNG", (Throwable)ex);
            throw new UnableToCompleteException();
        }
    }

    private URL renderToTempFile(TreeLogger logger, ImageBundleBuilder builder, ImageBundleBuilder.Arranger arranger) throws UnableToCompleteException {
        try {
            byte[] imageBytes = builder.render(logger, arranger);
            if (imageBytes == null) {
                return null;
            }
            File file = File.createTempFile(ImageResourceGenerator.class.getSimpleName(), ".png");
            file.deleteOnExit();
            Util.writeBytesToFile((TreeLogger)logger, (File)file, (byte[])imageBytes);
            return file.toURI().toURL();
        }
        catch (IOException ex) {
            logger.log(TreeLogger.ERROR, "Unable to write re-encoded PNG", (Throwable)ex);
            throw new UnableToCompleteException();
        }
    }

    static class CachedState {
        public final Map<ImageBundleBuilder.ImageRect, ImageBundleBuilder> buildersByImageRect = new IdentityHashMap<ImageBundleBuilder.ImageRect, ImageBundleBuilder>();
        public final Map<ImageResource.RepeatStyle, ImageBundleBuilder> buildersByRepeatStyle = new EnumMap<ImageResource.RepeatStyle, ImageBundleBuilder>(ImageResource.RepeatStyle.class);
        public final Map<String, ImageBundleBuilder.ImageRect> imageRectsByName = new HashMap<String, ImageBundleBuilder.ImageRect>();
        public final Set<ImageBundleBuilder.ImageRect> rtlImages = new HashSet<ImageBundleBuilder.ImageRect>();
        public final Map<ImageBundleBuilder, URL[]> urlsByBuilder = new IdentityHashMap<ImageBundleBuilder, URL[]>();
        public final Map<ImageBundleBuilder.ImageRect, URL[]> urlsByExternalImageRect = new IdentityHashMap<ImageBundleBuilder.ImageRect, URL[]>();

        CachedState() {
        }
    }

    static class LocalState {
        public final Map<URL, String> fieldNamesByUrl = new HashMap<URL, String>();
        public final Map<ImageBundleBuilder.ImageRect, String[]> urlExpressionsByImageRect = new HashMap<ImageBundleBuilder.ImageRect, String[]>();

        LocalState() {
        }
    }
}

