/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.refactoring;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodePrinter;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.parsing.JsDocInfoParser;
import com.google.javascript.refactoring.CodeReplacement;
import com.google.javascript.refactoring.Match;
import com.google.javascript.refactoring.Matchers;
import com.google.javascript.refactoring.NodeMetadata;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class SuggestedFix {
    private final Node originalMatchedNode;
    private final SetMultimap<String, CodeReplacement> replacements;
    @Nullable
    private final String description;

    private SuggestedFix(Node originalMatchedNode, SetMultimap<String, CodeReplacement> replacements, @Nullable String description) {
        this.originalMatchedNode = originalMatchedNode;
        this.replacements = replacements;
        this.description = description;
    }

    public Node getOriginalMatchedNode() {
        return this.originalMatchedNode;
    }

    public SetMultimap<String, CodeReplacement> getReplacements() {
        return this.replacements;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.replacements.asMap().entrySet()) {
            sb.append("Replacements for file: " + (String)entry.getKey() + "\n");
            Joiner.on((String)"\n\n").appendTo(sb, (Iterable)entry.getValue());
        }
        return sb.toString();
    }

    public static final class Builder {
        private Node originalMatchedNode = null;
        private final ImmutableSetMultimap.Builder<String, CodeReplacement> replacements = ImmutableSetMultimap.builder();
        private String description = null;

        public Builder setOriginalMatchedNode(Node node) {
            this.originalMatchedNode = node;
            return this;
        }

        public Builder addChildToFront(Node parentNode, String content) {
            Preconditions.checkState((boolean)parentNode.isBlock(), (Object)"addChildToFront is only supported for BLOCK statements.");
            int startPosition = parentNode.getSourceOffset() + 1;
            this.replacements.put((Object)parentNode.getSourceFileName(), (Object)new CodeReplacement(startPosition, 0, "\n" + content));
            return this;
        }

        public Builder insertBefore(Node nodeToInsertBefore, Node n, AbstractCompiler compiler) {
            return this.insertBefore(nodeToInsertBefore, n, compiler, "");
        }

        private Builder insertBefore(Node nodeToInsertBefore, Node n, AbstractCompiler compiler, String sortKey) {
            return this.insertBefore(nodeToInsertBefore, this.generateCode(compiler, n), sortKey);
        }

        public Builder insertBefore(Node nodeToInsertBefore, String content) {
            return this.insertBefore(nodeToInsertBefore, content, "");
        }

        private Builder insertBefore(Node nodeToInsertBefore, String content, String sortKey) {
            int startPosition = nodeToInsertBefore.getSourceOffset();
            JSDocInfo jsDoc = NodeUtil.getBestJSDocInfo(nodeToInsertBefore);
            if (jsDoc != null) {
                startPosition = jsDoc.getOriginalCommentPosition();
            }
            Preconditions.checkNotNull((Object)nodeToInsertBefore.getSourceFileName(), (String)"No source file name for node: %s", (Object[])new Object[]{nodeToInsertBefore});
            this.replacements.put((Object)nodeToInsertBefore.getSourceFileName(), (Object)new CodeReplacement(startPosition, 0, content, sortKey));
            return this;
        }

        public Builder delete(Node n) {
            return this.delete(n, true);
        }

        public Builder deleteWithoutRemovingWhitespaceBefore(Node n) {
            return this.delete(n, false);
        }

        private Builder delete(Node n, boolean deleteWhitespaceBefore) {
            Node previousSibling;
            int startPosition = n.getSourceOffset();
            int length = n.getNext() != null && NodeUtil.getBestJSDocInfo(n.getNext()) == null ? n.getNext().getSourceOffset() - startPosition : n.getLength();
            JSDocInfo jsDoc = NodeUtil.getBestJSDocInfo(n);
            if (jsDoc != null) {
                length += startPosition - jsDoc.getOriginalCommentPosition();
                startPosition = jsDoc.getOriginalCommentPosition();
            }
            if (n.isName() && n.getParent().isVar()) {
                if (n.getNext() != null) {
                    length = n.getNext().getSourceOffset() - startPosition;
                } else if (n.hasChildren()) {
                    Node child = n.getFirstChild();
                    length = child.getSourceOffset() + child.getLength() - startPosition;
                }
                if (n.getParent().getLastChild() == n && n != n.getParent().getFirstChild()) {
                    Node previousSibling2 = n.getParent().getChildBefore(n);
                    if (previousSibling2.hasChildren()) {
                        Node child = previousSibling2.getFirstChild();
                        int startPositionDiff = startPosition - (child.getSourceOffset() + child.getLength());
                        startPosition -= startPositionDiff;
                        length += startPositionDiff;
                    } else {
                        int startPositionDiff = startPosition - (previousSibling2.getSourceOffset() + previousSibling2.getLength());
                        startPosition -= startPositionDiff;
                        length += startPositionDiff;
                    }
                }
            }
            Node parent = n.getParent();
            if (deleteWhitespaceBefore && parent != null && (parent.isScript() || parent.isBlock()) && (previousSibling = parent.getChildBefore(n)) != null) {
                int previousSiblingEndPosition = previousSibling.getSourceOffset() + previousSibling.getLength();
                length += startPosition - previousSiblingEndPosition;
                startPosition = previousSiblingEndPosition;
            }
            this.replacements.put((Object)n.getSourceFileName(), (Object)new CodeReplacement(startPosition, length, ""));
            return this;
        }

        public Builder rename(Node n, String name) {
            return this.rename(n, name, false);
        }

        public Builder rename(Node n, String name, boolean replaceEntireName) {
            Node nodeToRename = null;
            if (n.isCall() || n.isTaggedTemplateLit()) {
                Node child;
                nodeToRename = child = n.getFirstChild();
                if (!replaceEntireName && child.isGetProp()) {
                    nodeToRename = child.getLastChild();
                }
            } else if (n.isGetProp()) {
                nodeToRename = n.getLastChild();
                if (replaceEntireName) {
                    while (nodeToRename.getParent().isGetProp()) {
                        nodeToRename = nodeToRename.getParent();
                    }
                }
            } else if (n.isStringKey()) {
                nodeToRename = n;
            } else if (n.isString()) {
                Preconditions.checkState((boolean)n.getParent().isGetProp(), (Object)n);
                nodeToRename = n;
            } else {
                throw new UnsupportedOperationException("Rename is not implemented for this node type: " + n);
            }
            this.replacements.put((Object)nodeToRename.getSourceFileName(), (Object)new CodeReplacement(nodeToRename.getSourceOffset(), nodeToRename.getLength(), name));
            return this;
        }

        public Builder replaceRange(Node first, Node last, String newContent) {
            Preconditions.checkState((first.getParent() == last.getParent() ? 1 : 0) != 0);
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(first);
            int start = jsdoc == null ? first.getSourceOffset() : jsdoc.getOriginalCommentPosition();
            int end = last.getSourceOffset() + last.getLength();
            int length = end - start;
            this.replacements.put((Object)first.getSourceFileName(), (Object)new CodeReplacement(start, length, newContent));
            return this;
        }

        public Builder replace(Node original, Node newNode, AbstractCompiler compiler) {
            boolean needsSemicolon;
            String newCode;
            Node parent = original.getParent();
            if (original.getParent().isExprResult()) {
                original = original.getParent();
            }
            if ((newCode = this.generateCode(compiler, newNode)).endsWith("\n")) {
                newCode = newCode.substring(0, newCode.length() - 1);
            }
            boolean bl = needsSemicolon = parent.isExprResult() || parent.isBlock() || parent.isScript();
            if (newCode.endsWith(";") && !needsSemicolon) {
                newCode = newCode.substring(0, newCode.length() - 1);
            }
            this.replacements.put((Object)original.getSourceFileName(), (Object)new CodeReplacement(original.getSourceOffset(), original.getLength(), newCode));
            return this;
        }

        public Builder addCast(Node n, AbstractCompiler compiler, String type) {
            this.replacements.put((Object)n.getSourceFileName(), (Object)new CodeReplacement(n.getSourceOffset(), n.getLength(), "/** @type {" + type + "} */ (" + this.generateCode(compiler, n) + ")"));
            return this;
        }

        public Builder removeCast(Node n, AbstractCompiler compiler) {
            Preconditions.checkArgument((boolean)n.isCast());
            JSDocInfo jsDoc = n.getJSDocInfo();
            this.replacements.put((Object)n.getSourceFileName(), (Object)new CodeReplacement(jsDoc.getOriginalCommentPosition(), n.getFirstChild().getSourceOffset() - jsDoc.getOriginalCommentPosition(), ""));
            this.replacements.put((Object)n.getSourceFileName(), (Object)new CodeReplacement(n.getSourceOffset() + n.getLength() - 1, 1, ""));
            return this;
        }

        public Builder addOrReplaceJsDoc(Node n, String newJsDoc) {
            int startPosition = n.getSourceOffset();
            int length = 0;
            JSDocInfo jsDoc = NodeUtil.getBestJSDocInfo(n);
            if (jsDoc != null) {
                startPosition = jsDoc.getOriginalCommentPosition();
                length = n.getSourceOffset() - jsDoc.getOriginalCommentPosition();
            }
            this.replacements.put((Object)n.getSourceFileName(), (Object)new CodeReplacement(startPosition, length, newJsDoc));
            return this;
        }

        public Builder changeJsDocType(Node n, AbstractCompiler compiler, String type) {
            JSDocInfo info = NodeUtil.getBestJSDocInfo(n);
            Preconditions.checkNotNull((Object)info, (String)"Node %s does not have JS Doc associated with it.", (Object[])new Object[]{n});
            Node typeNode = JsDocInfoParser.parseTypeString(type);
            Preconditions.checkNotNull((Object)typeNode, (String)"Invalid type: %s", (Object[])new Object[]{type});
            JSTypeExpression typeExpr = new JSTypeExpression(typeNode, "jsflume");
            JSType newJsType = typeExpr.evaluate(null, compiler.getTypeRegistry());
            if (newJsType == null) {
                throw new RuntimeException("JS Compiler does not recognize type: " + type);
            }
            String originalComment = info.getOriginalCommentString();
            int originalPosition = info.getOriginalCommentPosition();
            Pattern typeDocPattern = Pattern.compile("@(type|private|protected|public|const|return) *\\{?[^\\s}]+\\}?");
            Matcher m = typeDocPattern.matcher(originalComment);
            while (m.find()) {
                this.replacements.put((Object)n.getSourceFileName(), (Object)new CodeReplacement(originalPosition + m.start(), m.end() - m.start(), "@" + m.group(1) + " {" + type + "}"));
            }
            return this;
        }

        public Builder insertArguments(Node n, int position, String ... args) {
            int startPosition;
            int i;
            Preconditions.checkArgument((boolean)n.isCall(), (Object)"insertArguments is only applicable to function call nodes.");
            Node argument = n.getSecondChild();
            for (i = 0; argument != null && i < position; argument = argument.getNext(), ++i) {
            }
            if (argument == null) {
                Preconditions.checkArgument((position == i ? 1 : 0) != 0, (Object)"The specified position must be less than the number of arguments.");
                startPosition = n.getSourceOffset() + n.getLength() - 1;
            } else {
                JSDocInfo jsDoc = argument.getJSDocInfo();
                startPosition = jsDoc != null ? jsDoc.getOriginalCommentPosition() : argument.getSourceOffset();
            }
            String newContent = Joiner.on((String)", ").join((Object[])args);
            if (argument != null) {
                newContent = newContent + ", ";
            } else if (i > 0) {
                newContent = ", " + newContent;
            }
            this.replacements.put((Object)n.getSourceFileName(), (Object)new CodeReplacement(startPosition, 0, newContent));
            return this;
        }

        public Builder deleteArgument(Node n, int position) {
            Preconditions.checkArgument((boolean)n.isCall(), (Object)"deleteArgument is only applicable to function call nodes.");
            int numArguments = n.getChildCount() - 1;
            Preconditions.checkState((numArguments > 0 ? 1 : 0) != 0, (Object)"deleteArgument() cannot be used on a function call with no arguments");
            Preconditions.checkArgument((position >= 0 && position < numArguments ? 1 : 0) != 0, (Object)"The specified position must be less than the number of arguments.");
            Node argument = n.getSecondChild();
            int startOfArgumentToRemove = -1;
            int endOfArgumentToRemove = -1;
            int i = 0;
            while (argument != null) {
                if (i < position) {
                    startOfArgumentToRemove = argument.getSourceOffset() + argument.getLength();
                } else if (i == position) {
                    if (position == 0) {
                        int jsDocPosition;
                        startOfArgumentToRemove = argument.getSourceOffset();
                        JSDocInfo jsDoc = argument.getJSDocInfo();
                        if (jsDoc != null && (jsDocPosition = jsDoc.getOriginalCommentPosition()) < startOfArgumentToRemove) {
                            startOfArgumentToRemove = jsDocPosition;
                        }
                    }
                    endOfArgumentToRemove = argument.getSourceOffset() + argument.getLength();
                } else if (i > position) {
                    if (position != 0) break;
                    endOfArgumentToRemove = argument.getSourceOffset();
                    break;
                }
                argument = argument.getNext();
                ++i;
            }
            int lengthOfArgumentToRemove = endOfArgumentToRemove - startOfArgumentToRemove;
            this.replacements.put((Object)n.getSourceFileName(), (Object)new CodeReplacement(startOfArgumentToRemove, lengthOfArgumentToRemove, ""));
            return this;
        }

        public Builder addGoogRequire(Match m, String namespace) {
            Node node = m.getNode();
            NodeMetadata metadata = m.getMetadata();
            Node existingNode = this.findGoogRequireNode(m.getNode(), metadata, namespace);
            if (existingNode != null) {
                return this;
            }
            Node googRequireNode = IR.exprResult(IR.call(IR.getprop(IR.name("goog"), IR.string("require")), IR.string(namespace)));
            Node script = NodeUtil.getEnclosingScript(node);
            if (script == null) {
                return this;
            }
            Node lastGoogProvideNode = null;
            Node lastGoogRequireNode = null;
            Node nodeToInsertBefore = null;
            for (Node child = script.getFirstChild(); child != null; child = child.getNext()) {
                if (!child.isExprResult() || !child.getFirstChild().isCall()) continue;
                Node grandchild = child.getFirstChild();
                if (Matchers.functionCall("goog.provide").matches(grandchild, metadata)) {
                    lastGoogProvideNode = grandchild;
                    continue;
                }
                if (!Matchers.functionCall("goog.require").matches(grandchild, metadata)) continue;
                lastGoogRequireNode = grandchild;
                if (!grandchild.getLastChild().isString() || namespace.compareTo(grandchild.getLastChild().getString()) >= 0) continue;
                nodeToInsertBefore = child;
                break;
            }
            if (nodeToInsertBefore == null) {
                if (lastGoogProvideNode != null || lastGoogRequireNode != null) {
                    Node nodeToInsertAfter = lastGoogRequireNode != null ? lastGoogRequireNode : lastGoogProvideNode;
                    int startPosition = nodeToInsertAfter.getSourceOffset() + nodeToInsertAfter.getLength() + 2;
                    this.replacements.put((Object)nodeToInsertAfter.getSourceFileName(), (Object)new CodeReplacement(startPosition, 0, this.generateCode(m.getMetadata().getCompiler(), googRequireNode)));
                    return this;
                }
                if (script.getFirstChild() != null) {
                    nodeToInsertBefore = script.getFirstChild();
                } else {
                    this.replacements.put((Object)script.getSourceFileName(), (Object)new CodeReplacement(0, 0, this.generateCode(m.getMetadata().getCompiler(), googRequireNode)));
                    return this;
                }
            }
            return this.insertBefore(nodeToInsertBefore, googRequireNode, m.getMetadata().getCompiler(), namespace);
        }

        public Builder removeGoogRequire(Match m, String namespace) {
            Node googRequireNode = this.findGoogRequireNode(m.getNode(), m.getMetadata(), namespace);
            if (googRequireNode != null) {
                return this.deleteWithoutRemovingWhitespaceBefore(googRequireNode);
            }
            return this;
        }

        private Node findGoogRequireNode(Node n, NodeMetadata metadata, String namespace) {
            Node script = NodeUtil.getEnclosingScript(n);
            if (script != null) {
                for (Node child = script.getFirstChild(); child != null; child = child.getNext()) {
                    if (!child.isExprResult() || !child.getFirstChild().isCall()) continue;
                    Node grandchild = child.getFirstChild();
                    if (!Matchers.functionCall("goog.require").matches(child.getFirstChild(), metadata) || !grandchild.getLastChild().isString() || !namespace.equals(grandchild.getLastChild().getString())) continue;
                    return child;
                }
            }
            return null;
        }

        public String generateCode(AbstractCompiler compiler, Node node) {
            CompilerOptions compilerOptions = new CompilerOptions();
            compilerOptions.setPreferSingleQuotes(true);
            compilerOptions.setLineLengthThreshold(80);
            compilerOptions.setTrustedStrings(true);
            return new CodePrinter.Builder(node).setCompilerOptions(compilerOptions).setTypeRegistry(compiler.getTypeRegistry()).setPrettyPrint(true).setLineBreak(true).setOutputTypes(true).build();
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public SuggestedFix build() {
            return new SuggestedFix(this.originalMatchedNode, (SetMultimap)this.replacements.build(), this.description);
        }
    }
}

