/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDAttributeUseCategory;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConstraint;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDConstants;
import org.eclipse.xsd.util.XSDUtil;

public class XSDUtils {
    private static List<XSDSimpleTypeDefinition> advancedPrimitives = new ArrayList<XSDSimpleTypeDefinition>();
    private static final AtomicBoolean advancedPrimitiveWasSet = new AtomicBoolean(false);
    private static List<String> xsdShortList = new ArrayList<String>();
    private static List<String> supportedPrimitives;
    static final String EMPTY_STRING = "";

    static {
        xsdShortList.add("string");
        xsdShortList.add("int");
        xsdShortList.add("double");
        xsdShortList.add("date");
        xsdShortList.add("time");
        xsdShortList.add("dateTime");
        xsdShortList.add("boolean");
        xsdShortList.add("hexBinary");
        xsdShortList.add("float");
        supportedPrimitives = new ArrayList<String>();
        supportedPrimitives.add("anyType");
        supportedPrimitives.add("anyURI");
        supportedPrimitives.add("base64Binary");
        supportedPrimitives.add("boolean");
        supportedPrimitives.add("byte");
        supportedPrimitives.add("date");
        supportedPrimitives.add("dateTime");
        supportedPrimitives.add("decimal");
        supportedPrimitives.add("double");
        supportedPrimitives.add("duration");
        supportedPrimitives.add("ENTITIES");
        supportedPrimitives.add("ENTITY");
        supportedPrimitives.add("float");
        supportedPrimitives.add("gDay");
        supportedPrimitives.add("gMonth");
        supportedPrimitives.add("gMonthDay");
        supportedPrimitives.add("gYear");
        supportedPrimitives.add("gYearMonth");
        supportedPrimitives.add("hexBinary");
        supportedPrimitives.add("ID");
        supportedPrimitives.add("IDREF");
        supportedPrimitives.add("IDREFS");
        supportedPrimitives.add("int");
        supportedPrimitives.add("integer");
        supportedPrimitives.add("language");
        supportedPrimitives.add("long");
        supportedPrimitives.add("Name");
        supportedPrimitives.add("NCName");
        supportedPrimitives.add("negativeInteger");
        supportedPrimitives.add("NMTOKEN");
        supportedPrimitives.add("NMTOKENS");
        supportedPrimitives.add("nonNegativeInteger");
        supportedPrimitives.add("nonPositiveInteger");
        supportedPrimitives.add("normalizedString");
        supportedPrimitives.add("NOTATION");
        supportedPrimitives.add("positiveInteger");
        supportedPrimitives.add("QName");
        supportedPrimitives.add("short");
        supportedPrimitives.add("string");
        supportedPrimitives.add("time");
        supportedPrimitives.add("token");
        supportedPrimitives.add("unsignedByte");
        supportedPrimitives.add("unsignedInt");
        supportedPrimitives.add("unsignedLong");
        supportedPrimitives.add("unsignedShort");
    }

    public static List<XSDSimpleTypeDefinition> getAdvancedPrimitives() {
        if (!advancedPrimitiveWasSet.get()) {
            XSDSchema schemaForSchemas = XSDUtil.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema");
            for (String typeName : supportedPrimitives) {
                XSDSimpleTypeDefinition type = schemaForSchemas.resolveSimpleTypeDefinition(typeName);
                advancedPrimitives.add(type);
            }
            Collections.sort(advancedPrimitives, new Comparator<XSDSimpleTypeDefinition>(){

                @Override
                public int compare(XSDSimpleTypeDefinition o1, XSDSimpleTypeDefinition o2) {
                    if (o1 == null || o2 == null || o1.getName() == null) {
                        return 0;
                    }
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            advancedPrimitiveWasSet.set(true);
        }
        return advancedPrimitives;
    }

    public static List<XSDTypeDefinition> getAllDataTypes(XSDSchema schema) {
        if (schema == null) {
            return Collections.emptyList();
        }
        ArrayList<XSDTypeDefinition> bos = new ArrayList<XSDTypeDefinition>();
        for (Object item : schema.getContents()) {
            XSDElementDeclaration element;
            if (item instanceof XSDTypeDefinition) {
                bos.add((XSDTypeDefinition)item);
                continue;
            }
            if (!(item instanceof XSDElementDeclaration) || !((element = (XSDElementDeclaration)item).getAnonymousTypeDefinition() instanceof XSDComplexTypeDefinition)) continue;
            bos.add(element.getAnonymousTypeDefinition());
        }
        return bos;
    }

    public static List<XSDAttributeDeclaration> getChildAttributes(XSDComplexTypeDefinition bo) {
        EList attrContents = bo.getAttributeContents();
        ArrayList<XSDAttributeDeclaration> attrs = new ArrayList<XSDAttributeDeclaration>();
        int i = 0;
        while (i < attrContents.size()) {
            XSDAttributeGroupDefinition attrGroup;
            Object next = attrContents.get(i);
            if (next instanceof XSDAttributeUse) {
                attrs.add(((XSDAttributeUse)next).getContent().getResolvedAttributeDeclaration());
            } else if (next instanceof XSDAttributeGroupDefinition && (attrGroup = (XSDAttributeGroupDefinition)next).getResolvedAttributeGroupDefinition() != null) {
                attrContents.addAll((Collection)attrGroup.getResolvedAttributeGroupDefinition().getAttributeUses());
            }
            ++i;
        }
        return attrs;
    }

    public static List<XSDParticleContent> getChildElements(XSDComplexTypeDefinition bo) {
        ArrayList<XSDParticleContent> children = new ArrayList<XSDParticleContent>();
        children.addAll(XSDUtils.getChildElements(XSDUtils.getModelGroup(bo)));
        if (bo.getBaseTypeDefinition() instanceof XSDComplexTypeDefinition) {
            children.addAll(XSDUtils.getChildElements(XSDUtils.getModelGroup((XSDComplexTypeDefinition)bo.getBaseTypeDefinition())));
        }
        return children;
    }

    public static List<XSDParticleContent> getChildElements(XSDFeature elem) {
        XSDComplexTypeDefinition cType = XSDUtils.getResolvedComplexType(elem);
        if (cType != null) {
            return XSDUtils.getChildElements(cType);
        }
        return Collections.emptyList();
    }

    public static List<XSDParticleContent> getChildElements(XSDModelGroup group) {
        if (group == null) {
            return new ArrayList<XSDParticleContent>();
        }
        ArrayList<XSDParticleContent> children = new ArrayList<XSDParticleContent>();
        for (XSDParticle next : group.getContents()) {
            if (next.getContent() instanceof XSDFeature) {
                children.add(next.getContent());
                continue;
            }
            if (!(next.getTerm() instanceof XSDModelGroup)) continue;
            children.addAll(XSDUtils.getChildElements((XSDModelGroup)next.getTerm()));
        }
        return children;
    }

    public static XSDModelGroup getModelGroup(XSDComplexTypeDefinition cType) {
        XSDComplexTypeContent content;
        XSDParticle particle = cType.getComplexType();
        if (particle == null || particle.eContainer() != cType) {
            return null;
        }
        XSDParticleContent particleContent = particle.getContent();
        XSDModelGroup group = null;
        if (particleContent instanceof XSDModelGroupDefinition) {
            group = ((XSDModelGroupDefinition)particleContent).getResolvedModelGroupDefinition().getModelGroup();
        } else if (particleContent instanceof XSDModelGroup) {
            group = (XSDModelGroup)particleContent;
        }
        if (group == null) {
            return null;
        }
        if ((group.getContents().isEmpty() || group.eResource() != cType.eResource()) && cType.getBaseType() != null && (content = cType.getContent()) instanceof XSDParticle) {
            particleContent = ((XSDParticle)content).getContent();
            if (particleContent instanceof XSDModelGroupDefinition) {
                group = ((XSDModelGroupDefinition)particleContent).getResolvedModelGroupDefinition().getModelGroup();
            } else if (particleContent instanceof XSDModelGroup) {
                group = (XSDModelGroup)particleContent;
            }
        }
        return group;
    }

    public static XSDSimpleTypeDefinition getPrimitive(String xsdName) {
        for (XSDSimpleTypeDefinition next : XSDUtils.getAdvancedPrimitives()) {
            if (!next.getName().equals(xsdName)) continue;
            return next;
        }
        return null;
    }

    public static Collection<XSDTypeDefinition> getReferencedTypes(XSDComplexTypeDefinition source) {
        if (source == null) {
            return Collections.emptySet();
        }
        ArrayList<XSDTypeDefinition> results = new ArrayList<XSDTypeDefinition>();
        Object var2_2 = null;
        XSDComplexTypeDefinition elementType = null;
        for (XSDFeature xSDFeature : XSDUtils.getChildElements(source)) {
            elementType = XSDUtils.getResolvedComplexType(xSDFeature);
            if (elementType == null || results.contains(elementType) || XSDConstants.isSchemaForSchemaNamespace((String)elementType.getTargetNamespace())) continue;
            results.add((XSDTypeDefinition)elementType);
        }
        return results;
    }

    public static Collection<XSDTypeDefinition> getAllReferencedTypes(XSDComplexTypeDefinition source) {
        return XSDUtils.getAllReferencedTypes(source, false);
    }

    public static Collection<XSDTypeDefinition> getAllReferencedTypes(XSDComplexTypeDefinition source, boolean includeAnonymous) {
        if (source == null) {
            return Collections.emptySet();
        }
        ArrayList<XSDTypeDefinition> results = new ArrayList<XSDTypeDefinition>();
        XSDTypeDefinition elementType = null;
        for (XSDFeature xSDFeature : XSDUtils.getChildElements(source)) {
            elementType = XSDUtils.getResolvedType(xSDFeature);
            if (elementType == null || results.contains(elementType) || XSDConstants.isSchemaForSchemaNamespace((String)elementType.getTargetNamespace()) || !includeAnonymous && elementType.eContainer() == xSDFeature) continue;
            results.add(elementType);
        }
        return results;
    }

    public static XSDComplexTypeDefinition getResolvedComplexType(XSDFeature feature) {
        XSDTypeDefinition resolvedType = XSDUtils.getResolvedType(feature);
        if (resolvedType instanceof XSDComplexTypeDefinition) {
            return (XSDComplexTypeDefinition)resolvedType;
        }
        return null;
    }

    public static XSDTypeDefinition getResolvedType(XSDFeature feature) {
        if (feature instanceof XSDElementDeclaration && ((XSDElementDeclaration)feature).getTypeDefinition() instanceof XSDComplexTypeDefinition) {
            EObject newType;
            XSDElementDeclaration element = (XSDElementDeclaration)feature;
            XSDComplexTypeDefinition oldType = (XSDComplexTypeDefinition)element.getTypeDefinition();
            if (oldType != (newType = EcoreUtil.resolve((EObject)element.getTypeDefinition(), (EObject)element))) {
                String oldName = oldType.getName();
                String newName = ((XSDTypeDefinition)newType).getName();
                String oldTNS = oldType.getTargetNamespace();
                String newTNS = ((XSDTypeDefinition)newType).getTargetNamespace();
                if ((oldName == newName || oldName != null && oldName.equals(newName)) && (oldTNS == newTNS || oldTNS != null && oldTNS.equals(newTNS))) {
                    element.setTypeDefinition((XSDTypeDefinition)newType);
                }
            }
            return element.getTypeDefinition();
        }
        if (feature.getType() != null) {
            return feature.getType();
        }
        if (feature.getResolvedFeature() != null && feature.getResolvedFeature().getType() != null) {
            return feature.getResolvedFeature().getType();
        }
        return null;
    }

    public static XSDTypeDefinition getRootType(XSDTypeDefinition type) {
        if (type == null) {
            return null;
        }
        XSDTypeDefinition baseType = type.getBaseType();
        while (baseType != null && !XSDConstants.isAnySimpleType((XSDTypeDefinition)baseType) && !XSDConstants.isAnyType((XSDTypeDefinition)baseType)) {
            type = baseType;
            baseType = type.getBaseType();
        }
        return type;
    }

    public static List<XSDSimpleTypeDefinition> getUserDefinedSimpleTypes(XSDSchema schema) {
        if (schema == null) {
            return Collections.emptyList();
        }
        ArrayList<XSDSimpleTypeDefinition> result = new ArrayList<XSDSimpleTypeDefinition>();
        for (Object next : schema.getContents()) {
            if (!(next instanceof XSDSimpleTypeDefinition)) continue;
            result.add((XSDSimpleTypeDefinition)next);
        }
        return result;
    }

    public static boolean isRestrictedPrimitiveType(XSDTypeDefinition type) {
        if (type instanceof XSDComplexTypeDefinition) {
            return false;
        }
        XSDTypeDefinition baseType = XSDUtils.getRootType(type);
        return XSDUtils.getAdvancedPrimitives().contains(baseType);
    }

    public static int getMinOccurs(XSDFeature xsdElem) {
        if (xsdElem.eContainer() instanceof XSDAttributeUse) {
            return ((XSDAttributeUse)xsdElem.eContainer()).getUse() == XSDAttributeUseCategory.REQUIRED_LITERAL ? 1 : 0;
        }
        XSDParticle particle = (XSDParticle)xsdElem.eContainer();
        int min = 1;
        if (particle.isSetMinOccurs()) {
            min = particle.getMinOccurs();
        }
        return min;
    }

    public static int getMaxOccurs(XSDFeature xsdElem) {
        int max = 1;
        if (!(xsdElem.eContainer() instanceof XSDParticle)) {
            return max;
        }
        XSDParticle particle = (XSDParticle)xsdElem.eContainer();
        if (particle.isSetMaxOccurs()) {
            max = particle.getMaxOccurs();
        }
        return max;
    }

    public static String getDefaultValue(XSDFeature xsdElem) {
        XSDConstraint constraint = null;
        if (xsdElem instanceof XSDAttributeDeclaration) {
            XSDAttributeUse use = (XSDAttributeUse)xsdElem.getContainer();
            if (use.isSetConstraint()) {
                constraint = use.getConstraint();
            }
            if (constraint != null && constraint.equals((Object)XSDConstraint.DEFAULT_LITERAL)) {
                if (use.getLexicalValue() != null) {
                    return use.getLexicalValue();
                }
                return EMPTY_STRING;
            }
        } else if (xsdElem instanceof XSDElementDeclaration) {
            if (xsdElem.isSetConstraint()) {
                constraint = xsdElem.getConstraint();
            }
            if (constraint != null && constraint.equals((Object)XSDConstraint.DEFAULT_LITERAL)) {
                if (xsdElem.getLexicalValue() != null) {
                    return xsdElem.getLexicalValue();
                }
                return EMPTY_STRING;
            }
        }
        return EMPTY_STRING;
    }

    public static XSDComplexTypeDefinition getEnclosingTypeDefinition(EObject component) {
        if (component == null) {
            return null;
        }
        if (component instanceof XSDComplexTypeDefinition) {
            return (XSDComplexTypeDefinition)component;
        }
        return XSDUtils.getEnclosingTypeDefinition(component.eContainer());
    }
}

