/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.meson.core;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class Activator
implements BundleActivator {
    private static BundleContext context;
    private static Activator plugin;
    private ResourceBundle resourceBundle;
    public static final String PLUGIN_ID = "org.eclipse.cdt.meson.core";

    public Activator() {
        Assert.isTrue((plugin == null ? 1 : 0) != 0);
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.cdt.meson.core.Resources");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static String getUniqueIdentifier() {
        if (Activator.getDefault() == null) {
            return PLUGIN_ID;
        }
        return context.getBundle().getSymbolicName();
    }

    public Bundle getBundle() {
        return context.getBundle();
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static <T> T getService(Class<T> service) {
        if (context != null) {
            ServiceReference ref = context.getServiceReference(service);
            return (T)(ref != null ? context.getService(ref) : null);
        }
        return null;
    }

    public static void error(String message, Throwable cause) {
        Activator.log(Activator.errorStatus(message, cause));
    }

    public static IStatus errorStatus(String message, Throwable cause) {
        return new Status(4, PLUGIN_ID, message, cause);
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = Activator.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public static String getFormattedString(String key, String[] args) {
        return MessageFormat.format(Activator.getResourceString(key), args);
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static void log(IStatus status) {
        ResourcesPlugin.getPlugin().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        Activator.log((IStatus)new Status(4, Activator.getUniqueIdentifier(), 4, message, null));
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        Object status = null;
        status = e instanceof CoreException ? ((CoreException)e).getStatus() : new Status(4, Activator.getUniqueIdentifier(), 0, e.getMessage(), e);
        Activator.log(status);
    }

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) {
        context = bundleContext;
    }

    public void stop(BundleContext bundleContext) {
        context = null;
        plugin = null;
    }
}

