/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class HandleRevisionsRequest
extends CDOClientRequest<Boolean> {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, HandleRevisionsRequest.class);
    private EClass eClass;
    private CDOBranch branch;
    private boolean exactBranch;
    private long timeStamp;
    private boolean exactTime;
    private CDORevisionHandler handler;

    public HandleRevisionsRequest(CDOClientProtocol protocol, EClass eClass, CDOBranch branch, boolean exactBranch, long timeStamp, boolean exactTime, CDORevisionHandler handler) {
        super(protocol, (short)48);
        this.eClass = eClass;
        this.branch = branch;
        this.exactBranch = exactBranch;
        this.timeStamp = timeStamp;
        this.exactTime = exactTime;
        this.handler = handler;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        if (this.eClass != null) {
            out.writeBoolean(true);
            if (TRACER.isEnabled()) {
                TRACER.format("Writing eClass: {0}", new Object[]{this.eClass});
            }
            out.writeCDOClassifierRef((EClassifier)this.eClass);
        } else {
            out.writeBoolean(false);
        }
        if (this.branch != null) {
            out.writeBoolean(true);
            if (TRACER.isEnabled()) {
                TRACER.format("Writing branch: {0}", new Object[]{this.branch});
            }
            out.writeCDOBranch(this.branch);
            if (TRACER.isEnabled()) {
                TRACER.format("Writing exactBranch: {0}", new Object[]{this.exactBranch});
            }
            out.writeBoolean(this.exactBranch);
        } else {
            out.writeBoolean(false);
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Writing timeStamp: {0}", new Object[]{CDOCommonUtil.formatTimeStamp((long)this.timeStamp)});
        }
        out.writeXLong(this.timeStamp);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing exactTime: {0}", new Object[]{this.exactTime});
        }
        out.writeBoolean(this.exactTime);
    }

    @Override
    protected Boolean confirming(CDODataInput in) throws IOException {
        while (in.readBoolean()) {
            CDORevision revision = in.readCDORevision();
            if (TRACER.isEnabled()) {
                TRACER.format("Read revision: {0}", new Object[]{revision});
            }
            this.handler.handleRevision(revision);
        }
        return true;
    }
}

