/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.internal.compare;

import java.io.IOException;
import java.util.Objects;
import org.eclipse.emf.cdo.common.lob.CDOBlob;
import org.eclipse.emf.cdo.common.lob.CDOClob;
import org.eclipse.emf.cdo.common.lob.CDOLob;
import org.eclipse.emf.cdo.common.lob.CDOLobStore;
import org.eclipse.emf.cdo.etypes.EtypesPackage;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.IModelUpdateStrategy;
import org.eclipse.emf.compare.rcp.ui.internal.util.MergeViewerUtil;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.spi.cdo.InternalCDOSession;

public class CDOLobAttributeModelUpdateStrategy
implements IModelUpdateStrategy {
    public boolean canUpdate(Diff diff, IMergeViewer.MergeViewerSide side) {
        return CDOLobAttributeModelUpdateStrategy.getTargetObject(diff, side) != null;
    }

    public Command getModelUpdateCommand(final Diff diff, final Object newValue, final IMergeViewer.MergeViewerSide side) {
        final EObject targetObject = CDOLobAttributeModelUpdateStrategy.getTargetObject(diff, side);
        final EAttribute attribute = ((AttributeChange)diff).getAttribute();
        return new ChangeCommand((Notifier)targetObject){

            public boolean canExecute() {
                if (!CDOLobAttributeModelUpdateStrategy.this.canUpdate(diff, side)) {
                    return false;
                }
                String oldValue = null;
                try {
                    CDOLob lob = (CDOLob)ReferenceUtil.safeEGet((EObject)targetObject, (EStructuralFeature)attribute);
                    if (lob != null) {
                        oldValue = lob.getString();
                    }
                }
                catch (IOException ex) {
                    OM.LOG.error((Throwable)ex);
                    return false;
                }
                if (Objects.equals(newValue, oldValue)) {
                    return false;
                }
                return super.canExecute();
            }

            protected void doExecute() {
                Object lob = null;
                try {
                    if (newValue != null) {
                        CDOLobStore lobStore;
                        InternalCDOSession session = (InternalCDOSession)CDOUtil.getSession((Object)targetObject);
                        CDOLobStore cDOLobStore = lobStore = session != null ? session.getLobStore() : null;
                        lob = attribute.getEAttributeType() == EtypesPackage.Literals.BLOB ? new CDOBlob((String)newValue, lobStore) : new CDOClob((String)newValue, lobStore);
                    }
                }
                catch (IOException ex) {
                    OM.LOG.error((Throwable)ex);
                    return;
                }
                targetObject.eSet((EStructuralFeature)attribute, lob);
            }
        };
    }

    private static EObject getTargetObject(Diff diff, IMergeViewer.MergeViewerSide side) {
        return MergeViewerUtil.getEObject((Match)diff.getMatch(), (IMergeViewer.MergeViewerSide)side);
    }
}

