/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.core.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.internal.l10n.DiagramCoreMessages;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;

public class AddCommand
extends AbstractTransactionalCommand {
    private IAdaptable parent;
    private IAdaptable child;
    private int index;

    public AddCommand(TransactionalEditingDomain editingDomain, IAdaptable parent, IAdaptable child) {
        this(editingDomain, parent, child, -1);
    }

    public AddCommand(TransactionalEditingDomain editingDomain, IAdaptable parent, IAdaptable child, int index) {
        super(editingDomain, DiagramCoreMessages.AddCommand_Label, null);
        assert (parent != null) : "Null parent in AddCommand";
        assert (child != null) : "Null child in AddCommand";
        this.parent = parent;
        this.child = child;
        this.index = index;
    }

    public List getAffectedFiles() {
        View view = (View)this.parent.getAdapter(View.class);
        if (view != null) {
            ArrayList<IFile> result = new ArrayList<IFile>();
            IFile file = WorkspaceSynchronizer.getFile((Resource)view.eResource());
            if (file != null) {
                result.add(file);
            }
            return result;
        }
        return super.getAffectedFiles();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        View childView = (View)this.child.getAdapter(View.class);
        View parentView = (View)this.parent.getAdapter(View.class);
        if (this.index == -1) {
            parentView.insertChild(childView);
        } else {
            parentView.insertChildAt(childView, this.index);
        }
        return CommandResult.newOKCommandResult();
    }

    public String getLabel() {
        return DiagramCoreMessages.AddCommand_Label;
    }
}

