/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaHotCodeReplaceListener;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.HotCodeReplaceErrorDialog;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.ScrapbookLauncher;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class JavaHotCodeReplaceListener
implements IJavaHotCodeReplaceListener {
    private HotCodeReplaceErrorDialog fHotCodeReplaceFailedErrorDialog = null;
    private ILabelProvider fLabelProvider = DebugUITools.newDebugModelPresentation();

    public void hotCodeReplaceSucceeded(IJavaDebugTarget target) {
    }

    public void hotCodeReplaceFailed(IJavaDebugTarget target, DebugException exception) {
        String alertMessage;
        String preference;
        Status status;
        String launchName;
        if (exception != null && !JDIDebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IJDIPreferencesConstants.PREF_ALERT_HCR_FAILED) || exception == null && !JDIDebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IJDIPreferencesConstants.PREF_ALERT_HCR_NOT_SUPPORTED)) {
            return;
        }
        ILaunch launch = target.getLaunch();
        if (launch.getAttribute(ScrapbookLauncher.SCRAPBOOK_LAUNCH) != null && !target.supportsHotCodeReplace()) {
            return;
        }
        final Display display = JDIDebugUIPlugin.getStandardDisplay();
        if (display.isDisposed()) {
            return;
        }
        String name = null;
        try {
            name = target.getName();
        }
        catch (DebugException debugException) {
            name = this.fLabelProvider.getText((Object)target);
        }
        String vmName = name;
        ILaunchConfiguration config = target.getLaunch().getLaunchConfiguration();
        String string = launchName = config != null ? config.getName() : DebugUIMessages.JavaHotCodeReplaceListener_0;
        if (exception == null) {
            status = new Status(2, JDIDebugUIPlugin.getUniqueIdentifier(), 2, DebugUIMessages.JDIDebugUIPlugin_The_target_VM_does_not_support_hot_code_replace_1, null);
            preference = IJDIPreferencesConstants.PREF_ALERT_HCR_NOT_SUPPORTED;
            alertMessage = DebugUIMessages.JDIDebugUIPlugin_3;
        } else {
            status = new Status(2, JDIDebugUIPlugin.getUniqueIdentifier(), 2, exception.getMessage(), exception.getCause());
            preference = IJDIPreferencesConstants.PREF_ALERT_HCR_FAILED;
            alertMessage = DebugUIMessages.JDIDebugUIPlugin_1;
        }
        final String title = DebugUIMessages.JDIDebugUIPlugin_Hot_code_replace_failed_1;
        final String message = NLS.bind((String)DebugUIMessages.JDIDebugUIPlugin__0__was_unable_to_replace_the_running_code_with_the_code_in_the_workspace__2, (Object[])new Object[]{vmName, launchName});
        display.asyncExec(new Runnable((IStatus)status, preference, alertMessage, target){
            private final /* synthetic */ IStatus val$status;
            private final /* synthetic */ String val$preference;
            private final /* synthetic */ String val$alertMessage;
            private final /* synthetic */ IJavaDebugTarget val$target;
            {
                this.val$status = iStatus;
                this.val$preference = string3;
                this.val$alertMessage = string4;
                this.val$target = iJavaDebugTarget;
            }

            @Override
            public void run() {
                Shell shell;
                if (display.isDisposed()) {
                    return;
                }
                if (JavaHotCodeReplaceListener.this.fHotCodeReplaceFailedErrorDialog != null && (shell = JavaHotCodeReplaceListener.this.fHotCodeReplaceFailedErrorDialog.getShell()) != null && !shell.isDisposed()) {
                    return;
                }
                shell = JDIDebugUIPlugin.getActiveWorkbenchShell();
                JavaHotCodeReplaceListener.this.fHotCodeReplaceFailedErrorDialog = new HotCodeReplaceErrorDialog(shell, title, message, this.val$status, this.val$preference, this.val$alertMessage, JDIDebugUIPlugin.getDefault().getPreferenceStore(), (IDebugTarget)this.val$target){

                    public boolean close() {
                        (this).JavaHotCodeReplaceListener.this.fHotCodeReplaceFailedErrorDialog = null;
                        return super.close();
                    }
                };
                JavaHotCodeReplaceListener.this.fHotCodeReplaceFailedErrorDialog.setBlockOnOpen(false);
                JavaHotCodeReplaceListener.this.fHotCodeReplaceFailedErrorDialog.open();
            }
        });
    }

    public void obsoleteMethods(IJavaDebugTarget target) {
        if (!JDIDebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IJDIPreferencesConstants.PREF_ALERT_OBSOLETE_METHODS)) {
            return;
        }
        final Display display = JDIDebugUIPlugin.getStandardDisplay();
        if (display.isDisposed()) {
            return;
        }
        String vmName = this.fLabelProvider.getText((Object)target);
        final String dialogTitle = DebugUIMessages.JDIDebugUIPlugin_Obsolete_methods_remain_1;
        final String message = NLS.bind((String)DebugUIMessages.JDIDebugUIPlugin__0__contains_obsolete_methods_1, (Object[])new Object[]{vmName});
        Status status = new Status(2, JDIDebugUIPlugin.getUniqueIdentifier(), 2, DebugUIMessages.JDIDebugUIPlugin_Stepping_may_be_hazardous_1, null);
        String toggleMessage = DebugUIMessages.JDIDebugUIPlugin_2;
        display.asyncExec(new Runnable((IStatus)status, toggleMessage, target){
            private final /* synthetic */ IStatus val$status;
            private final /* synthetic */ String val$toggleMessage;
            private final /* synthetic */ IJavaDebugTarget val$target;
            {
                this.val$status = iStatus;
                this.val$toggleMessage = string3;
                this.val$target = iJavaDebugTarget;
            }

            @Override
            public void run() {
                if (display.isDisposed()) {
                    return;
                }
                Shell shell = JDIDebugUIPlugin.getActiveWorkbenchShell();
                HotCodeReplaceErrorDialog dialog = new HotCodeReplaceErrorDialog(shell, dialogTitle, message, this.val$status, IJDIPreferencesConstants.PREF_ALERT_OBSOLETE_METHODS, this.val$toggleMessage, JDIDebugUIPlugin.getDefault().getPreferenceStore(), (IDebugTarget)this.val$target);
                dialog.setBlockOnOpen(false);
                dialog.open();
            }
        });
    }
}

