/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.propertypages;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.propertypages.PropertyPageMessages;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class InstanceFilterEditor {
    private IJavaBreakpoint fBreakpoint;
    private CheckboxTableViewer fInstanceViewer;
    private Composite fParent;
    private InstanceFilterContentProvider fContentProvider;
    private CheckHandler fCheckHandler;

    public InstanceFilterEditor(Composite parent, IJavaBreakpoint breakpoint) {
        this.fBreakpoint = breakpoint;
        this.fContentProvider = new InstanceFilterContentProvider();
        this.fCheckHandler = new CheckHandler();
        Label label = new Label(parent, 0);
        label.setFont(parent.getFont());
        label.setText(PropertyPageMessages.InstanceFilterEditor_0);
        this.fParent = parent;
        this.createViewer();
    }

    protected void createViewer() {
        GridData data = new GridData(1808);
        data.heightHint = 100;
        this.fInstanceViewer = CheckboxTableViewer.newCheckList((Composite)this.fParent, (int)2048);
        this.fInstanceViewer.addCheckStateListener((ICheckStateListener)this.fCheckHandler);
        this.fInstanceViewer.getTable().setLayoutData((Object)data);
        this.fInstanceViewer.setContentProvider((IContentProvider)this.fContentProvider);
        IDebugModelPresentation pres = DebugUITools.newDebugModelPresentation();
        pres.setAttribute("DISPLAY_QUALIFIED_NAMES", (Object)Boolean.TRUE);
        this.fInstanceViewer.setLabelProvider((IBaseLabelProvider)pres);
        this.fInstanceViewer.setInput((Object)this.fBreakpoint);
        this.setInitialCheckedState();
    }

    protected void setInitialCheckedState() {
        try {
            IJavaObject[] iJavaObjectArray = this.fBreakpoint.getInstanceFilters();
            int n = iJavaObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaObject object = iJavaObjectArray[n2];
                this.fCheckHandler.checkObject(object, true);
                ++n2;
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
    }

    protected void doStore() {
        try {
            IJavaObject[] iJavaObjectArray = this.fBreakpoint.getInstanceFilters();
            int n = iJavaObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaObject object = iJavaObjectArray[n2];
                if (!this.fInstanceViewer.getChecked((Object)object)) {
                    this.fBreakpoint.removeInstanceFilter(object);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
    }

    class CheckHandler
    implements ICheckStateListener {
        CheckHandler() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            InstanceFilterEditor.this.fInstanceViewer.setChecked(event.getElement(), event.getChecked());
        }

        public void checkObject(IJavaObject object, boolean checked) {
            InstanceFilterEditor.this.fInstanceViewer.setChecked((Object)object, checked);
        }
    }

    class InstanceFilterContentProvider
    implements ITreeContentProvider {
        InstanceFilterContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof IJavaBreakpoint) {
                try {
                    return ((IJavaBreakpoint)parent).getInstanceFilters();
                }
                catch (CoreException e) {
                    JDIDebugUIPlugin.log(e);
                }
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IJavaObject) {
                return InstanceFilterEditor.this.fBreakpoint;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IJavaBreakpoint) {
                return this.getChildren(element).length > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

