/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.internal.context.xpath.java;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.common.core.internal.utility.SimpleTextRange;
import org.eclipse.jpt.common.core.internal.utility.ValidationMessageTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.ValidationMessage;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementIterable;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jaxb.core.JaxbNode;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbPackageInfo;
import org.eclipse.jpt.jaxb.core.context.XmlNs;
import org.eclipse.jpt.jaxb.core.context.XmlNsForm;
import org.eclipse.jpt.jaxb.core.context.XmlSchema;
import org.eclipse.jpt.jaxb.core.context.java.JavaXmlSchema;
import org.eclipse.jpt.jaxb.core.xsd.XsdAttributeUse;
import org.eclipse.jpt.jaxb.core.xsd.XsdElementDeclaration;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.jpt.jaxb.eclipselink.core.validation.JptJaxbEclipseLinkCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class XPath {
    public static String DELIM = "/";
    public static char DELIM_CHAR = (char)47;
    public static String ATT_PREFIX = "@";
    public static String TEXT = "text()";
    public static String SELF = ".";
    public static String COLON = ":";
    public static char OPEN_BRACKET = (char)91;
    public static char CLOSE_BRACKET = (char)93;
    List<Step> steps = new Vector<Step>();

    public static String attributeXPath(String prefix, String localName) {
        if (prefix == null) {
            return StringTools.concatenate((String[])new String[]{ATT_PREFIX, localName});
        }
        return StringTools.concatenate((String[])new String[]{ATT_PREFIX, prefix, COLON, localName});
    }

    public static String elementXPath(String prefix, String localName) {
        if (prefix == null) {
            return localName;
        }
        return StringTools.concatenate((String[])new String[]{prefix, COLON, localName});
    }

    XPath(String xpathString) {
        this.parse(xpathString);
    }

    protected int getIndex(Step step) {
        return this.steps.indexOf(step);
    }

    protected Step getFirstStep() {
        if (this.steps.size() > 0) {
            return this.steps.get(0);
        }
        return null;
    }

    protected Step getNextStep(Step step) {
        int nextIndex = this.getIndex(step) + 1;
        if (this.steps.size() > nextIndex) {
            return this.steps.get(nextIndex);
        }
        return null;
    }

    protected void parse(String xpath) {
        int nextDelim = this.findNextDelim(xpath);
        while (nextDelim >= 0) {
            this.steps.add(this.createStep(xpath.substring(0, nextDelim)));
            xpath = xpath.substring(nextDelim + 1);
            nextDelim = this.findNextDelim(xpath);
        }
        this.steps.add(this.createStep(xpath));
    }

    protected int findNextDelim(String xpath) {
        boolean foundOpenBracket = false;
        int i = 0;
        while (i < xpath.length()) {
            char currentChar = xpath.charAt(i);
            if (currentChar == DELIM_CHAR && !foundOpenBracket) {
                return i;
            }
            if (currentChar == OPEN_BRACKET) {
                foundOpenBracket = true;
            } else if (currentChar == CLOSE_BRACKET) {
                foundOpenBracket = false;
            }
            ++i;
        }
        return -1;
    }

    protected Step createStep(String stepValue) {
        if (TEXT.equals(stepValue)) {
            return new TextStep();
        }
        if (SELF.equals(stepValue)) {
            return new SelfStep();
        }
        if (stepValue.startsWith(ATT_PREFIX)) {
            return this.tryCreateAttributeStep(stepValue);
        }
        return this.tryCreateElementStep(stepValue);
    }

    protected Step tryCreateAttributeStep(String stepValue) {
        try {
            String attributeStepValue = stepValue.substring(1);
            Object[] stepParts = this.parseStepParts(attributeStepValue);
            return new AttributeStep(stepParts[0], stepParts[1], (String[])ArrayTools.subArray((Object[])stepParts, (int)2, (int)stepParts.length));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new InvalidStep(stepValue);
        }
    }

    protected Step tryCreateElementStep(String stepValue) {
        try {
            Object[] stepParts = this.parseStepParts(stepValue);
            return new ElementStep(stepParts[0], stepParts[1], (String[])ArrayTools.subArray((Object[])stepParts, (int)2, (int)stepParts.length));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new InvalidStep(stepValue);
        }
    }

    protected String[] parseStepParts(String stepValue) {
        Object[] predicate = new String[]{};
        int predicateStart = stepValue.lastIndexOf(OPEN_BRACKET);
        while (predicateStart >= 0) {
            int predicateEnd = stepValue.lastIndexOf(CLOSE_BRACKET);
            if (predicateEnd <= predicateStart || predicateEnd != stepValue.length() - 1) {
                throw new IllegalArgumentException();
            }
            predicate = (String[])ArrayTools.add((Object[])predicate, (int)0, (Object)stepValue.substring(predicateStart + 1, predicateEnd));
            stepValue = stepValue.substring(0, predicateStart);
            predicateStart = stepValue.lastIndexOf(OPEN_BRACKET);
        }
        String nsPrefix = null;
        int colon = stepValue.indexOf(COLON);
        if (colon > 0) {
            if (stepValue.indexOf(COLON, colon + 1) != -1) {
                throw new IllegalArgumentException();
            }
            nsPrefix = stepValue.substring(0, colon);
            stepValue = stepValue.substring(colon + 1);
        }
        if (StringTools.isBlank((String)stepValue) || stepValue.indexOf(COLON) >= 0 || stepValue.indexOf(OPEN_BRACKET) >= 0 || stepValue.indexOf(CLOSE_BRACKET) >= 0 || stepValue.indexOf(32) >= 0) {
            throw new IllegalArgumentException();
        }
        Object[] result = (String[])ArrayTools.add((Object[])new String[0], (Object)nsPrefix);
        result = (String[])ArrayTools.add((Object[])result, (Object)stepValue);
        result = (String[])ArrayTools.addAll((Object[])result, (Object[])predicate);
        return result;
    }

    public Iterable<String> getCompletionProposals(Context context, XsdTypeDefinition xsdType, int pos) {
        return this.getFirstStep().getCompletionProposals(context, xsdType, "", pos);
    }

    public void validate(Context context, XsdTypeDefinition xsdType, List<IMessage> messages) {
        this.getFirstStep().validate(context, xsdType, messages);
    }

    protected TextRange buildTextRange(Context context, Step step) {
        TextRange entireTextRange = context.getTextRange();
        int start = 0;
        for (Step each : this.steps) {
            int length = each.getValue().length() + 2;
            if (each == step) {
                return new SimpleTextRange(entireTextRange.getOffset() + start, length, entireTextRange.getLineNumber());
            }
            start += length - 1;
        }
        throw new IllegalArgumentException("Step must be in list of this XPath's steps.");
    }

    public static abstract class AbstractContext
    implements Context {
        protected Map<String, String> namespaceMap;

        public AbstractContext() {
            this.buildNamespaceMap();
        }

        protected void buildNamespaceMap() {
            this.namespaceMap = new HashMap<String, String>();
            for (XmlNs xmlns : this.getXmlNsInfos()) {
                String prefix = xmlns.getPrefix();
                if (ObjectTools.equals((Object)"", (Object)prefix)) {
                    prefix = null;
                }
                this.namespaceMap.put(prefix, xmlns.getNamespaceURI());
            }
        }

        protected Iterable<XmlNs> getXmlNsInfos() {
            XmlSchema xmlSchema = this.getXmlSchema();
            return xmlSchema == null ? EmptyIterable.instance() : xmlSchema.getXmlNsPrefixes();
        }

        protected XmlSchema getXmlSchema() {
            JaxbPackageInfo pkgInfo = this.getJaxbPackage().getPackageInfo();
            return pkgInfo == null ? null : pkgInfo.getXmlSchema();
        }

        @Override
        public String getAttributeNamespace(String prefix) {
            String namespace = "";
            if (this.namespaceMap.containsKey(prefix)) {
                namespace = this.namespaceMap.get(prefix);
            }
            XmlSchema xmlSchema = this.getXmlSchema();
            if (prefix == null && xmlSchema != null && xmlSchema.getAttributeFormDefault() == XmlNsForm.QUALIFIED) {
                return null;
            }
            return namespace;
        }

        @Override
        public String getElementNamespace(String prefix) {
            if (this.namespaceMap.containsKey(prefix)) {
                return this.namespaceMap.get(prefix);
            }
            XmlSchema xmlSchema = this.getXmlSchema();
            if (xmlSchema != null && xmlSchema.getElementFormDefault() == XmlNsForm.QUALIFIED) {
                return xmlSchema.getNamespace();
            }
            return "";
        }
    }

    protected class AttributeStep
    extends NamedComponentStep {
        protected AttributeStep(String nsPrefix, String localName, String[] predicates) {
            super(nsPrefix, localName, predicates);
        }

        @Override
        protected String getValue() {
            return String.valueOf(ATT_PREFIX) + super.getValue();
        }

        @Override
        protected String resolveNamespace(Context context) {
            return context.getAttributeNamespace(this.nsPrefix);
        }

        @Override
        protected XsdTypeDefinition resolveNextType(Context context, XsdTypeDefinition previousType) {
            String namespace = this.resolveNamespace(context);
            if (namespace == null) {
                return null;
            }
            XsdAttributeUse xsdAttribute = previousType.getAttribute(namespace, this.localName);
            return xsdAttribute == null ? null : xsdAttribute.getAttributeDeclaration().getType();
        }

        @Override
        protected void validate(Context context, XsdTypeDefinition previousType, List<IMessage> messages) {
            if (this.getNextStep() != null) {
                messages.add(ValidationMessageTools.buildValidationMessage((IResource)context.getContextObject().getResource(), (TextRange)this.getTextRange(context), (ValidationMessage)JptJaxbEclipseLinkCoreValidationMessages.XPATH__ATTRIBUTE_SEGMENT_MUST_BE_LAST_SEGMENT));
                return;
            }
            super.validate(context, previousType, messages);
        }

        @Override
        protected XsdTypeDefinition validateLocalName(Context context, XsdTypeDefinition previousType, String namespace, List<IMessage> messages) {
            XsdAttributeUse xsdAttribute = previousType.getAttribute(namespace, this.localName);
            if (xsdAttribute == null) {
                messages.add(ValidationMessageTools.buildValidationMessage((IResource)context.getContextObject().getResource(), (TextRange)this.getTextRange(context), (ValidationMessage)JptJaxbEclipseLinkCoreValidationMessages.XPATH__UNRESOLVED_ATTRIBUTE, (Object[])new Object[]{namespace, this.localName}));
                return null;
            }
            return xsdAttribute.getAttributeDeclaration().getType();
        }
    }

    public static interface Context {
        public JaxbNode getContextObject();

        public JaxbPackage getJaxbPackage();

        public String getAttributeNamespace(String var1);

        public String getElementNamespace(String var1);

        public TextRange getTextRange();
    }

    protected class ElementStep
    extends NamedComponentStep {
        protected ElementStep(String nsPrefix, String localName, String[] predicates) {
            super(nsPrefix, localName, predicates);
        }

        @Override
        protected String resolveNamespace(Context context) {
            return context.getElementNamespace(this.nsPrefix);
        }

        @Override
        protected XsdTypeDefinition resolveNextType(Context context, XsdTypeDefinition previousType) {
            String namespace = this.resolveNamespace(context);
            if (namespace == null) {
                return null;
            }
            XsdElementDeclaration xsdElement = previousType.getElement(namespace, this.localName);
            return xsdElement == null ? null : xsdElement.getType();
        }

        @Override
        protected XsdTypeDefinition validateLocalName(Context context, XsdTypeDefinition previousType, String namespace, List<IMessage> messages) {
            XsdElementDeclaration xsdElement = previousType.getElement(namespace, this.localName);
            if (xsdElement == null) {
                messages.add(ValidationMessageTools.buildValidationMessage((IResource)context.getContextObject().getResource(), (TextRange)this.getTextRange(context), (ValidationMessage)JptJaxbEclipseLinkCoreValidationMessages.XPATH__UNRESOLVED_ELEMENT, (Object[])new Object[]{namespace, this.localName}));
                return null;
            }
            return xsdElement.getType();
        }
    }

    protected class InvalidStep
    extends Step {
        protected String value;

        protected InvalidStep(String value) {
            this.value = value;
        }

        @Override
        protected String getValue() {
            return this.value;
        }

        @Override
        protected XsdTypeDefinition resolveNextType(Context context, XsdTypeDefinition previousType) {
            return null;
        }

        @Override
        protected void validate(Context context, XsdTypeDefinition previousType, List<IMessage> messages) {
            messages.add(ValidationMessageTools.buildValidationMessage((IResource)context.getContextObject().getResource(), (TextRange)this.getTextRange(context), (ValidationMessage)JptJaxbEclipseLinkCoreValidationMessages.XPATH__INVALID_FORM_ILLEGAL_SEGMENT, (Object[])new Object[]{this.getValue()}));
        }
    }

    protected abstract class NamedComponentStep
    extends Step {
        protected String nsPrefix;
        protected String localName;
        protected List<String> predicates;

        protected NamedComponentStep(String nsPrefix, String localName, String[] predicates) {
            this.nsPrefix = nsPrefix;
            this.localName = localName;
            this.predicates = new Vector<String>();
            CollectionTools.addAll(this.predicates, (Object[])predicates);
        }

        @Override
        protected String getValue() {
            StringBuffer sb = new StringBuffer();
            if (this.nsPrefix != null) {
                sb.append(this.nsPrefix);
                sb.append(COLON);
            }
            sb.append(this.localName);
            for (String predicate : this.predicates) {
                sb.append(OPEN_BRACKET);
                sb.append(predicate);
                sb.append(CLOSE_BRACKET);
            }
            return sb.toString();
        }

        protected abstract String resolveNamespace(Context var1);

        @Override
        protected void validate(Context context, XsdTypeDefinition previousType, List<IMessage> messages) {
            Step nextStep;
            XsdTypeDefinition nextType;
            if (previousType == null) {
                return;
            }
            String namespace = this.resolveNamespace(context);
            if (namespace == null) {
                messages.add(ValidationMessageTools.buildValidationMessage((IResource)context.getContextObject().getResource(), (TextRange)this.getTextRange(context), (ValidationMessage)JptJaxbEclipseLinkCoreValidationMessages.XPATH__INVALID_NS_PREFIX, (Object[])new Object[]{this.nsPrefix}));
            }
            if ((nextType = this.validateLocalName(context, previousType, namespace, messages)) != null && (nextStep = this.getNextStep()) != null) {
                nextStep.validate(context, nextType, messages);
            }
        }

        protected abstract XsdTypeDefinition validateLocalName(Context var1, XsdTypeDefinition var2, String var3, List<IMessage> var4);
    }

    public static class PrefixToAttributeNamesTransformer
    extends TransformerAdapter<String, Iterable<String>> {
        protected final Context context;
        protected final XsdTypeDefinition xsdType;

        public PrefixToAttributeNamesTransformer(Context context, XsdTypeDefinition xsdType) {
            this.context = context;
            this.xsdType = xsdType;
        }

        public Iterable<String> transform(String prefix) {
            String namespace = this.context.getAttributeNamespace(prefix);
            if (namespace == null) {
                return EmptyIterable.instance();
            }
            if ("".equals(namespace)) {
                namespace = null;
            }
            return IterableTools.transform((Iterable)this.xsdType.getAttributeNames(namespace), (Transformer)new PrefixedAttributeNameTransformer(prefix));
        }
    }

    public static class PrefixToElementNamesTransformer
    extends TransformerAdapter<String, Iterable<String>> {
        protected final Context context;
        protected final XsdTypeDefinition xsdType;

        public PrefixToElementNamesTransformer(Context context, XsdTypeDefinition xsdType) {
            this.context = context;
            this.xsdType = xsdType;
        }

        public Iterable<String> transform(String prefix) {
            String namespace = this.context.getElementNamespace(prefix);
            if (namespace == null) {
                return EmptyIterable.instance();
            }
            if ("".equals(namespace)) {
                namespace = null;
            }
            return IterableTools.transform((Iterable)this.xsdType.getElementNames(namespace, false), (Transformer)new PrefixedElementNameTransformer(prefix));
        }
    }

    public static class PrefixedAttributeNameTransformer
    extends TransformerAdapter<String, String> {
        protected final String prefix;

        public PrefixedAttributeNameTransformer(String prefix) {
            this.prefix = prefix;
        }

        public String transform(String localName) {
            return XPath.attributeXPath(this.prefix, localName);
        }
    }

    public static class PrefixedElementNameTransformer
    extends TransformerAdapter<String, String> {
        protected final String prefix;

        public PrefixedElementNameTransformer(String prefix) {
            this.prefix = prefix;
        }

        public String transform(String localName) {
            return XPath.elementXPath(this.prefix, localName);
        }
    }

    protected class SelfStep
    extends Step {
        protected SelfStep() {
        }

        @Override
        protected String getValue() {
            return SELF;
        }

        @Override
        protected XsdTypeDefinition resolveNextType(Context context, XsdTypeDefinition previousType) {
            return previousType;
        }

        @Override
        protected void validate(Context context, XsdTypeDefinition previousType, List<IMessage> messages) {
            if (this.getIndex() != 0) {
                messages.add(ValidationMessageTools.buildValidationMessage((IResource)context.getContextObject().getResource(), (TextRange)this.getTextRange(context), (ValidationMessage)JptJaxbEclipseLinkCoreValidationMessages.XPATH__SELF_SEGMENT_MUST_BE_FIRST_SEGMENT));
                return;
            }
            if (this.getNextStep() != null) {
                this.getNextStep().validate(context, previousType, messages);
            }
        }
    }

    protected abstract class Step {
        protected Step() {
        }

        protected int getIndex() {
            return XPath.this.getIndex(this);
        }

        protected Step getNextStep() {
            return XPath.this.getNextStep(this);
        }

        protected abstract String getValue();

        protected abstract XsdTypeDefinition resolveNextType(Context var1, XsdTypeDefinition var2);

        protected Iterable<String> getCompletionProposals(Context context, XsdTypeDefinition previousType, String prefix, int pos) {
            if (this.getTextRange(context).includes(pos) || this.getNextStep() == null) {
                StringPrefixer transformer = new StringPrefixer(prefix);
                return IterableTools.transform((Iterable)IterableTools.transform((Iterable)IterableTools.concatenate((Iterable[])new Iterable[]{this.getTextProposals(context, previousType), this.getAttributeProposals(context, previousType), this.getElementProposals(context, previousType)}), (Transformer)transformer), (Transformer)StringTools.JAVA_STRING_LITERAL_CONTENT_TRANSFORMER);
            }
            Step nextStep = this.getNextStep();
            XsdTypeDefinition nextType = this.resolveNextType(context, previousType);
            if (nextStep != null && nextType != null) {
                return nextStep.getCompletionProposals(context, nextType, String.valueOf(prefix) + this.getValue() + DELIM, pos);
            }
            return new SingleElementIterable((Object)TEXT);
        }

        protected Iterable<String> getTextProposals(Context context, XsdTypeDefinition xsdType) {
            return xsdType.hasTextContent() ? new SingleElementIterable((Object)TEXT) : EmptyIterable.instance();
        }

        protected Iterable<String> getAttributeProposals(Context context, XsdTypeDefinition xsdType) {
            return IterableTools.concatenate((Iterable)IterableTools.transform(this.calculatePrefixes(context), (Transformer)new PrefixToAttributeNamesTransformer(context, xsdType)));
        }

        protected Iterable<String> getElementProposals(Context context, XsdTypeDefinition xsdType) {
            return IterableTools.concatenate((Iterable)IterableTools.transform(this.calculatePrefixes(context), (Transformer)new PrefixToElementNamesTransformer(context, xsdType)));
        }

        protected Iterable<String> calculatePrefixes(Context context) {
            JavaXmlSchema xmlSchema;
            HashSet<String> result = new HashSet<String>();
            result.add(null);
            JaxbPackage jaxbPackage = context.getJaxbPackage();
            JaxbPackageInfo pkgInfo = jaxbPackage == null ? null : jaxbPackage.getPackageInfo();
            JavaXmlSchema javaXmlSchema = xmlSchema = pkgInfo == null ? null : pkgInfo.getXmlSchema();
            if (xmlSchema != null) {
                for (XmlNs xmlns : xmlSchema.getXmlNsPrefixes()) {
                    String prefix = xmlns.getPrefix();
                    if ("".equals(prefix)) {
                        prefix = null;
                    }
                    result.add(prefix);
                }
            }
            return result;
        }

        protected void validate(Context context, XsdTypeDefinition previousType, List<IMessage> messages) {
        }

        protected TextRange getTextRange(Context context) {
            return XPath.this.buildTextRange(context, this);
        }
    }

    static class StringPrefixer
    extends TransformerAdapter<String, String> {
        private final String prefix;

        StringPrefixer(String prefix) {
            this.prefix = prefix;
        }

        public String transform(String s) {
            return StringTools.concatenate((String[])new String[]{this.prefix, s});
        }
    }

    protected class TextStep
    extends Step {
        protected TextStep() {
        }

        @Override
        protected String getValue() {
            return TEXT;
        }

        @Override
        protected XsdTypeDefinition resolveNextType(Context context, XsdTypeDefinition previousType) {
            return previousType;
        }

        @Override
        protected void validate(Context context, XsdTypeDefinition previousType, List<IMessage> messages) {
            if (this.getNextStep() != null) {
                messages.add(ValidationMessageTools.buildValidationMessage((IResource)context.getContextObject().getResource(), (TextRange)this.getTextRange(context), (ValidationMessage)JptJaxbEclipseLinkCoreValidationMessages.XPATH__TEXT_SEGMENT_MUST_BE_LAST_SEGMENT));
            }
        }
    }
}

