/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.common.ui.internal.swt.bindings.SWTBindingTools;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.SuperListIterableWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ModifiablePropertyCollectionValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiableCollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.AssociationOverride;
import org.eclipse.jpt.jpa.core.context.AssociationOverrideContainer;
import org.eclipse.jpt.jpa.core.context.AttributeOverride;
import org.eclipse.jpt.jpa.core.context.AttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.Override_;
import org.eclipse.jpt.jpa.core.context.SpecifiedAssociationOverride;
import org.eclipse.jpt.jpa.core.context.SpecifiedAttributeOverride;
import org.eclipse.jpt.jpa.core.context.SpecifiedOverride;
import org.eclipse.jpt.jpa.core.context.VirtualAssociationOverride;
import org.eclipse.jpt.jpa.core.context.VirtualAttributeOverride;
import org.eclipse.jpt.jpa.core.context.VirtualOverride;
import org.eclipse.jpt.jpa.ui.details.JptJpaUiDetailsMessages;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.jpt.jpa.ui.internal.details.AssociationOverrideComposite;
import org.eclipse.jpt.jpa.ui.internal.details.AttributeOverrideComposite;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.PageBook;

public abstract class AbstractOverridesComposite<T extends JpaContextModel>
extends Pane<T> {
    private Pane<AttributeOverride> attributeOverridePane;
    private Pane<AssociationOverride> associationOverridePane;
    private ModifiablePropertyValueModel<Override_> selectedOverrideModel;
    private ModifiablePropertyValueModel<Boolean> overrideVirtualOverrideHolder;

    protected AbstractOverridesComposite(Pane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    protected void initialize() {
        super.initialize();
        this.selectedOverrideModel = this.buildSelectedOverrideModel();
    }

    private ModifiablePropertyValueModel<Override_> buildSelectedOverrideModel() {
        return new SimplePropertyValueModel();
    }

    protected abstract boolean supportsAssociationOverrides();

    protected void initializeLayout(Composite container) {
        this.initializeOverridesList(container);
        Button overrideCheckBox = this.addCheckBox(container, JptJpaUiDetailsMessages.OVERRIDES_COMPOSITE_OVERRIDE_DEFAULT, this.getOverrideVirtualOverrideHolder(), null);
        SWTBindingTools.bindVisibleState(this.buildSelectedOverrideBooleanHolder(), (Control[])new Control[]{overrideCheckBox});
        PageBook pageBook = this.addPageBook(container);
        this.installOverrideControlSwitcher((PropertyValueModel<Override_>)this.selectedOverrideModel, pageBook);
    }

    private PropertyValueModel<Boolean> buildSelectedOverrideBooleanHolder() {
        return new TransformationPropertyValueModel<Override_, Boolean>(this.selectedOverrideModel){

            protected Boolean transform(Override_ value) {
                return value != null;
            }
        };
    }

    private void initializeOverridesList(Composite container) {
        new AddRemoveListPane<T, Override_>(this, container, this.buildOverridesAdapter(), this.buildOverridesListModel(), (ModifiableCollectionValueModel)new ModifiablePropertyCollectionValueModelAdapter(this.selectedOverrideModel), this.buildOverrideLabelProvider(), JpaHelpContextIds.ENTITY_ATTRIBUTE_OVERRIDES){

            protected void initializeButtonPane(Composite c, String helpId) {
            }
        };
    }

    protected Pane<AttributeOverride> getAttributeOverridePane(PageBook pageBook) {
        if (this.attributeOverridePane == null) {
            PropertyValueModel<AttributeOverride> attributeOverrideHolder = this.buildAttributeOverrideHolder();
            this.attributeOverridePane = this.buildAttributeOverridePane(pageBook, attributeOverrideHolder);
        }
        return this.attributeOverridePane;
    }

    protected Pane<AttributeOverride> buildAttributeOverridePane(PageBook pageBook, PropertyValueModel<AttributeOverride> overrideHolder) {
        return new AttributeOverrideComposite(this, overrideHolder, this.buildOverrideBooleanHolder(overrideHolder), (Composite)pageBook);
    }

    private PropertyValueModel<Boolean> buildOverrideBooleanHolder(PropertyValueModel<? extends Override_> overrideHolder) {
        return new TransformationPropertyValueModel<Override_, Boolean>(overrideHolder){

            protected Boolean transform_(Override_ v) {
                return !v.isVirtual();
            }
        };
    }

    protected Pane<AssociationOverride> getAssociationOverridePane(PageBook pageBook) {
        if (this.associationOverridePane == null) {
            PropertyValueModel<AssociationOverride> associationOverrideModel = this.buildAssociationOverrideModel();
            this.associationOverridePane = this.buildAssociationOverridePane(pageBook, associationOverrideModel);
        }
        return this.associationOverridePane;
    }

    protected Pane<AssociationOverride> buildAssociationOverridePane(PageBook pageBook, PropertyValueModel<AssociationOverride> overrideHolder) {
        return new AssociationOverrideComposite(this, overrideHolder, this.buildOverrideBooleanHolder(overrideHolder), (Composite)pageBook);
    }

    private void installOverrideControlSwitcher(PropertyValueModel<Override_> overrideHolder, PageBook pageBook) {
        SWTBindingTools.bind(overrideHolder, this.buildPaneTransformer(pageBook), (PageBook)pageBook);
    }

    private PropertyValueModel<AssociationOverride> buildAssociationOverrideModel() {
        return new TransformationPropertyValueModel<Override_, AssociationOverride>(this.selectedOverrideModel){

            protected AssociationOverride transform_(Override_ v) {
                return v instanceof AssociationOverride ? (AssociationOverride)v : null;
            }
        };
    }

    private PropertyValueModel<AttributeOverride> buildAttributeOverrideHolder() {
        return new TransformationPropertyValueModel<Override_, AttributeOverride>(this.selectedOverrideModel){

            protected AttributeOverride transform_(Override_ v) {
                return v instanceof AttributeOverride ? (AttributeOverride)v : null;
            }
        };
    }

    private ListValueModel<VirtualAssociationOverride> buildDefaultAssociationOverridesListHolder(PropertyValueModel<AssociationOverrideContainer> containerHolder) {
        return new ListAspectAdapter<AssociationOverrideContainer, VirtualAssociationOverride>(containerHolder, new String[]{"virtualOverrides"}){

            protected ListIterable<VirtualAssociationOverride> getListIterable() {
                return new SuperListIterableWrapper(((AssociationOverrideContainer)this.subject).getVirtualOverrides());
            }

            protected int size_() {
                return ((AssociationOverrideContainer)this.subject).getVirtualOverridesSize();
            }
        };
    }

    private ListValueModel<VirtualAttributeOverride> buildDefaultAttributeOverridesListHolder(PropertyValueModel<AttributeOverrideContainer> containerHolder) {
        return new ListAspectAdapter<AttributeOverrideContainer, VirtualAttributeOverride>(containerHolder, new String[]{"virtualOverrides"}){

            protected ListIterable<VirtualAttributeOverride> getListIterable() {
                return new SuperListIterableWrapper(((AttributeOverrideContainer)this.subject).getVirtualOverrides());
            }

            protected int size_() {
                return ((AttributeOverrideContainer)this.subject).getVirtualOverridesSize();
            }
        };
    }

    protected ModifiablePropertyValueModel<Boolean> getOverrideVirtualOverrideHolder() {
        if (this.overrideVirtualOverrideHolder == null) {
            this.overrideVirtualOverrideHolder = this.buildOverrideVirtualOverrideHolder();
        }
        return this.overrideVirtualOverrideHolder;
    }

    private ModifiablePropertyValueModel<Boolean> buildOverrideVirtualOverrideHolder() {
        return new TransformationModifiablePropertyValueModel<Override_, Boolean>(this.selectedOverrideModel){

            public void setValue(Boolean value) {
                AbstractOverridesComposite.this.updateOverride(value);
            }

            protected Boolean transform_(Override_ v) {
                return !v.isVirtual();
            }
        };
    }

    String buildOverrideDisplayString(Override_ override) {
        String overrideType = override instanceof AssociationOverride ? JptJpaUiDetailsMessages.OVERRIDES_COMPOSITE_ASSOCIATION : JptJpaUiDetailsMessages.OVERRIDES_COMPOSITE_ATTRIBUTE;
        String name = override.getName();
        if (StringTools.isBlank((String)name)) {
            name = JptJpaUiDetailsMessages.OVERRIDES_COMPOSITE_NO_NAME;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append(" (");
        sb.append(overrideType);
        sb.append(") ");
        return sb.toString();
    }

    protected ILabelProvider buildOverrideLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                return AbstractOverridesComposite.this.buildOverrideDisplayString((Override_)element);
            }
        };
    }

    protected AddRemovePane.Adapter<Override_> buildOverridesAdapter() {
        return new AddRemovePane.AbstractAdapter<Override_>(){

            public Override_ addNewItem() {
                throw new UnsupportedOperationException();
            }

            public void removeSelectedItems(CollectionValueModel<Override_> selectedItemsModel) {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected ListValueModel<Override_> buildOverridesListHolder() {
        PropertyValueModel<AttributeOverrideContainer> attributeOverrideContainerHolder = this.buildAttributeOverrideContainerHolder();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.buildSpecifiedAttributeOverridesListHolder(attributeOverrideContainerHolder));
        list.add(this.buildDefaultAttributeOverridesListHolder(attributeOverrideContainerHolder));
        if (this.supportsAssociationOverrides()) {
            PropertyValueModel<AssociationOverrideContainer> associationOverrideContainerHolder = this.buildAssociationOverrideContainerHolder();
            list.add(this.buildSpecifiedAssociationOverridesListHolder(associationOverrideContainerHolder));
            list.add(this.buildDefaultAssociationOverridesListHolder(associationOverrideContainerHolder));
        }
        return CompositeListValueModel.forModels(list);
    }

    protected abstract PropertyValueModel<AttributeOverrideContainer> buildAttributeOverrideContainerHolder();

    protected abstract PropertyValueModel<AssociationOverrideContainer> buildAssociationOverrideContainerHolder();

    private ListValueModel<Override_> buildOverridesListModel() {
        return new ItemPropertyListValueModelAdapter(this.buildOverridesListHolder(), new String[]{"name"});
    }

    private Transformer<Override_, Control> buildPaneTransformer(PageBook pageBook) {
        return new PaneTransformer(pageBook);
    }

    protected Control transformSelectedOverride(Override_ selectedOverride, PageBook pageBook) {
        if (selectedOverride instanceof AttributeOverride) {
            return this.getAttributeOverridePane(pageBook).getControl();
        }
        if (selectedOverride instanceof AssociationOverride) {
            return this.getAssociationOverridePane(pageBook).getControl();
        }
        return null;
    }

    private ListValueModel<SpecifiedAssociationOverride> buildSpecifiedAssociationOverridesListHolder(PropertyValueModel<AssociationOverrideContainer> containerHolder) {
        return new ListAspectAdapter<AssociationOverrideContainer, SpecifiedAssociationOverride>(containerHolder, new String[]{"specifiedOverrides"}){

            protected ListIterable<SpecifiedAssociationOverride> getListIterable() {
                return new SuperListIterableWrapper(((AssociationOverrideContainer)this.subject).getSpecifiedOverrides());
            }

            protected int size_() {
                return ((AssociationOverrideContainer)this.subject).getSpecifiedOverridesSize();
            }
        };
    }

    private ListValueModel<SpecifiedAttributeOverride> buildSpecifiedAttributeOverridesListHolder(PropertyValueModel<AttributeOverrideContainer> containerHolder) {
        return new ListAspectAdapter<AttributeOverrideContainer, SpecifiedAttributeOverride>(containerHolder, new String[]{"specifiedOverrides"}){

            protected ListIterable<SpecifiedAttributeOverride> getListIterable() {
                return new SuperListIterableWrapper(((AttributeOverrideContainer)this.subject).getSpecifiedOverrides());
            }

            protected int size_() {
                return ((AttributeOverrideContainer)this.subject).getSpecifiedOverridesSize();
            }
        };
    }

    void updateOverride(boolean convertToSpecified) {
        if (this.isPopulating()) {
            return;
        }
        this.setPopulating(true);
        try {
            Override_ override = (Override_)this.selectedOverrideModel.getValue();
            SpecifiedOverride newOverride = convertToSpecified ? ((VirtualOverride)override).convertToSpecified() : ((SpecifiedOverride)override).convertToVirtual();
            this.selectedOverrideModel.setValue((Object)newOverride);
        }
        finally {
            this.setPopulating(false);
        }
    }

    protected class PaneTransformer
    extends TransformerAdapter<Override_, Control> {
        private final PageBook pageBook;

        protected PaneTransformer(PageBook pageBook) {
            this.pageBook = pageBook;
        }

        public Control transform(Override_ override) {
            return AbstractOverridesComposite.this.transformSelectedOverride(override, this.pageBook);
        }
    }
}

