/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.common.ui.internal.swt.widgets.DisplayTools;
import org.eclipse.jpt.common.ui.internal.utility.SynchronousUiCommandContext;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaProjectManager;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddToPersistenceUnitHandler
extends AbstractHandler {
    private IFile persistenceXmlFile;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        for (Map.Entry<IProject, Set<IType>> entry : this.buildSelectedTypes(selection).entrySet()) {
            IProject project = entry.getKey();
            Set<IType> types = entry.getValue();
            JpaProject jpaProject = (JpaProject)project.getAdapter(JpaProject.class);
            if (jpaProject == null) continue;
            try {
                PersistenceXml persistenceXml = jpaProject.getContextRoot().getPersistenceXml();
                if (persistenceXml == null) {
                    MessageDialog.openInformation((Shell)DisplayTools.getShell(), (String)JptJpaUiMessages.ADD_CLASSES_TO_PERSISTENCE_UNIT_MESSAGE_TITLE, (String)JptJpaUiMessages.ADD_CLASSES_TO_PERSISTENCE_UNIT_MESSAGE_TEXT);
                    continue;
                }
                this.persistenceXmlFile = (IFile)persistenceXml.getResource();
                AddClassesRunnable runnable = new AddClassesRunnable(this.persistenceXmlFile, this.convertToTypeNames(types));
                this.buildProgressMonitorDialog().run(true, true, (IRunnableWithProgress)runnable);
            }
            catch (InvocationTargetException ex) {
                JptJpaUiPlugin.instance().logError(ex);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                JptJpaUiPlugin.instance().logError(ex);
            }
        }
        return null;
    }

    protected Iterable<String> convertToTypeNames(Iterable<IType> types) {
        return new TransformationIterable(types, (Transformer)new NameTransformer());
    }

    private Map<IProject, Set<IType>> buildSelectedTypes(ISelection currentSelection) {
        if (!(currentSelection instanceof StructuredSelection)) {
            return Collections.emptyMap();
        }
        HashMap<IProject, Set<IType>> types = new HashMap<IProject, Set<IType>>();
        for (Object sel : ((StructuredSelection)currentSelection).toList()) {
            switch (((IJavaElement)sel).getElementType()) {
                case 3: {
                    this.addSelectedTypes((IPackageFragmentRoot)sel, types);
                    break;
                }
                case 4: {
                    this.addSelectedTypes((IPackageFragment)sel, types);
                    break;
                }
                case 5: {
                    this.addSelectedTypes((ICompilationUnit)sel, types);
                    break;
                }
                case 7: {
                    this.addSelectedType((IType)sel, types);
                    break;
                }
            }
        }
        return types;
    }

    private void addSelectedTypes(IPackageFragmentRoot packageFragmentRoot, Map<IProject, Set<IType>> types) {
        IJavaElement[] iJavaElementArray = this.getPackageFragments(packageFragmentRoot);
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement pkgFragment = iJavaElementArray[n2];
            this.addSelectedTypes((IPackageFragment)pkgFragment, types);
            ++n2;
        }
    }

    private void addSelectedTypes(IPackageFragment packageFragment, Map<IProject, Set<IType>> types) {
        ICompilationUnit[] iCompilationUnitArray = this.getCompilationUnits(packageFragment);
        int n = iCompilationUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit compUnit = iCompilationUnitArray[n2];
            this.addSelectedTypes(compUnit, types);
            ++n2;
        }
    }

    private void addSelectedTypes(ICompilationUnit compilationUnit, Map<IProject, Set<IType>> types) {
        IType primaryType = compilationUnit.findPrimaryType();
        if (primaryType != null) {
            this.addSelectedType(primaryType, types);
        }
    }

    private void addSelectedType(IType primaryType, Map<IProject, Set<IType>> typesMap) {
        IProject project = primaryType.getJavaProject().getProject();
        Set<IType> types = typesMap.get(project);
        if (types == null) {
            types = new HashSet<IType>();
            typesMap.put(project, types);
        }
        types.add(primaryType);
    }

    private ICompilationUnit[] getCompilationUnits(IPackageFragment packageFragment) {
        try {
            return packageFragment.getCompilationUnits();
        }
        catch (JavaModelException e) {
            JptJpaUiPlugin.instance().logError(e);
            return new ICompilationUnit[0];
        }
    }

    private IJavaElement[] getPackageFragments(IPackageFragmentRoot packageFragmentRoot) {
        try {
            return packageFragmentRoot.getChildren();
        }
        catch (JavaModelException e) {
            JptJpaUiPlugin.instance().logError(e);
            return new IJavaElement[0];
        }
    }

    private ProgressMonitorDialog buildProgressMonitorDialog() {
        return new ProgressMonitorDialog(null);
    }

    static class AddClassesCommand
    implements Command {
        private final PersistenceUnit persistenceUnit;
        private final Iterable<String> typeNames;
        private final IProgressMonitor monitor;

        AddClassesCommand(PersistenceUnit persistenceUnit, Iterable<String> typeNames, IProgressMonitor monitor) {
            this.persistenceUnit = persistenceUnit;
            this.typeNames = typeNames;
            this.monitor = monitor;
        }

        public void execute() {
            this.persistenceUnit.addClasses(this.typeNames, this.monitor);
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (Object)this.persistenceUnit);
        }
    }

    static class AddClassesRunnable
    implements IRunnableWithProgress {
        private final IFile persistenceXmlFile;
        private final Iterable<String> typeNames;

        AddClassesRunnable(IFile persistenceXmlFile, Iterable<String> typeNames) {
            this.persistenceXmlFile = persistenceXmlFile;
            this.typeNames = typeNames;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                this.run_(monitor);
            }
            catch (CoreException ex) {
                throw new InvocationTargetException(ex);
            }
        }

        private void run_(IProgressMonitor monitor) throws CoreException {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            ISchedulingRule rule = workspace.getRuleFactory().modifyRule((IResource)this.persistenceXmlFile.getProject());
            workspace.run((IWorkspaceRunnable)new AddClassesWorkspaceRunnable(this.persistenceXmlFile, this.typeNames), rule, 1, monitor);
        }
    }

    static class AddClassesWorkspaceRunnable
    implements IWorkspaceRunnable {
        private final IFile persistenceXmlFile;
        private final Iterable<String> typeNames;

        AddClassesWorkspaceRunnable(IFile persistenceXmlFile, Iterable<String> typeNames) {
            this.persistenceXmlFile = persistenceXmlFile;
            this.typeNames = typeNames;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            PersistenceUnit persistenceUnit;
            if (monitor.isCanceled()) {
                return;
            }
            SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)JptJpaUiMessages.ADD_CLASSES_TO_PERSISTENCE_UNIT_TASK_NAME, (int)20);
            JpaProject jpaProject = this.getJpaProject();
            if (jpaProject == null) {
                return;
            }
            JptXmlResource resource = jpaProject.getPersistenceXmlResource();
            if (resource == null) {
                return;
            }
            if (sm.isCanceled()) {
                return;
            }
            sm.worked(1);
            PersistenceXml persistenceXml = jpaProject.getContextRoot().getPersistenceXml();
            if (persistenceXml == null) {
                return;
            }
            Persistence persistence = persistenceXml.getRoot();
            if (persistence == null) {
                return;
            }
            PersistenceUnit persistenceUnit2 = persistenceUnit = persistence.getPersistenceUnitsSize() == 0 ? persistence.addPersistenceUnit() : persistence.getPersistenceUnit(0);
            if (sm.isCanceled()) {
                return;
            }
            sm.worked(1);
            AddClassesCommand addClassesCommand = new AddClassesCommand(persistenceUnit, this.typeNames, (IProgressMonitor)sm.newChild(17));
            JpaProjectManager mgr = this.getJpaProjectManager();
            try {
                if (mgr != null) {
                    mgr.execute((Command)addClassesCommand, SynchronousUiCommandContext.instance());
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(ex);
            }
            resource.save();
            sm.worked(1);
        }

        private JpaProjectManager getJpaProjectManager() {
            return (JpaProjectManager)this.getWorkspace().getAdapter(JpaProjectManager.class);
        }

        private IProject getProject() {
            return this.persistenceXmlFile.getProject();
        }

        private JpaProject getJpaProject() {
            return (JpaProject)this.getProject().getAdapter(JpaProject.class);
        }

        private IWorkspace getWorkspace() {
            return this.persistenceXmlFile.getWorkspace();
        }
    }

    class NameTransformer
    extends TransformerAdapter<IType, String> {
        NameTransformer() {
        }

        public String transform(IType type) {
            return type.getFullyQualifiedName('$');
        }
    }
}

