/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.ui.internal.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.libra.framework.core.FrameworkInstanceConfiguration;
import org.eclipse.libra.framework.core.FrameworkInstanceDelegate;
import org.eclipse.libra.framework.core.IOSGIFrameworkInstance;
import org.eclipse.libra.framework.core.IOSGIFrameworkWorkingCopy;
import org.eclipse.libra.framework.core.Trace;
import org.eclipse.libra.framework.ui.FrameworkUIPlugin;
import org.eclipse.libra.framework.ui.Messages;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.ui.editor.ServerEditorPart;

public class ConfigurationOSGiModuleEditorPart
extends ServerEditorPart
implements ISelectionProvider {
    protected IOSGIFrameworkWorkingCopy framework2;
    protected FrameworkInstanceConfiguration configuration;
    protected Table osgiBundlesTable;
    protected int selection = -1;
    protected Button addBundleProject;
    protected Button remove;
    protected PropertyChangeListener listener;
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;

    protected void addChangeListener() {
        this.listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("ADD_BUNDLE".equals(event.getPropertyName())) {
                    ConfigurationOSGiModuleEditorPart.this.initialize();
                } else if ("REMOVE_BUNDLE".equals(event.getPropertyName())) {
                    ConfigurationOSGiModuleEditorPart.this.initialize();
                }
            }
        };
        this.configuration.addPropertyChangeListener(this.listener);
    }

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        ScrolledForm form = toolkit.createScrolledForm(parent);
        toolkit.decorateFormHeading(form.getForm());
        form.setText(Messages.configurationEditorOSGIModulesPageTitle);
        form.setImage(FrameworkUIPlugin.getImage("webModule"));
        GridLayout layout = new GridLayout();
        layout.marginTop = 6;
        layout.marginLeft = 6;
        form.getBody().setLayout((Layout)layout);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        Section section = toolkit.createSection(form.getBody(), 384);
        section.setText(Messages.configurationEditorOSGIModulesSection);
        section.setDescription(Messages.configurationEditorOSGIModulesDescription);
        section.setLayoutData((Object)new GridData(1808));
        Composite composite = toolkit.createComposite((Composite)section);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)composite, "org.eclipse.libra.framework.ui.tecw0000");
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        this.osgiBundlesTable = toolkit.createTable(composite, 66052);
        this.osgiBundlesTable.setHeaderVisible(true);
        this.osgiBundlesTable.setLinesVisible(true);
        whs.setHelp((Control)this.osgiBundlesTable, "org.eclipse.libra.framework.ui.tecw0002");
        TableLayout tableLayout = new TableLayout();
        TableColumn col = new TableColumn(this.osgiBundlesTable, 0);
        col.setText("Name");
        ColumnWeightData colData = new ColumnWeightData(8, 250, true);
        tableLayout.addColumnData((ColumnLayoutData)colData);
        TableColumn col2 = new TableColumn(this.osgiBundlesTable, 0);
        col2.setText("Id");
        colData = new ColumnWeightData(13, 250, true);
        tableLayout.addColumnData((ColumnLayoutData)colData);
        TableColumn col3 = new TableColumn(this.osgiBundlesTable, 0);
        col3.setText("Version");
        colData = new ColumnWeightData(5, 50, true);
        tableLayout.addColumnData((ColumnLayoutData)colData);
        this.osgiBundlesTable.setLayout((Layout)tableLayout);
        GridData data = new GridData(768);
        data.widthHint = 450;
        data.heightHint = 120;
        this.osgiBundlesTable.setLayoutData((Object)data);
        this.osgiBundlesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationOSGiModuleEditorPart.this.selectOsgiBundle();
            }
        });
        Composite rightPanel = toolkit.createComposite(composite);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        rightPanel.setLayout((Layout)layout);
        data = new GridData();
        rightPanel.setLayoutData((Object)new GridData(258));
        form.setContent((Control)section);
        form.reflow(true);
        this.initialize();
    }

    public void dispose() {
        super.dispose();
        if (this.configuration != null) {
            this.configuration.removePropertyChangeListener(this.listener);
        }
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        IOSGIFrameworkInstance ts = (IOSGIFrameworkInstance)this.server.loadAdapter(FrameworkInstanceDelegate.class, null);
        try {
            this.configuration = ts.getFrameworkInstanceConfiguration();
        }
        catch (CoreException e) {
            Trace.trace((byte)2, (String)"cannot access configuration", (Throwable)e);
        }
        if (this.server != null) {
            this.framework2 = (IOSGIFrameworkWorkingCopy)this.server.loadAdapter(IOSGIFrameworkWorkingCopy.class, null);
        }
        this.addChangeListener();
        this.initialize();
    }

    protected void initialize() {
        if (this.osgiBundlesTable == null) {
            return;
        }
        this.osgiBundlesTable.removeAll();
        this.setErrorMessage(null);
    }

    protected void selectOsgiBundle() {
        if (this.readOnly) {
            return;
        }
        try {
            this.selection = this.osgiBundlesTable.getSelectionIndex();
            this.remove.setEnabled(true);
            for (ISelectionChangedListener changedListener : this.selectionChangedListeners) {
                changedListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
            }
        }
        catch (Exception exception) {
            this.selection = -1;
            this.remove.setEnabled(false);
        }
    }

    public void setFocus() {
        if (this.osgiBundlesTable != null) {
            this.osgiBundlesTable.setFocus();
        }
    }

    public ISelection getSelection() {
        final TableItem[] sel = this.osgiBundlesTable.getSelection();
        if (sel == null || sel.length == 0) {
            return StructuredSelection.EMPTY;
        }
        return new IStructuredSelection(){

            public boolean isEmpty() {
                return false;
            }

            public List toList() {
                ArrayList<IPluginModelBase> all = new ArrayList<IPluginModelBase>();
                TableItem[] tableItemArray = sel;
                int n = sel.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem s = tableItemArray[n2];
                    all.add((IPluginModelBase)s.getData());
                    ++n2;
                }
                return all;
            }

            public Object[] toArray() {
                return this.toList().toArray();
            }

            public int size() {
                return sel.length;
            }

            public Iterator iterator() {
                return this.toList().iterator();
            }

            public Object getFirstElement() {
                return sel[0].getData();
            }
        };
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener2) {
        this.selectionChangedListeners.add(listener2);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener2) {
        this.selectionChangedListeners.remove(listener2);
    }

    public void setSelection(ISelection selection) {
    }
}

