/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.actions;

import java.util.Collections;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.spi.GetBuildsRequest;
import org.eclipse.mylyn.builds.internal.core.operations.AbortBuildOperation;
import org.eclipse.mylyn.builds.internal.core.operations.GetBuildsOperation;
import org.eclipse.mylyn.builds.internal.core.operations.OperationChangeEvent;
import org.eclipse.mylyn.builds.internal.core.operations.OperationChangeListener;
import org.eclipse.mylyn.commons.workbench.EditorHandle;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiInternal;
import org.eclipse.mylyn.internal.builds.ui.actions.AbortBuildAction;
import org.eclipse.mylyn.internal.builds.ui.editor.BuildEditor;
import org.eclipse.mylyn.internal.builds.ui.editor.RefreshBuildEditorOperationListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;

public class AbortBuildFromEditorAction
extends AbortBuildAction {
    private final BuildEditor editor;

    public AbortBuildFromEditorAction(BuildEditor editor) {
        this.editor = editor;
    }

    @Override
    public void run() {
        Object selection = this.getStructuredSelection().getFirstElement();
        if (selection instanceof IBuild) {
            IBuild build = (IBuild)selection;
            AbortBuildFromEditorAction.abortBuild(build, this.editor);
        }
    }

    public static void abortBuild(final IBuild build, final BuildEditor editor) {
        AbortBuildOperation operation = BuildsUiInternal.getFactory().getAbortBuildOperation(build);
        operation.addOperationChangeListener(new OperationChangeListener(){

            public void done(OperationChangeEvent event) {
                if (event.getStatus().isOK()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IBuildPlan plan = build.getPlan();
                            String label = build.getLabel();
                            EditorHandle handle = new EditorHandle();
                            handle.setPart((IWorkbenchPart)editor);
                            GetBuildsRequest request = new GetBuildsRequest(plan, Collections.singletonList(label), GetBuildsRequest.Scope.FULL);
                            GetBuildsOperation operation = BuildsUiInternal.getFactory().getGetBuildsOperation(request);
                            operation.addOperationChangeListener((OperationChangeListener)new RefreshBuildEditorOperationListener(build, handle));
                            operation.execute();
                            if (build.getBuildNumber() == plan.getLastBuild().getBuildNumber()) {
                                BuildsUiInternal.getFactory().getRefreshOperation((IBuildElement)build).execute();
                            }
                        }
                    });
                }
            }
        });
        operation.execute();
    }
}

