/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser;

import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.ImageAttributes;
import org.eclipse.mylyn.wikitext.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.parser.Locator;

public abstract class DocumentBuilder {
    protected Locator locator;

    public abstract void beginDocument();

    public void flush() {
    }

    public abstract void endDocument();

    public abstract void beginBlock(BlockType var1, Attributes var2);

    public abstract void endBlock();

    public abstract void beginSpan(SpanType var1, Attributes var2);

    public abstract void endSpan();

    public abstract void beginHeading(int var1, Attributes var2);

    public abstract void endHeading();

    public abstract void characters(String var1);

    public abstract void entityReference(String var1);

    public abstract void image(Attributes var1, String var2);

    public abstract void link(Attributes var1, String var2, String var3);

    public abstract void imageLink(Attributes var1, Attributes var2, String var3, String var4);

    public final void imageLink(Attributes attributes, String href, String imageUrl) {
        this.imageLink(new LinkAttributes(), attributes, href, imageUrl);
    }

    public final void link(String hrefOrHashName, String text) {
        this.link(new LinkAttributes(), hrefOrHashName, text);
    }

    public final void imageLink(String href, String imageUrl) {
        this.imageLink(new LinkAttributes(), new ImageAttributes(), href, imageUrl);
    }

    public abstract void acronym(String var1, String var2);

    public abstract void lineBreak();

    public void horizontalRule() {
    }

    public abstract void charactersUnescaped(String var1);

    public void setLocator(Locator locator) {
        this.locator = locator;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public static enum SpanType {
        EMPHASIS,
        STRONG,
        ITALIC,
        BOLD,
        CITATION,
        DELETED,
        INSERTED,
        SUPERSCRIPT,
        SUBSCRIPT,
        SPAN,
        CODE,
        MONOSPACE,
        UNDERLINED,
        MARK,
        QUOTE,
        LINK;

    }

    public static enum BlockType {
        PARAGRAPH,
        TIP,
        WARNING,
        INFORMATION,
        NOTE,
        PANEL,
        DIV,
        FOOTNOTE,
        QUOTE,
        CODE,
        PREFORMATTED,
        NUMERIC_LIST,
        BULLETED_LIST,
        LIST_ITEM,
        TABLE,
        TABLE_ROW,
        TABLE_CELL_HEADER,
        TABLE_CELL_NORMAL,
        DEFINITION_LIST,
        DEFINITION_TERM,
        DEFINITION_ITEM;

    }
}

