/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.cs2as;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.xtext.base.cs2as.AbstractDependency;
import org.eclipse.ocl.xtext.base.cs2as.Dependency;

public class InterDependency<@NonNull T>
extends AbstractDependency<Object> {
    private @Nullable Dependency dependency;
    private List<@NonNull T> dependencies = new ArrayList<T>();
    private List<@NonNull T> satisfied = new ArrayList<T>();

    public InterDependency(@NonNull String reason, @Nullable Dependency dependency) {
        super(reason);
        this.dependency = dependency;
    }

    public void addDependency(T dependency) {
        assert (this.satisfied.isEmpty());
        assert (!this.dependencies.contains(dependency));
        this.dependencies.add(dependency);
    }

    @Override
    public boolean canExecute() {
        if (this.dependency != null && !this.dependency.canExecute()) {
            return false;
        }
        return this.satisfied.size() >= this.dependencies.size();
    }

    public void setSatisfied(T dependency) {
        assert (this.dependencies.contains(dependency));
        assert (!this.satisfied.contains(dependency));
        this.satisfied.add(dependency);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(super.toString());
        if (this.dependency != null && !this.dependency.canExecute()) {
            s.append(" BLOCKED");
        }
        s.append(" ");
        s.append(this.satisfied.size());
        s.append("/");
        s.append(this.dependencies.size());
        return s.toString();
    }
}

