/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.synchronizer;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.synchronizer.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.userstorage.IStorageService;
import org.eclipse.userstorage.ui.AbstractDialog;

public abstract class AbstractServiceDialog
extends AbstractDialog {
    private final IStorageService service;

    public AbstractServiceDialog(Shell parentShell, IStorageService service) {
        super(parentShell);
        this.service = service;
    }

    public final IStorageService getService() {
        return this.service;
    }

    protected IDialogSettings getPluginSettings() {
        return SetupUIPlugin.INSTANCE.getDialogSettings();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.AbstractServiceDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        String serviceLabel;
        String shortLabel = serviceLabel = this.service.getServiceLabel();
        String authority = this.service.getServiceURI().getAuthority();
        if (authority != null && authority.endsWith(".eclipse.org")) {
            shortLabel = "Eclipse";
        }
        this.setTitle(Messages.AbstractServiceDialog_title);
        this.initializeDialogUnits((Control)parent);
        Composite area = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 48;
        layout.marginHeight = 32;
        Composite composite = new Composite(area, 0);
        composite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        composite.setLayout((Layout)layout);
        this.createUI(composite, serviceLabel, shortLabel);
        return area;
    }

    protected abstract void createUI(Composite var1, String var2, String var3);
}

