/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class ZonedDateTimeSerializer
extends StdSerializer<ZonedDateTime> {
    private static final long serialVersionUID = 6125923493245016575L;

    protected ZonedDateTimeSerializer(Class<ZonedDateTime> type) {
        super(type);
    }

    public void serialize(ZonedDateTime value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("formatted", this.date(value));
        gen.writeEndObject();
    }

    private String date(ZonedDateTime time) {
        return DateTimeFormatter.ISO_ZONED_DATE_TIME.format(time);
    }
}

