/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.utilities;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.pivot.qvtschedule.CastEdge;
import org.eclipse.qvtd.pivot.qvtschedule.CollectionLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.CollectionPartEdge;
import org.eclipse.qvtd.pivot.qvtschedule.DependencyEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.IteratedEdge;
import org.eclipse.qvtd.pivot.qvtschedule.KeyPartEdge;
import org.eclipse.qvtd.pivot.qvtschedule.KeyedValueNode;
import org.eclipse.qvtd.pivot.qvtschedule.MapLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.MapPartEdge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.OperationParameterEdge;
import org.eclipse.qvtd.pivot.qvtschedule.OperationSelfEdge;
import org.eclipse.qvtd.pivot.qvtschedule.PredicateEdge;
import org.eclipse.qvtd.pivot.qvtschedule.ShadowNode;
import org.eclipse.qvtd.pivot.qvtschedule.ShadowPartEdge;
import org.eclipse.qvtd.pivot.qvtschedule.util.AbstractExtendingQVTscheduleVisitor;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class ReachabilityForest {
    private static final int COLLECTION_COST = 10;
    private static final int FORWARD_NAVIGATION_COST = 1;
    private static final int INVERSE_NAVIGATION_COST = 3;
    private static final int ITERATOR_COST = 1;
    private static final int KEY_COST = 15;
    private static final int MAP_COST = 12;
    private static final int OPERATION_COST = 10;
    private static final int PREDICATE_COST = 1;
    private static final int SHADOW_COST = 15;
    protected final @Nullable String disambiguator;
    private final @NonNull Set<@NonNull Edge> availableEdges = new HashSet<Edge>();
    private final @NonNull Set<@NonNull NavigableEdge> forwardEdges = new HashSet<NavigableEdge>();
    private final @NonNull Map<@NonNull Node, @Nullable List<@NonNull Edge>> node2reachingEdges = new HashMap<Node, List<Edge>>();
    private @NonNull Map<@NonNull Node, @NonNull Integer> node2cost = new HashMap<Node, Integer>();
    private @Nullable Comparator<@NonNull Edge> edgeCostComparator = null;
    private @Nullable Comparator<@NonNull Node> nodeCostComparator = null;

    public ReachabilityForest(@Nullable String disambiguator, @NonNull Iterable<@NonNull Node> rootNodes, @NonNull Iterable<@NonNull ? extends Edge> availableEdges) {
        this.disambiguator = disambiguator;
        for (Node node : rootNodes) {
            this.node2reachingEdges.put(node, null);
        }
        for (Edge edge : availableEdges) {
            this.addEdge(edge);
        }
        this.analyze();
    }

    protected void addEdge(@NonNull Edge edge) {
        NavigationEdge navigationEdge;
        this.availableEdges.add(edge);
        if (edge instanceof NavigationEdge && !(navigationEdge = (NavigationEdge)edge).isSecondary()) {
            this.forwardEdges.add((NavigableEdge)navigationEdge);
        }
    }

    protected void analyze() {
        Set<@NonNull Node> rootNodes = this.node2reachingEdges.keySet();
        for (Node rootNode : rootNodes) {
            this.node2cost.put(rootNode, 0);
        }
        EdgeVisitor edgeVisitor = new EdgeVisitor(this, rootNodes);
        edgeVisitor.visitAll();
    }

    public @Nullable Integer basicGetCost(@NonNull Node node) {
        return this.node2cost.get(node);
    }

    public @NonNull Integer getCost(@NonNull Node node) {
        return (Integer)ClassUtil.nonNullState((Object)this.node2cost.get(node));
    }

    public @Nullable String getDisambiguator() {
        return this.disambiguator;
    }

    public @NonNull Comparator<@NonNull Edge> getEdgeCostComparator() {
        Comparator<@NonNull Edge> edgeCostComparator2 = this.edgeCostComparator;
        if (edgeCostComparator2 == null) {
            this.edgeCostComparator = edgeCostComparator2 = new Comparator<Edge>(){

                @Override
                public int compare(@NonNull Edge e1, @NonNull Edge e2) {
                    String n2;
                    int d2;
                    Node s1 = QVTscheduleUtil.getSourceNode((Edge)e1);
                    Node t1 = QVTscheduleUtil.getTargetNode((Edge)e1);
                    Node s2 = QVTscheduleUtil.getSourceNode((Edge)e2);
                    Node t2 = QVTscheduleUtil.getTargetNode((Edge)e2);
                    Integer d1s = (Integer)ReachabilityForest.this.node2cost.get(s1);
                    Integer d1t = (Integer)ReachabilityForest.this.node2cost.get(t1);
                    Integer d2s = (Integer)ReachabilityForest.this.node2cost.get(s2);
                    Integer d2t = (Integer)ReachabilityForest.this.node2cost.get(t2);
                    if (!$assertionsDisabled && d1s == null) {
                        throw new AssertionError((Object)(s1 + " is not reachable within " + s1.getOwningRegion() + this.getContext()));
                    }
                    if (!$assertionsDisabled && d1t == null) {
                        throw new AssertionError((Object)(t1 + " is not reachable within " + t1.getOwningRegion() + this.getContext()));
                    }
                    if (!$assertionsDisabled && d2s == null) {
                        throw new AssertionError((Object)(s2 + " is not reachable within " + s2.getOwningRegion() + this.getContext()));
                    }
                    if (!$assertionsDisabled && d2t == null) {
                        throw new AssertionError((Object)(t2 + " is not reachable within " + t2.getOwningRegion() + this.getContext()));
                    }
                    int d1 = Math.max(d1s, d1t);
                    if (d1 != (d2 = Math.max(d2s, d2t))) {
                        return d1 - d2;
                    }
                    if (d1s != d2s) {
                        return d1s - d2s;
                    }
                    String n1 = e1.getDisplayName();
                    int d = ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)(n2 = e2.getDisplayName())));
                    if (d != 0) {
                        return d;
                    }
                    n1 = s1.getDisplayName();
                    d = ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)(n2 = s2.getDisplayName())));
                    if (d != 0) {
                        return d;
                    }
                    n1 = t1.getDisplayName();
                    n2 = t2.getDisplayName();
                    d = ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)n2));
                    return d;
                }

                private @NonNull String getContext() {
                    return ReachabilityForest.this.disambiguator != null ? "\u00ab" + ReachabilityForest.this.disambiguator + "\u00bb" : "";
                }
            };
        }
        return edgeCostComparator2;
    }

    public @NonNull Comparator<@NonNull Node> getNodeCostComparator() {
        Comparator<@NonNull Node> nodeCostComparator2 = this.nodeCostComparator;
        if (nodeCostComparator2 == null) {
            this.nodeCostComparator = nodeCostComparator2 = new Comparator<Node>(){

                @Override
                public int compare(@NonNull Node o1, @NonNull Node o2) {
                    Integer c1 = (Integer)ReachabilityForest.this.node2cost.get(o1);
                    Integer c2 = (Integer)ReachabilityForest.this.node2cost.get(o2);
                    if (!$assertionsDisabled && c1 == null) {
                        throw new AssertionError((Object)(o1 + " is not reachable within " + o1.getOwningRegion() + this.getContext()));
                    }
                    if (!$assertionsDisabled && c2 == null) {
                        throw new AssertionError((Object)(o2 + " is not reachable within " + o2.getOwningRegion() + this.getContext()));
                    }
                    int diff = c1 - c2;
                    if (diff != 0) {
                        return diff;
                    }
                    return ClassUtil.safeCompareTo((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
                }

                private @NonNull String getContext() {
                    return ReachabilityForest.this.disambiguator != null ? "\u00ab" + ReachabilityForest.this.disambiguator + "\u00bb" : "";
                }
            };
        }
        return nodeCostComparator2;
    }

    public @NonNull List<@NonNull Node> getMostReachableFirstNodes() {
        ArrayList<@NonNull Node> nodes = new ArrayList<Node>(this.node2cost.keySet());
        Collections.sort(nodes, this.getNodeCostComparator());
        return nodes;
    }

    public @NonNull Iterable<@NonNull Node> getNodes() {
        return this.node2reachingEdges.keySet();
    }

    public @NonNull Iterable<@NonNull Node> getPredecessorsClosure(@NonNull Node targetNode) {
        HashSet<@NonNull Node> precedingNodes = new HashSet<Node>();
        this.getPredecessorsClosure(precedingNodes, targetNode);
        precedingNodes.remove(targetNode);
        return precedingNodes;
    }

    private void getPredecessorsClosure(@NonNull Set<@NonNull Node> precedingNodes, @NonNull Node targetNode) {
        if (precedingNodes.add(targetNode)) {
            for (Edge reachingEdge : this.getReachingEdges(targetNode)) {
                assert (!reachingEdge.isPartial());
                Node sourceNode = reachingEdge.getEdgeSource();
                this.getPredecessorsClosure(precedingNodes, sourceNode);
            }
        }
    }

    public @NonNull Iterable<@NonNull Edge> getReachingEdges(@NonNull Node node) {
        List<@NonNull Object> edges = this.node2reachingEdges.get(node);
        if (edges == null) {
            edges = Collections.emptyList();
            this.node2reachingEdges.put(node, edges);
        }
        return edges;
    }

    public @NonNull String toString() {
        StringBuilder s = new StringBuilder();
        List<@NonNull Node> nodes = this.getMostReachableFirstNodes();
        for (Node node : nodes) {
            if (s.length() > 0) {
                s.append("\n");
            }
            s.append(this.node2cost.get(node));
            s.append(": ");
            s.append(node.getName());
            s.append(" :");
            List<@NonNull Edge> edges = this.node2reachingEdges.get(node);
            if (edges == null) continue;
            for (Edge edge : edges) {
                s.append(" ");
                s.append(edge);
            }
        }
        return s.toString();
    }

    private class EdgeVisitor
    extends AbstractExtendingQVTscheduleVisitor<Object, ReachabilityForest> {
        protected final @NonNull List<@Nullable List<@NonNull Node>> costs2nodes;
        private @NonNull Node targetNode;
        private int thisCost;
        private Integer targetCost;

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        protected EdgeVisitor(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @NonNull @NonNull ReachabilityForest context, Iterable<Node> rootNodes) {
            super((Object)context);
            this.costs2nodes = new ArrayList<List<Node>>();
            @NonNull ArrayList rootNodesList = Lists.newArrayList(rootNodes);
            this.targetNode = (Node)rootNodesList.get(0);
            this.costs2nodes.add(rootNodesList);
        }

        private Object doOperationParameterEdge(@NonNull Edge object) {
            int nextCost = this.thisCost + 10;
            assert (this.targetNode.isOperation());
            ArrayList<@NonNull Edge> edges = null;
            for (Edge incomingEdge : QVTscheduleUtil.getIncomingEdges((Node)this.targetNode)) {
                if (!ReachabilityForest.this.availableEdges.contains(incomingEdge) || !(incomingEdge instanceof OperationParameterEdge) && !(incomingEdge instanceof OperationSelfEdge)) continue;
                Node node = QVTscheduleUtil.getSourceNode((Edge)incomingEdge);
                Integer cost = (Integer)ReachabilityForest.this.node2cost.get(node);
                if (cost == null || cost > this.thisCost) {
                    return null;
                }
                if (edges == null) {
                    edges = new ArrayList<Edge>();
                }
                edges.add(incomingEdge);
            }
            if (edges != null && (this.targetCost == null || nextCost < this.targetCost)) {
                this.putCosts(this.costs2nodes, nextCost, this.targetNode, edges);
            }
            return null;
        }

        private void putCosts(@NonNull List<@Nullable List<@NonNull Node>> costs2nodes, int cost, @NonNull Node targetNode, @NonNull Object reachingEdgeOrEdges) {
            List<Edge> reachingEdges;
            assert (this.targetCost == null || cost < this.targetCost);
            if (reachingEdgeOrEdges instanceof Edge) {
                Edge edge = (Edge)reachingEdgeOrEdges;
                assert (!edge.isPartial());
                assert (edge instanceof IteratedEdge || edge instanceof NavigationEdge || edge instanceof PredicateEdge);
                assert (edge.getTargetNode() == targetNode);
                assert (ReachabilityForest.this.availableEdges.contains(edge));
                reachingEdges = Collections.singletonList(edge);
            } else {
                List<Edge> reachingEdges2;
                reachingEdges = reachingEdges2 = (List<Edge>)reachingEdgeOrEdges;
                assert (ReachabilityForest.this.availableEdges.containsAll(reachingEdges));
                for (Edge edge : reachingEdges) {
                    assert (!edge.isPartial());
                    assert (edge instanceof CollectionPartEdge || edge instanceof KeyPartEdge || edge instanceof MapPartEdge || edge instanceof OperationParameterEdge || edge instanceof OperationSelfEdge || edge instanceof ShadowPartEdge);
                    assert (edge.getTargetNode() == targetNode);
                }
            }
            ReachabilityForest.this.node2cost.put(targetNode, cost);
            ReachabilityForest.this.node2reachingEdges.put(targetNode, reachingEdges);
            while (costs2nodes.size() <= cost) {
                costs2nodes.add(null);
            }
            List<@NonNull Node> nodes = costs2nodes.get(cost);
            if (nodes == null) {
                nodes = new ArrayList<Node>();
                costs2nodes.set(cost, nodes);
            }
            if (!nodes.contains(targetNode)) {
                nodes.add(targetNode);
            }
        }

        public void visitAll() {
            this.thisCost = 0;
            while (this.thisCost < this.costs2nodes.size()) {
                List<@NonNull Node> thisCostNodes = this.costs2nodes.get(this.thisCost);
                if (thisCostNodes != null) {
                    for (Node sourceNode : thisCostNodes) {
                        assert ((Integer)ReachabilityForest.this.node2cost.get(sourceNode) == this.thisCost);
                        for (Edge edge : QVTscheduleUtil.getOutgoingEdges((Node)sourceNode)) {
                            assert (!edge.isCast());
                            if (!ReachabilityForest.this.availableEdges.contains(edge) || edge.isPartial()) continue;
                            this.targetNode = edge.getEdgeTarget();
                            if (ReachabilityForest.this.node2reachingEdges.containsKey(this.targetNode)) continue;
                            this.targetCost = (Integer)ReachabilityForest.this.node2cost.get(this.targetNode);
                            assert (this.targetCost == null || this.thisCost < this.targetCost);
                            edge.accept((Visitor)this);
                        }
                    }
                }
                ++this.thisCost;
            }
        }

        public Object visitCastEdge(@NonNull CastEdge object) {
            return this.visiting((Visitable)object);
        }

        public Object visitCollectionPartEdge(@NonNull CollectionPartEdge edge) {
            int nextCost = this.thisCost + 10;
            assert (this.targetNode instanceof CollectionLiteralNode);
            ArrayList<@NonNull Edge> edges = null;
            for (Edge incomingEdge : QVTscheduleUtil.getIncomingEdges((Node)this.targetNode)) {
                if (!(incomingEdge instanceof CollectionPartEdge)) continue;
                Node node = QVTscheduleUtil.getSourceNode((Edge)incomingEdge);
                Integer cost = (Integer)ReachabilityForest.this.node2cost.get(node);
                if (cost == null || cost > this.thisCost) {
                    return null;
                }
                if (edges == null) {
                    edges = new ArrayList<Edge>();
                }
                edges.add(incomingEdge);
            }
            if (edges != null && (this.targetCost == null || nextCost < this.targetCost)) {
                this.putCosts(this.costs2nodes, nextCost, this.targetNode, edges);
            }
            return null;
        }

        public Object visitDependencyEdge(@NonNull DependencyEdge object) {
            return null;
        }

        public Object visitIteratedEdge(@NonNull IteratedEdge edge) {
            int nextCost = this.thisCost + 1;
            assert (this.targetNode.isIterator());
            this.putCosts(this.costs2nodes, nextCost, this.targetNode, edge);
            return null;
        }

        public Object visitKeyPartEdge(@NonNull KeyPartEdge edge) {
            int nextCost = this.thisCost + 15;
            assert (this.targetNode instanceof KeyedValueNode);
            ArrayList<@NonNull Edge> edges = null;
            for (Edge incomingEdge : QVTscheduleUtil.getIncomingEdges((Node)this.targetNode)) {
                if (!(incomingEdge instanceof KeyPartEdge)) continue;
                Node node = QVTscheduleUtil.getSourceNode((Edge)incomingEdge);
                Integer cost = (Integer)ReachabilityForest.this.node2cost.get(node);
                if (cost == null || cost > this.thisCost) {
                    return null;
                }
                if (edges == null) {
                    edges = new ArrayList<Edge>();
                }
                edges.add(incomingEdge);
            }
            if (edges != null && (this.targetCost == null || nextCost < this.targetCost)) {
                this.putCosts(this.costs2nodes, nextCost, this.targetNode, edges);
            }
            return null;
        }

        public Object visitMapPartEdge(@NonNull MapPartEdge edge) {
            int nextCost = this.thisCost + 12;
            assert (this.targetNode instanceof MapLiteralNode);
            ArrayList<@NonNull Edge> edges = null;
            for (Edge incomingEdge : QVTscheduleUtil.getIncomingEdges((Node)this.targetNode)) {
                if (!(incomingEdge instanceof MapPartEdge)) continue;
                Node node = QVTscheduleUtil.getSourceNode((Edge)incomingEdge);
                Integer cost = (Integer)ReachabilityForest.this.node2cost.get(node);
                if (cost == null || cost > this.thisCost) {
                    return null;
                }
                if (edges == null) {
                    edges = new ArrayList<Edge>();
                }
                edges.add(incomingEdge);
            }
            if (edges != null && (this.targetCost == null || nextCost < this.targetCost)) {
                this.putCosts(this.costs2nodes, nextCost, this.targetNode, edges);
            }
            return null;
        }

        public Object visitNavigationEdge(@NonNull NavigationEdge navigationEdge) {
            if (ReachabilityForest.this.forwardEdges.contains(navigationEdge)) {
                int nextCost = this.thisCost + 1;
                if (this.targetCost == null || nextCost < this.targetCost) {
                    this.putCosts(this.costs2nodes, nextCost, this.targetNode, navigationEdge);
                }
            } else {
                NavigationEdge oppositeEdge = navigationEdge.getOppositeEdge();
                if (oppositeEdge != null && ReachabilityForest.this.forwardEdges.contains(oppositeEdge)) {
                    boolean isImplicit = QVTscheduleUtil.getReferredProperty((NavigationEdge)navigationEdge).isIsImplicit();
                    int nextCost = this.thisCost + (isImplicit ? 3 : 1);
                    if (this.targetCost == null || nextCost < this.targetCost) {
                        this.putCosts(this.costs2nodes, nextCost, this.targetNode, navigationEdge);
                    }
                }
            }
            return null;
        }

        public Object visitOperationParameterEdge(@NonNull OperationParameterEdge edge) {
            return this.doOperationParameterEdge((Edge)edge);
        }

        public Object visitOperationSelfEdge(@NonNull OperationSelfEdge edge) {
            return this.doOperationParameterEdge((Edge)edge);
        }

        public Object visitPredicateEdge(@NonNull PredicateEdge edge) {
            int nextCost = this.thisCost + 1;
            this.putCosts(this.costs2nodes, nextCost, this.targetNode, edge);
            return null;
        }

        public Object visitShadowPartEdge(@NonNull ShadowPartEdge edge) {
            int nextCost = this.thisCost + 15;
            assert (this.targetNode instanceof ShadowNode);
            ArrayList<@NonNull Edge> edges = null;
            for (Edge incomingEdge : QVTscheduleUtil.getIncomingEdges((Node)this.targetNode)) {
                if (!(incomingEdge instanceof ShadowPartEdge)) continue;
                Node node = QVTscheduleUtil.getSourceNode((Edge)incomingEdge);
                Integer cost = (Integer)ReachabilityForest.this.node2cost.get(node);
                if (cost == null || cost > this.thisCost) {
                    return null;
                }
                if (edges == null) {
                    edges = new ArrayList<Edge>();
                }
                edges.add(incomingEdge);
            }
            if (edges != null && (this.targetCost == null || nextCost < this.targetCost)) {
                this.putCosts(this.costs2nodes, nextCost, this.targetNode, edges);
            }
            return null;
        }

        public Object visiting(@NonNull Visitable visitable) {
            throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
        }
    }
}

