/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.capability.ui.views;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.search.AllProjectScope;
import org.eclipse.rcptt.core.model.search.ISearchScope;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.internal.core.model.ReferencedProjectScope;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.utils.WorkbenchUtils;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class OpenContextEditorHelper {
    public void open(IStructuredSelection selection, IQ7Project project) {
        if (selection.isEmpty()) {
            return;
        }
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            String elementId = (String)element;
            this.openSingleContext(elementId, project);
            ++n2;
        }
    }

    public void openSingleContext(String contextId, IQ7Project project) {
        IQ7NamedElement element = OpenContextEditorHelper.getContentsElementById(contextId, project);
        if (element != null) {
            try {
                IDE.openEditor((IWorkbenchPage)WorkbenchUtils.getPage(), (IFile)((IFile)element.getResource()));
            }
            catch (PartInitException e) {
                Q7UIPlugin.log((Throwable)e);
            }
        }
    }

    private static IQ7NamedElement getContentsElementById(String elementId, IQ7Project contentProject) {
        IQ7NamedElement[] elts;
        ReferencedProjectScope scope = new ReferencedProjectScope(contentProject);
        if (contentProject == null) {
            scope = new AllProjectScope();
        }
        if ((elts = Q7SearchCore.findById((String)elementId, (ISearchScope)scope, (IProgressMonitor)new NullProgressMonitor())) != null && elts.length > 0) {
            return elts[0];
        }
        return null;
    }
}

