/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.handler.ControlHandler;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class TableHandler
extends ControlHandler {
    private static TableHandler instance;

    public static TableHandler getInstance() {
        if (instance == null) {
            instance = new TableHandler();
        }
        return instance;
    }

    public int rowCount(final Table table) {
        return (Integer)Display.syncExec((ResultRunnable)new ResultRunnable<Integer>(){

            public Integer run() {
                return table.getItemCount();
            }
        });
    }

    public List<String> getHeaders(final Table table) {
        return (List)Display.syncExec((ResultRunnable)new ResultRunnable<List<String>>(){

            public List<String> run() {
                ArrayList<String> result = new ArrayList<String>();
                TableColumn[] tableColumnArray = table.getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn column = tableColumnArray[n2];
                    result.add(column.getText());
                    ++n2;
                }
                return result;
            }
        });
    }

    public int indexOf(Table table, String item, int columnIndex) {
        final TableItem[] tableItems = this.getSWTItems(table);
        int i = 0;
        while (i < tableItems.length) {
            int y;
            String itemText;
            if (!(itemText = (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(y = i++, columnIndex){
                private final /* synthetic */ int val$y;
                private final /* synthetic */ int val$columnIndex;
                {
                    this.val$y = n;
                    this.val$columnIndex = n2;
                }

                public String run() {
                    return tableItems[this.val$y].getText(this.val$columnIndex);
                }
            })).equals(item)) continue;
            return y;
        }
        throw new CoreLayerException("Item " + item + " does not exist in table");
    }

    public int indexOf(final Table table, final TableItem tableItem) {
        return (Integer)Display.syncExec((ResultRunnable)new ResultRunnable<Integer>(){

            public Integer run() {
                return table.indexOf(tableItem);
            }
        });
    }

    public TableItem[] getSWTItems(final Table table) {
        return (TableItem[])Display.syncExec((ResultRunnable)new ResultRunnable<TableItem[]>(){

            public TableItem[] run() {
                return table.getItems();
            }
        });
    }

    public TableItem getSWTItem(final Table table, final int index) {
        return (TableItem)Display.syncExec((ResultRunnable)new ResultRunnable<TableItem>(){

            public TableItem run() {
                return table.getItem(index);
            }
        });
    }

    public void deselectAll(final Table table) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                table.deselectAll();
            }
        });
    }

    public void selectAll(final Table table) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if ((table.getStyle() & 2) == 0) {
                    throw new CoreLayerException("Table does not support multi selection - it does not have SWT MULTI style");
                }
                table.selectAll();
                TableHandler.this.notifyWidget(13, (Widget)table);
            }
        });
    }

    public void select(final Table table, final int[] indices) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if ((table.getStyle() & 2) == 0) {
                    throw new CoreLayerException("Table does not support multi selection - it does not have SWT MULTI style");
                }
                table.select(indices);
                TableHandler.this.notifyWidget(13, (Widget)table);
            }
        });
    }

    public void select(final Table table, final int index) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (table.getItemCount() - 1 < index) {
                    throw new CoreLayerException("Unable to select item with index " + index + " because it does not exist");
                }
                table.select(index);
                TableHandler.this.notifyWidget(13, (Widget)table);
            }
        });
    }
}

