/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.matcher;

import org.eclipse.reddeer.core.handler.TreeItemHandler;
import org.eclipse.swt.widgets.TreeItem;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsEqual;

public class TreeItemTextMatcher
extends TypeSafeMatcher<TreeItem> {
    private Matcher<String> expectedTextMatcher;
    private int index = 0;

    public TreeItemTextMatcher(String expectedText) {
        this(expectedText, 0);
    }

    public TreeItemTextMatcher(String expectedText, int index) {
        this((Matcher<String>)new IsEqual((Object)expectedText), index);
    }

    public TreeItemTextMatcher(Matcher<String> expectedTextMatcher) {
        this(expectedTextMatcher, 0);
    }

    public TreeItemTextMatcher(Matcher<String> expectedTextMatcher, int index) {
        this.expectedTextMatcher = expectedTextMatcher;
        this.index = index;
    }

    protected boolean matchesSafely(TreeItem item) {
        return this.expectedTextMatcher.matches((Object)TreeItemHandler.getInstance().getText(item, this.index));
    }

    public void describeTo(Description description) {
        description.appendText("tree item text on position ");
        description.appendValue((Object)this.index);
        description.appendText(" matches ");
        description.appendDescriptionOf(this.expectedTextMatcher);
    }
}

