/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.workbench.core.condition;

import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class JobIsRunning
extends AbstractWaitCondition {
    private static final Logger log = Logger.getLogger(JobIsRunning.class);
    private Matcher[] consideredJobs;
    private Matcher[] excludeJobs;
    private boolean skipSystemJobs;
    private Job[] currentJobs;

    public JobIsRunning() {
        this(null, null);
    }

    public JobIsRunning(Matcher consideredJob) {
        this(new Matcher[]{consideredJob});
    }

    public JobIsRunning(Matcher consideredJob, boolean skipSystemJobs) {
        this(new Matcher[]{consideredJob}, null, skipSystemJobs);
    }

    public JobIsRunning(Matcher[] consideredJobs) {
        this(consideredJobs, null);
    }

    public JobIsRunning(Matcher[] consideredJobs, Matcher[] excludeJobs) {
        this(consideredJobs, excludeJobs, true);
    }

    public JobIsRunning(Matcher[] consideredJobs, Matcher[] excludeJobs, boolean skipSystemJobs) {
        this.consideredJobs = consideredJobs;
        this.excludeJobs = excludeJobs;
        this.skipSystemJobs = skipSystemJobs;
    }

    public boolean test() {
        Job[] jobArray = this.currentJobs = Job.getJobManager().find(null);
        int n = this.currentJobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            if (this.excludeJobs != null && CoreMatchers.anyOf((Matcher[])this.excludeJobs).matches((Object)job.getName())) {
                log.debug("  job '%s' specified by excludeJobs matchers, skipped", new Object[]{job.getName()});
            } else if (this.consideredJobs != null && !CoreMatchers.anyOf((Matcher[])this.consideredJobs).matches((Object)job.getName())) {
                log.debug("  job '%s' is not listed in considered jobs, ignore it", new Object[]{job.getName()});
            } else if (this.skipSystemJobs && job.isSystem()) {
                log.debug("  job '%s' is a system job, skipped", new Object[]{job.getName()});
            } else if (job.getState() == 1) {
                log.debug("  job '%s' is not running, skipped", new Object[]{job.getName()});
            } else {
                log.debug("  job '%s' has no excuses, wait for it", new Object[]{job.getName()});
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String description() {
        return "at least one job is running";
    }

    public String errorMessageWhile() {
        return this.createErrorMesssageWithJobsList("The following jobs are still running:\n");
    }

    public String errorMessageUntil() {
        return this.createErrorMesssageWithJobsList("The following jobs are not running:\n");
    }

    private String createErrorMesssageWithJobsList(String messageStart) {
        StringBuilder msg = new StringBuilder(messageStart);
        Job[] jobArray = this.currentJobs;
        int n = this.currentJobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            if (!(this.excludeJobs != null && CoreMatchers.anyOf((Matcher[])this.excludeJobs).matches((Object)job.getName()) || this.consideredJobs != null && !CoreMatchers.anyOf((Matcher[])this.consideredJobs).matches((Object)job.getName()) || this.skipSystemJobs && job.isSystem() || job.getState() == 1)) {
                msg.append("\t").append(job.getName()).append("\n");
            }
            ++n2;
        }
        return msg.toString();
    }
}

