/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.ui.browser;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.matcher.MatcherBuilder;
import org.eclipse.reddeer.common.wait.GroupWait;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitProvider;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWrapper;
import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.eclipse.condition.BrowserHasURL;
import org.eclipse.reddeer.swt.api.Browser;
import org.eclipse.reddeer.swt.condition.PageIsLoaded;
import org.eclipse.reddeer.swt.impl.browser.InternalBrowser;
import org.eclipse.reddeer.workbench.impl.editor.AbstractEditor;
import org.eclipse.reddeer.workbench.matcher.EditorPartTitleMatcher;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.internal.browser.WebBrowserEditor;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class BrowserEditor
extends AbstractEditor {
    private InternalBrowser browser = new InternalBrowser();
    private static final TimePeriod TIMEOUT = TimePeriod.LONG;

    public BrowserEditor(String title) {
        this((Matcher<String>)new WithTextMatcher(title));
    }

    public BrowserEditor(Matcher<String> titleMatcher) {
        super(BrowserEditor.createBrowserEditorMatchers(titleMatcher));
    }

    public void openPageURL(String url) {
        this.browser.setURL(url);
        new WaitUntil((WaitCondition)new PageIsLoaded((Browser)this.browser), TIMEOUT);
    }

    public void refreshPage() {
        this.browser.setURL(this.browser.getURL());
        new WaitUntil((WaitCondition)new PageIsLoaded((Browser)this.browser), TIMEOUT);
    }

    public void back() {
        String prevUrl = this.browser.getURL();
        this.browser.back();
        new GroupWait(TIMEOUT, new WaitWrapper[]{WaitProvider.waitWhile((WaitCondition)new BrowserHasURL(this, prevUrl)), WaitProvider.waitUntil((WaitCondition)new PageIsLoaded((Browser)this.browser))});
    }

    public void forward() {
        String prevUrl = this.browser.getURL();
        this.browser.forward();
        new GroupWait(TIMEOUT, new WaitWrapper[]{WaitProvider.waitWhile((WaitCondition)new BrowserHasURL(this, prevUrl)), WaitProvider.waitUntil((WaitCondition)new PageIsLoaded((Browser)this.browser))});
    }

    public String getPageURL() {
        return this.browser.getURL();
    }

    public String getText() {
        return this.browser.getText();
    }

    private static Matcher[] createBrowserEditorMatchers(Matcher<String> titleMatcher) {
        Matcher[] matchers = MatcherBuilder.getInstance().addMatcher(new Matcher[0], (Matcher)new BrowserEditorMatcher());
        matchers = MatcherBuilder.getInstance().addMatcher(matchers, (Matcher)new EditorPartTitleMatcher(titleMatcher));
        return matchers;
    }

    private static class BrowserEditorMatcher
    extends TypeSafeMatcher<IEditorPart> {
        private BrowserEditorMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("Editor is of type WebBrowserEditor");
        }

        protected boolean matchesSafely(IEditorPart item) {
            return item instanceof WebBrowserEditor;
        }
    }
}

