/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.wst.server.ui.cnf;

import java.util.Arrays;
import java.util.List;

public class ServersViewEnums {
    private ServersViewEnums() {
    }

    public static enum ProjectState {
        STARTED("Started"),
        STOPPED("Stopped");

        private String text;

        private ProjectState(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public static ProjectState getByText(String text) {
            ProjectState[] projectStateArray = ProjectState.values();
            int n = projectStateArray.length;
            int n2 = 0;
            while (n2 < n) {
                ProjectState state = projectStateArray[n2];
                if (state.getText().equals(text)) {
                    return state;
                }
                ++n2;
            }
            throw new IllegalArgumentException("There is no enumeration with text " + text);
        }
    }

    public static enum ProjectStatus {
        SYNCHRONIZED("Synchronized"),
        REPUBLISHED("Republished");

        private String text;

        private ProjectStatus(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public static ProjectStatus getByText(String text) {
            ProjectStatus[] projectStatusArray = ProjectStatus.values();
            int n = projectStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                ProjectStatus status = projectStatusArray[n2];
                if (status.getText().equals(text)) {
                    return status;
                }
                ++n2;
            }
            throw new IllegalArgumentException("There is no enumeration with text " + text);
        }
    }

    public static enum ServerPublishState {
        SYNCHRONIZED("Synchronized"),
        PUBLISHING("Publishing..."),
        RESTART("Restart"),
        REPUBLISH("Republish"),
        RESTART_REPUBLISH("Restart and republish"),
        NONE("");

        private String text;

        private ServerPublishState(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public static ServerPublishState getByText(String text) {
            ServerPublishState[] serverPublishStateArray = ServerPublishState.values();
            int n = serverPublishStateArray.length;
            int n2 = 0;
            while (n2 < n) {
                ServerPublishState status = serverPublishStateArray[n2];
                if (status.getText().equals(text)) {
                    return status;
                }
                ++n2;
            }
            throw new IllegalArgumentException("There is no enumeration with text " + text);
        }
    }

    public static enum ServerState {
        STARTING("Starting"),
        STARTED("Started"),
        DEBUGGING("Debugging"),
        PROFILING("Profiling"),
        STOPPING("Stopping"),
        STOPPED("Stopped"),
        NONE("");

        private String text;

        private ServerState(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public static ServerState getByText(String text) {
            ServerState[] serverStateArray = ServerState.values();
            int n = serverStateArray.length;
            int n2 = 0;
            while (n2 < n) {
                ServerState state = serverStateArray[n2];
                if (state.getText().equals(text)) {
                    return state;
                }
                ++n2;
            }
            throw new IllegalArgumentException("There is no enumeration with text " + text);
        }

        public static List<ServerState> getRunningStates() {
            return Arrays.asList(STARTED, DEBUGGING, PROFILING);
        }

        public boolean isRunningState() {
            return ServerState.getRunningStates().contains((Object)this);
        }
    }
}

