/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.dataobject;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.dataobject.DoConvenienceMethodsUpdateOperation;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.ui.util.S2eUiUtils;

public class UpdateDoConvenienceMethodsInSelectionHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        Set<IType> types = S2eUiUtils.getTypesInEventSelection(event);
        if (types.isEmpty()) {
            UpdateDoConvenienceMethodsInSelectionHandler.logNoSelection();
            return null;
        }
        EclipseEnvironment.runInEclipseEnvironment((e, p) -> UpdateDoConvenienceMethodsInSelectionHandler.updateDoConvenienceMethods(types, e, (IProgress)p));
        return null;
    }

    private static void updateDoConvenienceMethods(Collection<IType> types, EclipseEnvironment env, IProgress progress) {
        List scoutTypes = types.stream().map(arg_0 -> ((EclipseEnvironment)env).toScoutType(arg_0)).collect(Collectors.toList());
        new DoConvenienceMethodsUpdateOperation().withLineSeparator(Util.getLineSeparator(null, null)).withDataObjects(scoutTypes).accept((IEnvironment)env, progress);
    }

    private static void logNoSelection() {
        SdkLog.warning((CharSequence)"Cannot update DO convenience methods in the selected scope because no classes are selected.", (Object[])new Object[0]);
    }
}

