/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation;

import java.util.function.Consumer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.manipulation.JavaManipulation;
import org.eclipse.jdt.core.manipulation.OrganizeImportsOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.s2e.environment.EclipseProgress;

public class OrganizeImportOperation
implements Consumer<EclipseProgress> {
    private final ICompilationUnit m_icu;

    public OrganizeImportOperation(ICompilationUnit icu) {
        this.m_icu = (ICompilationUnit)Ensure.notNull((Object)icu);
    }

    @Override
    public void accept(EclipseProgress t) {
        if (JavaManipulation.getPreferenceNodeId() == null) {
            return;
        }
        ICompilationUnit unit = this.getCompilationUnit();
        try {
            CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)unit.getJavaProject());
            OrganizeImportsOperation organizeImps = new OrganizeImportsOperation(unit, null, settings.importIgnoreLowercase, !unit.isWorkingCopy(), true, null);
            organizeImps.run((IProgressMonitor)t.monitor());
        }
        catch (CoreException e) {
            throw new SdkException((Throwable)e);
        }
    }

    public ICompilationUnit getCompilationUnit() {
        return this.m_icu;
    }

    public String toString() {
        return "Organize imports of compilation unit '" + this.getCompilationUnit().getElementName() + "'.";
    }
}

