/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation.project;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectImportResult;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.project.ScoutProjectNewHelper;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.environment.CompilationUnitWriteOperation;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.environment.EclipseProgress;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.osgi.framework.Version;

public class ScoutProjectNewOperation
implements BiConsumer<EclipseEnvironment, EclipseProgress> {
    public static final String TEMPLATE_VERSION = "org.eclipse.scout.archetype.version";
    protected static final String EXEC_ENV_PREFIX = "JavaSE-";
    protected static final String MIN_JVM_VERSION = "1.8";
    private String m_groupId;
    private String m_artifactId;
    private String m_displayName;
    private boolean m_useJsClient = true;
    private Path m_targetDirectory;
    private List<IProject> m_createdProjects;

    @Override
    public void accept(EclipseEnvironment env, EclipseProgress progress) {
        try {
            progress.init(100, this.toString(), new Object[0]);
            ScoutProjectNewHelper.createProject((Path)this.getTargetDirectory(), (String)this.getGroupId(), (String)this.getArtifactId(), (String)this.getDisplayName(), (boolean)this.isUseJsClient(), (String)ScoutProjectNewOperation.getDefaultWorkspaceJavaVersion(), (IEnvironment)env, (IProgress)progress.newChild(5));
            this.m_createdProjects = this.importIntoWorkspace(progress.newChild(90));
            this.formatCreatedProjects(progress.newChild(5));
        }
        catch (Exception e) {
            throw new SdkException((CharSequence)"Unable to create Scout Project.", new Object[]{e});
        }
    }

    protected static String getDefaultWorkspaceJavaVersion() {
        return ScoutProjectNewOperation.versionToString(ScoutProjectNewOperation.computeDefaultWorkspaceJavaVersion());
    }

    protected static String versionToString(Version version) {
        StringBuilder b = new StringBuilder(4);
        b.append(version.getMajor());
        if (version.getMinor() != 0) {
            b.append('.').append(version.getMinor());
        }
        return b.toString();
    }

    protected static Version computeDefaultWorkspaceJavaVersion() {
        Version result = Version.parseVersion((String)MIN_JVM_VERSION);
        IVMInstall defaultVm = JavaRuntime.getDefaultVMInstall();
        if (defaultVm == null) {
            return result;
        }
        for (IExecutionEnvironment env : JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments()) {
            Version cur;
            if (!env.isStrictlyCompatible(defaultVm) || (cur = ScoutProjectNewOperation.execEnvironmentToVersion(env.getId())).compareTo(result) <= 0) continue;
            result = cur;
        }
        return result;
    }

    protected static Version execEnvironmentToVersion(String executionEnvId) {
        String numPart;
        if (executionEnvId != null && executionEnvId.startsWith(EXEC_ENV_PREFIX) && Strings.hasText((CharSequence)(numPart = executionEnvId.substring(EXEC_ENV_PREFIX.length())))) {
            try {
                return Version.parseVersion((String)numPart);
            }
            catch (IllegalArgumentException e) {
                SdkLog.warning((CharSequence)"Invalid number part ({}) in execution environment {}.", (Object[])new Object[]{numPart, executionEnvId, e});
            }
        }
        return Version.parseVersion((String)MIN_JVM_VERSION);
    }

    protected void formatCreatedProjects(EclipseProgress progress) throws CoreException {
        progress.init(this.m_createdProjects.size(), "Format created projects", new Object[0]);
        for (IProject createdProject : this.m_createdProjects) {
            IJavaProject jp;
            if (!createdProject.isAccessible() || !createdProject.hasNature("org.eclipse.jdt.core.javanature") || !JdtUtils.exists((IJavaElement)(jp = JavaCore.create((IProject)createdProject)))) continue;
            ScoutProjectNewOperation.formatProject(progress.newChild(1), jp);
        }
    }

    protected static void formatProject(EclipseProgress progress, IJavaProject p) throws JavaModelException {
        for (IPackageFragment pck : p.getPackageFragments()) {
            for (ICompilationUnit u : pck.getCompilationUnits()) {
                new CompilationUnitWriteOperation(u, u.getSource()).accept(progress);
            }
        }
    }

    protected List<IProject> importIntoWorkspace(EclipseProgress progress) throws CoreException {
        List subFolders;
        try (Stream<Path> files = Files.list(this.getTargetDirectory().resolve(this.getArtifactId()));){
            subFolders = files.collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.scout.sdk.s2e", "Unable to list content of " + this.getTargetDirectory(), (Throwable)e));
        }
        ArrayList<MavenProjectInfo> projects = new ArrayList<MavenProjectInfo>(subFolders.size());
        for (Path subFolder : subFolders) {
            Path pom = subFolder.resolve("pom.xml");
            if (!Files.isReadable(pom) || !Files.isRegularFile(pom, new LinkOption[0])) continue;
            projects.add(new MavenProjectInfo(subFolder.getFileName().toString(), pom.toFile(), null, null));
        }
        return MavenPlugin.getProjectConfigurationManager().importProjects(projects, new ProjectImportConfiguration(), (IProgressMonitor)progress.newChild(projects.size()).monitor()).stream().filter(Objects::nonNull).map(IMavenProjectImportResult::getProject).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public String getDisplayName() {
        return this.m_displayName;
    }

    public void setDisplayName(String displayName) {
        this.m_displayName = displayName;
    }

    public Path getTargetDirectory() {
        return this.m_targetDirectory;
    }

    public void setTargetDirectory(Path targetDirectory) {
        this.m_targetDirectory = targetDirectory;
    }

    public List<IProject> getCreatedProjects() {
        return Collections.unmodifiableList(this.m_createdProjects);
    }

    public String getGroupId() {
        return this.m_groupId;
    }

    public void setGroupId(String groupId) {
        this.m_groupId = groupId;
    }

    public String getArtifactId() {
        return this.m_artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.m_artifactId = artifactId;
    }

    public boolean isUseJsClient() {
        return this.m_useJsClient;
    }

    public void setUseJsClient(boolean useJsClient) {
        this.m_useJsClient = useJsClient;
    }

    public String toString() {
        return "Create new Scout Project";
    }
}

