/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui.tools.api.selection.page;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sirius.common.tools.api.util.StringMatcher;
import org.eclipse.sirius.common.tools.api.util.TreeItemWrapper;
import org.eclipse.sirius.common.ui.tools.api.view.common.item.CommonItem;

public class EObjectSelectionFilter
extends ViewerFilter {
    private String regExp;
    private TreeViewer treeViewer;

    public void setPrefix(String newRegExp) {
        this.regExp = newRegExp;
        if (this.treeViewer != null) {
            this.treeViewer.refresh();
        }
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        boolean selected = false;
        Object element2 = null;
        if (element instanceof TreeItemWrapper) {
            for (TreeItemWrapper childItem : ((TreeItemWrapper)element).getChildren()) {
                if (!this.select(viewer, element, childItem)) continue;
                return true;
            }
            element2 = ((TreeItemWrapper)element).getWrappedObject();
        } else {
            element2 = element;
        }
        if (element2 instanceof EObject || element2 instanceof CommonItem) {
            if (this.regExp == null || this.regExp.length() == 0) {
                selected = true;
            }
            if (this.treeViewer != null) {
                String text = ((ILabelProvider)this.treeViewer.getLabelProvider()).getText(element2);
                if (!selected && text != null && this.getStringMatcher().match(text)) {
                    selected = true;
                }
            }
        }
        return selected;
    }

    public void setTreeViewer(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    private StringMatcher getStringMatcher() {
        String computedRegExp = this.regExp;
        if (this.regExp == null) {
            computedRegExp = "";
        }
        if (computedRegExp.endsWith(" ")) {
            computedRegExp = computedRegExp.substring(0, computedRegExp.lastIndexOf(32));
        }
        computedRegExp = String.valueOf(computedRegExp) + "*";
        return new StringMatcher(computedRegExp, true, false);
    }
}

