/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.policies;

import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ContainerNodeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramEdgeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramEdgeEditPart;
import org.eclipse.swt.widgets.Display;

public class ContainerCompartmentNodeEditPolicy
extends ContainerNodeEditPolicy {
    private RectangleFigure highlightFigure;

    protected ConnectionAnchor getTargetConnectionAnchor(CreateConnectionRequest request) {
        EditPart target = request.getTargetEditPart();
        if (target instanceof ShapeCompartmentEditPart && target.getParent() instanceof INodeEditPart) {
            return ((INodeEditPart)target.getParent()).getTargetConnectionAnchor((Request)request);
        }
        return super.getTargetConnectionAnchor(request);
    }

    protected ConnectionAnchor getSourceConnectionAnchor(CreateConnectionRequest request) {
        EditPart source = request.getSourceEditPart();
        if (source instanceof ShapeCompartmentEditPart && source.getParent() instanceof INodeEditPart) {
            return ((INodeEditPart)source.getParent()).getSourceConnectionAnchor((Request)request);
        }
        return super.getSourceConnectionAnchor(request);
    }

    public EditPart getTargetEditPart(Request request) {
        if ("connection start".equals(request.getType()) && request instanceof CreateConnectionViewRequest && "NoteAttachment".equals(((CreateConnectionViewRequest)request).getConnectionViewDescriptor().getSemanticHint())) {
            return this.getHost().getParent();
        }
        return super.getTargetEditPart(request);
    }

    protected void showTargetConnectionFeedback(DropRequest request) {
        this.removeHighlight();
        boolean reveal = false;
        if (request instanceof ReconnectRequest) {
            reveal = true;
            this.addHighlight(reveal);
        }
    }

    private void addHighlight(boolean reveal) {
        Rectangle bounds = this.getHostFigure().getBounds().getCopy();
        this.getHostFigure().getParent().translateToAbsolute((Translatable)bounds);
        this.getFeedbackLayer().translateToRelative((Translatable)bounds);
        this.highlightFigure = new RectangleFigure(){

            public void paint(Graphics graphics) {
                graphics.setAlpha(128);
                super.paint(graphics);
            }
        };
        this.highlightFigure.setBounds(bounds);
        this.highlightFigure.setBackgroundColor(Display.getCurrent().getSystemColor(26));
        this.addFeedback((IFigure)this.highlightFigure);
        if (reveal) {
            this.getHost().getViewer().reveal(this.getHost());
        }
    }

    protected void eraseTargetConnectionFeedback(DropRequest request) {
        this.removeHighlight();
    }

    private void removeHighlight() {
        if (this.highlightFigure != null) {
            this.removeFeedback((IFigure)this.highlightFigure);
            this.highlightFigure = null;
        }
        if (this.getHostFigure() instanceof AbstractDiagramEdgeEditPart.ViewEdgeFigure) {
            ((IDiagramEdgeEditPart)this.getHost()).refreshForegroundColor();
            ((IDiagramEdgeEditPart)this.getHost()).refreshLineStyle();
        }
    }
}

