/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.stepper.extensions;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.runtime.interfaces.IConditionTester;
import org.eclipse.tcf.te.runtime.interfaces.ISharedConstants;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.stepper.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IFullQualifiedId;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStep;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepExecutor;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepper;
import org.eclipse.tcf.te.runtime.stepper.nls.Messages;
import org.eclipse.tcf.te.runtime.utils.ProgressHelper;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;

public class StepExecutor
implements IStepExecutor {
    private final IStepper stepper;
    public final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public StepExecutor(IStepper stepper) {
        this.stepper = stepper;
    }

    @Override
    public final void execute(final IStep step, final IFullQualifiedId id, final IStepContext context, final IPropertiesContainer data, IProgressMonitor progress) throws CoreException {
        block15: {
            Assert.isNotNull((Object)step);
            Assert.isNotNull((Object)id);
            Assert.isNotNull((Object)context);
            Assert.isNotNull((Object)data);
            Assert.isNotNull((Object)progress);
            long startTime = System.currentTimeMillis();
            CoreBundleActivator.getTraceHandler().trace("StepExecutor#execute: *** START (" + step.getLabel() + ")", 0, "trace/stepping", 2, (Object)this);
            CoreBundleActivator.getTraceHandler().trace(" [" + ISharedConstants.TIME_FORMAT.format(new Date(startTime)) + "]" + " ***", 0, "profile/stepping", 2, (Object)this);
            int ticksToUse = step.getTotalWork(context, data);
            progress = ProgressHelper.getProgressMonitor((IProgressMonitor)progress, (int)ticksToUse);
            Assert.isNotNull((Object)progress);
            ProgressHelper.beginTask((IProgressMonitor)progress, (String)step.getLabel(), (int)ticksToUse);
            Callback callback = new Callback();
            CoreException result = null;
            boolean canceled = false;
            try {
                step.initializeFrom(context, data, id, progress);
                step.validateExecute(context, data, id, progress);
                step.execute(context, data, id, progress, (ICallback)callback);
                Callback.CallbackDoneConditionTester conditionTester = new Callback.CallbackDoneConditionTester((ICallback)callback, progress, step.getCancelTimeout()){
                    boolean cancelCalled;
                    {
                        super($anonymous0, $anonymous1, $anonymous2);
                        this.cancelCalled = false;
                    }

                    public boolean isConditionFulfilled() {
                        if (!this.cancelCalled && this.monitor != null && this.monitor.isCanceled()) {
                            this.cancelCalled = true;
                            step.cancel(context, data, id, this.monitor);
                        }
                        return super.isConditionFulfilled();
                    }
                };
                ExecutorsUtil.waitAndExecute((long)0L, (IConditionTester)conditionTester);
                if (callback.getStatus() == null || callback.getStatus().isOK()) {
                    return;
                }
                try {
                    if (callback.getStatus().matches(8) || progress.isCanceled()) {
                        throw new OperationCanceledException(callback.getStatus().getMessage());
                    }
                    result = this.normalizeStatus(step, id, context, data, callback.getStatus(), progress);
                }
                catch (OperationCanceledException e) {
                    CoreBundleActivator.getTraceHandler().trace("StepExecutor#execute: *** CANCEL (" + step.getLabel() + ")" + ", message = '" + e.getMessage() + "'", 0, "trace/stepping", 2, (Object)this);
                    canceled = true;
                    throw e;
                }
                catch (Exception e) {
                    result = this.normalizeStatus(step, id, context, data, StatusHelper.getStatus((Throwable)e), progress);
                    if (!progress.isCanceled()) {
                        progress.done();
                    }
                    step.cleanup(context, data, id, progress);
                    long endTime = System.currentTimeMillis();
                    CoreBundleActivator.getTraceHandler().trace(" [" + ISharedConstants.TIME_FORMAT.format(new Date(endTime)) + " , delay = " + (endTime - startTime) + " ms]" + " ***", 0, "profile/stepping", 2, (Object)this);
                    if (canceled) break block15;
                    if (result == null) {
                        CoreBundleActivator.getTraceHandler().trace("StepExecutor#execute: *** DONE (" + step.getLabel() + ")", 0, "trace/stepping", 2, (Object)this);
                        break block15;
                    }
                    CoreBundleActivator.getTraceHandler().trace("StepExecutor#execute: *** ERROR (" + step.getLabel() + ")" + ", message = '" + result.getLocalizedMessage() + "'" + ", cause = " + result.getStatus().getException(), 0, "trace/stepping", 2, (Object)this);
                    throw result;
                }
            }
            finally {
                if (!progress.isCanceled()) {
                    progress.done();
                }
                step.cleanup(context, data, id, progress);
                long endTime = System.currentTimeMillis();
                CoreBundleActivator.getTraceHandler().trace(" [" + ISharedConstants.TIME_FORMAT.format(new Date(endTime)) + " , delay = " + (endTime - startTime) + " ms]" + " ***", 0, "profile/stepping", 2, (Object)this);
                if (!canceled) {
                    if (result == null) {
                        CoreBundleActivator.getTraceHandler().trace("StepExecutor#execute: *** DONE (" + step.getLabel() + ")", 0, "trace/stepping", 2, (Object)this);
                    } else {
                        CoreBundleActivator.getTraceHandler().trace("StepExecutor#execute: *** ERROR (" + step.getLabel() + ")" + ", message = '" + result.getLocalizedMessage() + "'" + ", cause = " + result.getStatus().getException(), 0, "trace/stepping", 2, (Object)this);
                        throw result;
                    }
                }
            }
        }
    }

    private CoreException normalizeStatus(IStep step, IFullQualifiedId id, IStepContext context, IPropertiesContainer data, IStatus status, IProgressMonitor progress) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)data);
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)step);
        String message = this.formatMessage(status, step, id, context, data);
        status = new Status(status.getSeverity(), status.getPlugin(), status.getCode(), message != null ? message : status.getMessage(), status.getException());
        return new CoreException(status);
    }

    protected String formatMessage(IStatus status, IStep step, IFullQualifiedId id, IStepContext context, IPropertiesContainer data) {
        String template = null;
        switch (status.getSeverity()) {
            case 1: {
                template = Messages.StepExecutor_info_stepFailed;
                break;
            }
            case 2: {
                template = Messages.StepExecutor_warning_stepFailed;
                break;
            }
            case 4: {
                template = Messages.StepExecutor_error_stepFailed;
            }
        }
        if (template == null) {
            return status.getMessage();
        }
        String formattedMessage = NLS.bind((String)template, (Object[])new String[]{this.stepper.getLabel(), status.getMessage(), step.getLabel() != null && step.getLabel().trim().length() > 0 ? step.getLabel() : step.getId()});
        if (Platform.inDebugMode()) {
            String date = this.DATE_FORMAT.format(new Date(System.currentTimeMillis()));
            formattedMessage = String.valueOf(formattedMessage) + NLS.bind((String)Messages.StepExecutor_stepFailed_debugInfo, (Object[])new String[]{context.getName(), id.toString().replaceAll("/>", "/>\n"), date});
        }
        return formattedMessage;
    }
}

