/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class OrderedTestSuite
extends TestSuite {
    public OrderedTestSuite(Class<? extends TestCase> testClass, String[] testMethods) {
        super(testClass.getName());
        HashSet<String> existingMethods = new HashSet<String>();
        Method[] methods = testClass.getMethods();
        Object[] objectArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = objectArray[n2];
            existingMethods.add(method.getName());
            ++n2;
        }
        objectArray = testMethods;
        n = testMethods.length;
        n2 = 0;
        while (n2 < n) {
            Object testMethod = objectArray[n2];
            if (existingMethods.remove(testMethod)) {
                this.addTest(OrderedTestSuite.createTest(testClass, (String)testMethod));
            } else {
                this.addTest(OrderedTestSuite.error(testClass, (String)testMethod, new IllegalArgumentException("Class '" + testClass.getName() + " misses test method '" + (String)testMethod + "'.")));
            }
            ++n2;
        }
        for (String existingMethod : existingMethods) {
            if (!existingMethod.startsWith("test")) continue;
            this.addTest(OrderedTestSuite.error(testClass, existingMethod, new IllegalArgumentException("Test method '" + existingMethod + "' not listed in OrderedTestSuite of class '" + testClass.getName() + "'.")));
        }
    }

    public OrderedTestSuite(Class<? extends TestCase> testClass) {
        this(testClass, testClass.getName());
    }

    public OrderedTestSuite(Class<? extends TestCase> testClass, String name) {
        super(name);
        class SortingException
        extends RuntimeException {
            private static final long serialVersionUID = 1L;

            public SortingException(String message) {
                super(message);
            }
        }
        TestSuite vmOrderSuite = new TestSuite(testClass);
        ArrayList<Test> tests = Collections.list(vmOrderSuite.tests());
        try {
            List<String> orderedMethodNames = OrderedTestSuite.getBytecodeOrderedTestNames(testClass);
            tests.sort((o1, o2) -> {
                if (o1 instanceof TestCase && o2 instanceof TestCase) {
                    TestCase t1 = (TestCase)o1;
                    TestCase t2 = (TestCase)o2;
                    int i1 = orderedMethodNames.indexOf(t1.getName());
                    int i2 = orderedMethodNames.indexOf(t2.getName());
                    if (i1 != -1 && i2 != -1) {
                        return i1 - i2;
                    }
                }
                throw new SortingException("suite failed to detect test order: " + o1 + ", " + o2);
            });
        }
        catch (IOException | SortingException e) {
            this.addTest(OrderedTestSuite.error(testClass, "suite failed to detect test order", e));
        }
        for (Test test : tests) {
            this.addTest(test);
        }
    }

    public static List<String> getBytecodeOrderedTestNames(Class<? extends TestCase> testClass) throws IOException {
        ArrayList<String> orderedMethodNames = new ArrayList<String>();
        Class<? extends TestCase> c = testClass;
        while (Test.class.isAssignableFrom(c)) {
            OrderedTestSuite.addDeclaredTestMethodNames(c, orderedMethodNames);
            c = c.getSuperclass();
        }
        return orderedMethodNames;
    }

    private static void addDeclaredTestMethodNames(Class<?> c, ArrayList<String> methodNames) throws IOException {
        DataInputStream is;
        int magic;
        String className = c.getName();
        int lastDot = className.lastIndexOf(".");
        if (lastDot != -1) {
            className = className.substring(lastDot + 1);
        }
        if ((magic = (is = new DataInputStream(new BufferedInputStream(c.getResourceAsStream(String.valueOf(className) + ".class")))).readInt()) != -889275714) {
            throw new IOException("bad magic bytes: 0x" + Integer.toHexString(magic));
        }
        int minor = is.readUnsignedShort();
        int major = is.readUnsignedShort();
        int cpCount = is.readUnsignedShort();
        String[] constantPoolStrings = new String[cpCount];
        int i = 1;
        while (i < cpCount) {
            byte tag = is.readByte();
            switch (tag) {
                case 7: {
                    OrderedTestSuite.skip(is, 2L);
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    OrderedTestSuite.skip(is, 4L);
                    break;
                }
                case 8: {
                    OrderedTestSuite.skip(is, 2L);
                    break;
                }
                case 3: 
                case 4: {
                    OrderedTestSuite.skip(is, 4L);
                    break;
                }
                case 5: 
                case 6: {
                    OrderedTestSuite.skip(is, 8L);
                    ++i;
                    break;
                }
                case 12: {
                    OrderedTestSuite.skip(is, 4L);
                    break;
                }
                case 1: {
                    constantPoolStrings[i] = is.readUTF();
                    break;
                }
                case 15: {
                    OrderedTestSuite.skip(is, 3L);
                    break;
                }
                case 16: {
                    OrderedTestSuite.skip(is, 2L);
                    break;
                }
                case 18: {
                    OrderedTestSuite.skip(is, 4L);
                    break;
                }
                default: {
                    throw new IOException("unknown constant pool tag " + tag + " at index " + i + ". Class file version: " + major + "." + minor);
                }
            }
            ++i;
        }
        OrderedTestSuite.skip(is, 6L);
        int interfacesCount = is.readUnsignedShort();
        OrderedTestSuite.skip(is, 2 * interfacesCount);
        int fieldsCount = is.readUnsignedShort();
        int i2 = 0;
        while (i2 < fieldsCount) {
            OrderedTestSuite.skip(is, 6L);
            int attributesCount = is.readUnsignedShort();
            int j = 0;
            while (j < attributesCount) {
                OrderedTestSuite.skip(is, 2L);
                long attInfoCount = OrderedTestSuite.readUnsignedInt(is);
                OrderedTestSuite.skip(is, attInfoCount);
                ++j;
            }
            ++i2;
        }
        int methodsCount = is.readUnsignedShort();
        int i3 = 0;
        while (i3 < methodsCount) {
            String name;
            OrderedTestSuite.skip(is, 2L);
            int nameIndex = is.readUnsignedShort();
            int descIndex = is.readUnsignedShort();
            if ("()V".equals(constantPoolStrings[descIndex]) && (name = constantPoolStrings[nameIndex]).startsWith("test") && !methodNames.contains(name)) {
                methodNames.add(name);
            }
            int attributesCount = is.readUnsignedShort();
            int j = 0;
            while (j < attributesCount) {
                OrderedTestSuite.skip(is, 2L);
                long attInfoCount = OrderedTestSuite.readUnsignedInt(is);
                OrderedTestSuite.skip(is, attInfoCount);
                ++j;
            }
            ++i3;
        }
    }

    private static void skip(DataInputStream is, long bytes) throws IOException {
        while (bytes > 0L) {
            bytes -= is.skip(bytes);
        }
        if (bytes != 0L) {
            throw new IOException("error in skipping bytes: " + bytes);
        }
    }

    private static long readUnsignedInt(DataInputStream is) throws IOException {
        return (long)is.readInt() & 0xFFFFFFFFL;
    }

    private static Test error(Class<? extends TestCase> testClass, String testMethod, Exception exception) {
        final Throwable e2 = exception.fillInStackTrace();
        return new TestCase(String.valueOf(testMethod) + "(" + testClass.getName() + ")"){

            protected void runTest() throws Throwable {
                throw e2;
            }
        };
    }
}

