/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.psystem.queries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.TypeJudgement;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PDisjunction;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PProblem;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PVisibility;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

public abstract class BasePQuery
implements PQuery {
    protected PQuery.PQueryStatus status = PQuery.PQueryStatus.UNINITIALIZED;
    protected final PVisibility visibility;
    protected List<PProblem> pProblems = new ArrayList<PProblem>();
    private List<PAnnotation> annotations = new ArrayList<PAnnotation>();
    private QueryEvaluationHint evaluationHints = new QueryEvaluationHint(null, null);
    PDisjunction canonicalDisjunction;
    private List<String> parameterNames = null;
    private List<Object> wrappingQuerySpecifications = new ArrayList<Object>(1);

    @Override
    public Integer getPositionOfParameter(String parameterName) {
        this.ensureInitialized();
        int index = this.getParameterNames().indexOf(parameterName);
        return index != -1 ? Integer.valueOf(index) : null;
    }

    protected void setStatus(PQuery.PQueryStatus newStatus) {
        this.status = newStatus;
    }

    protected void addError(PProblem problem) {
        this.status = PQuery.PQueryStatus.ERROR;
        this.pProblems.add(problem);
    }

    @Override
    public PQuery.PQueryStatus getStatus() {
        return this.status;
    }

    @Override
    public List<PProblem> getPProblems() {
        return Collections.unmodifiableList(this.pProblems);
    }

    @Override
    public boolean isMutable() {
        return this.status.equals((Object)PQuery.PQueryStatus.UNINITIALIZED) || this.status.equals((Object)PQuery.PQueryStatus.INITIALIZING);
    }

    @Override
    public void checkMutability() {
        Preconditions.checkState(this.isMutable(), "Cannot edit query definition %s", this.getFullyQualifiedName());
    }

    public void setEvaluationHints(QueryEvaluationHint hints) {
        this.checkMutability();
        this.evaluationHints = hints;
    }

    @Override
    public QueryEvaluationHint getEvaluationHints() {
        this.ensureInitialized();
        return this.evaluationHints;
    }

    protected void addAnnotation(PAnnotation annotation) {
        this.checkMutability();
        this.annotations.add(annotation);
    }

    @Override
    public List<PAnnotation> getAllAnnotations() {
        this.ensureInitialized();
        return new ArrayList<PAnnotation>(this.annotations);
    }

    private Stream<PAnnotation> getAnnotationStreamByName(String name) {
        this.ensureInitialized();
        return this.annotations.stream().filter(Objects::nonNull).filter(annotation -> Objects.equals(name, annotation.getName()));
    }

    @Override
    public List<PAnnotation> getAnnotationsByName(String annotationName) {
        return this.getAnnotationStreamByName(annotationName).collect(Collectors.toList());
    }

    @Override
    public Optional<PAnnotation> getFirstAnnotationByName(String annotationName) {
        return this.getAnnotationStreamByName(annotationName).findFirst();
    }

    @Override
    public List<String> getParameterNames() {
        this.ensureInitialized();
        if (this.parameterNames == null) {
            this.parameterNames = this.getParameters().stream().map(PParameter::getName).collect(Collectors.toList());
        }
        return this.parameterNames;
    }

    @Override
    public Set<PQuery> getDirectReferredQueries() {
        this.ensureInitialized();
        return this.canonicalDisjunction.getDirectReferredQueries();
    }

    @Override
    public Set<PQuery> getAllReferredQueries() {
        this.ensureInitialized();
        return this.canonicalDisjunction.getAllReferredQueries();
    }

    @Override
    public List<Object> publishedAs() {
        return this.wrappingQuerySpecifications;
    }

    @Override
    public Set<TypeJudgement> getTypeGuarantees() {
        this.ensureInitialized();
        HashSet<TypeJudgement> result = new HashSet<TypeJudgement>();
        List<PParameter> parameters = this.getParameters();
        int i = 0;
        while (i < parameters.size()) {
            PParameter parameter = parameters.get(i);
            IInputKey declaredUnaryType = parameter.getDeclaredUnaryType();
            if (declaredUnaryType != null) {
                result.add(new TypeJudgement(declaredUnaryType, Tuples.staticArityFlatTupleOf(i)));
            }
            ++i;
        }
        return result;
    }

    public BasePQuery(PVisibility visibility) {
        this.visibility = visibility;
    }

    @Override
    public PDisjunction getDisjunctBodies() {
        this.ensureInitialized();
        Preconditions.checkState(!this.status.equals((Object)PQuery.PQueryStatus.ERROR), "Query %s contains errors.", this.getFullyQualifiedName());
        return this.canonicalDisjunction;
    }

    @Override
    public final void ensureInitialized() {
        try {
            if (this.status.equals((Object)PQuery.PQueryStatus.UNINITIALIZED)) {
                this.setStatus(PQuery.PQueryStatus.INITIALIZING);
                this.setBodies(this.doGetContainedBodies());
                this.setStatus(PQuery.PQueryStatus.OK);
            }
        }
        catch (QueryInitializationException e) {
            this.addError(new PProblem(e, e.getShortMessage()));
            throw e;
        }
    }

    protected final void setBodies(Set<PBody> bodies) {
        this.canonicalDisjunction = new PDisjunction(this, bodies);
        for (PBody body : this.canonicalDisjunction.getBodies()) {
            body.setStatus(null);
        }
        this.setStatus(PQuery.PQueryStatus.OK);
    }

    protected abstract Set<PBody> doGetContainedBodies();

    public String toString() {
        return String.format("PQuery<%s>=%s", this.getFullyQualifiedName(), super.toString());
    }

    @Override
    public PVisibility getVisibility() {
        return this.visibility;
    }
}

