/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.handlers;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.comment.CommentingStrategy;
import org.eclipse.wst.sse.ui.internal.comment.CommentingStrategyRegistry;
import org.eclipse.wst.sse.ui.internal.handlers.AbstractCommentHandler;

public final class AddBlockCommentHandler
extends AbstractCommentHandler {
    @Override
    protected void processAction(ITextEditor textEditor, IStructuredDocument document, ITextSelection textSelection) {
        IStructuredModel model = null;
        boolean changed = false;
        DocumentRewriteSession session = null;
        try {
            try {
                model = StructuredModelManager.getModelManager().getModelForEdit(document);
                if (model != null) {
                    model.beginRecording((Object)this, SSEUIMessages.AddBlockComment_label, SSEUIMessages.AddBlockComment_description);
                    model.aboutToChangeModel();
                    if (document instanceof IDocumentExtension4) {
                        session = ((IDocumentExtension4)document).startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
                    }
                    changed = true;
                    ITypedRegion[] typedRegions = document.computePartitioning(textSelection.getOffset(), textSelection.getLength());
                    CommentingStrategy commentType = CommentingStrategyRegistry.getDefault().getBlockCommentingStrategy(model.getContentTypeIdentifier(), typedRegions);
                    if (commentType != null) {
                        commentType.apply(document, textSelection.getOffset(), textSelection.getLength());
                    }
                }
            }
            catch (BadLocationException e) {
                Logger.logException((String)("The given selection " + textSelection + " must be invalid"), (Throwable)e);
                if (session != null && document instanceof IDocumentExtension4) {
                    ((IDocumentExtension4)document).stopRewriteSession(session);
                }
                if (model != null) {
                    model.endRecording((Object)this);
                    if (changed) {
                        model.changedModel();
                    }
                    model.releaseFromEdit();
                }
            }
        }
        finally {
            if (session != null && document instanceof IDocumentExtension4) {
                ((IDocumentExtension4)document).stopRewriteSession(session);
            }
            if (model != null) {
                model.endRecording((Object)this);
                if (changed) {
                    model.changedModel();
                }
                model.releaseFromEdit();
            }
        }
    }
}

