/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.testing;

import com.google.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.internal.text.html.BrowserInformationControlInput;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.hover.IEObjectHover;
import org.eclipse.xtext.ui.testing.AbstractEditorTest;
import org.eclipse.xtext.ui.testing.util.IResourcesSetupUtil;

public abstract class AbstractHoverTest
extends AbstractEditorTest {
    @Inject
    protected IEObjectHover eObjectHover;
    @Inject
    protected FileExtensionProvider fileExtensionProvider;

    public void hasHoverOver(CharSequence charSequence, String hoverText, String hoverContent) {
        Region region = new Region(charSequence.toString().indexOf(hoverText), hoverText.length());
        this.hasHoverOver(charSequence, (IRegion)region, hoverContent);
    }

    public void hasHoverOver(CharSequence charSequence, IRegion hoverRegion, String hoverContent) {
        IFile file = this.dslFile(this.getProjectName(), this.getFileName(), this.getFileExtension(), charSequence);
        this.hoverPopupHasContent(this.hoveringOver(file, hoverRegion), hoverContent);
    }

    protected String getProjectName() {
        return "HoverTestProject";
    }

    protected String getFileName() {
        return "hover";
    }

    protected String getFileExtension() {
        return this.fileExtensionProvider.getPrimaryFileExtension();
    }

    protected XtextEditor openInEditor(IFile dslFile) {
        try {
            IResourcesSetupUtil.waitForBuild((IProgressMonitor)new NullProgressMonitor());
            return this.openEditor(dslFile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected BrowserInformationControlInput hoveringOver(IFile dslFile, IRegion hoverRegion) {
        XtextEditor editor = this.openInEditor(dslFile);
        Object hoverInfo = ((ITextHoverExtension2)this.eObjectHover).getHoverInfo2((ITextViewer)editor.getInternalSourceViewer(), hoverRegion);
        return (BrowserInformationControlInput)hoverInfo;
    }

    protected void hoverPopupHasContent(BrowserInformationControlInput info, String expectedHoverContent) {
        AbstractHoverTest.assertNotNull((String)"No hover found!", (Object)info);
        String actualHoverContent = info.getHtml();
        String message = "Could not find the text '%s' in the hover popup:\n%s\n";
        AbstractHoverTest.assertTrue((String)String.format(message, expectedHoverContent, actualHoverContent), (boolean)actualHoverContent.contains(expectedHoverContent));
    }
}

