/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.mandas.docker.client.CompressedDirectory;
import org.mandas.docker.client.DockerCertificates;
import org.mandas.docker.client.DockerCertificatesStore;
import org.mandas.docker.client.DockerClient;
import org.mandas.docker.client.DockerHost;
import org.mandas.docker.client.EventStream;
import org.mandas.docker.client.ImageRef;
import org.mandas.docker.client.LogStream;
import org.mandas.docker.client.LoggingBuildHandler;
import org.mandas.docker.client.LoggingLoadHandler;
import org.mandas.docker.client.LoggingPullHandler;
import org.mandas.docker.client.LoggingPushHandler;
import org.mandas.docker.client.LogsResponseReader;
import org.mandas.docker.client.ObjectMapperProvider;
import org.mandas.docker.client.ProgressHandler;
import org.mandas.docker.client.ProgressResponseReader;
import org.mandas.docker.client.ProgressStream;
import org.mandas.docker.client.UnixConnectionSocketFactory;
import org.mandas.docker.client.VersionCompare;
import org.mandas.docker.client.auth.ConfigFileRegistryAuthSupplier;
import org.mandas.docker.client.auth.FixedRegistryAuthSupplier;
import org.mandas.docker.client.auth.RegistryAuthSupplier;
import org.mandas.docker.client.exceptions.BadParamException;
import org.mandas.docker.client.exceptions.ConflictException;
import org.mandas.docker.client.exceptions.ContainerNotFoundException;
import org.mandas.docker.client.exceptions.ContainerRenameConflictException;
import org.mandas.docker.client.exceptions.DockerCertificateException;
import org.mandas.docker.client.exceptions.DockerException;
import org.mandas.docker.client.exceptions.DockerRequestException;
import org.mandas.docker.client.exceptions.DockerTimeoutException;
import org.mandas.docker.client.exceptions.ExecCreateConflictException;
import org.mandas.docker.client.exceptions.ExecNotFoundException;
import org.mandas.docker.client.exceptions.ExecStartConflictException;
import org.mandas.docker.client.exceptions.ImageNotFoundException;
import org.mandas.docker.client.exceptions.NetworkNotFoundException;
import org.mandas.docker.client.exceptions.NodeNotFoundException;
import org.mandas.docker.client.exceptions.NonSwarmNodeException;
import org.mandas.docker.client.exceptions.NotFoundException;
import org.mandas.docker.client.exceptions.PermissionException;
import org.mandas.docker.client.exceptions.ServiceNotFoundException;
import org.mandas.docker.client.exceptions.TaskNotFoundException;
import org.mandas.docker.client.exceptions.UnsupportedApiVersionException;
import org.mandas.docker.client.exceptions.VolumeNotFoundException;
import org.mandas.docker.client.messages.Container;
import org.mandas.docker.client.messages.ContainerChange;
import org.mandas.docker.client.messages.ContainerConfig;
import org.mandas.docker.client.messages.ContainerCreation;
import org.mandas.docker.client.messages.ContainerExit;
import org.mandas.docker.client.messages.ContainerInfo;
import org.mandas.docker.client.messages.ContainerStats;
import org.mandas.docker.client.messages.ContainerUpdate;
import org.mandas.docker.client.messages.Distribution;
import org.mandas.docker.client.messages.ExecCreation;
import org.mandas.docker.client.messages.ExecState;
import org.mandas.docker.client.messages.HostConfig;
import org.mandas.docker.client.messages.Image;
import org.mandas.docker.client.messages.ImageHistory;
import org.mandas.docker.client.messages.ImageInfo;
import org.mandas.docker.client.messages.ImageSearchResult;
import org.mandas.docker.client.messages.Info;
import org.mandas.docker.client.messages.Network;
import org.mandas.docker.client.messages.NetworkConfig;
import org.mandas.docker.client.messages.NetworkConnection;
import org.mandas.docker.client.messages.NetworkCreation;
import org.mandas.docker.client.messages.ProgressMessage;
import org.mandas.docker.client.messages.RegistryAuth;
import org.mandas.docker.client.messages.RegistryConfigs;
import org.mandas.docker.client.messages.RemovedImage;
import org.mandas.docker.client.messages.ServiceCreateResponse;
import org.mandas.docker.client.messages.TopResults;
import org.mandas.docker.client.messages.Version;
import org.mandas.docker.client.messages.Volume;
import org.mandas.docker.client.messages.VolumeList;
import org.mandas.docker.client.messages.swarm.Config;
import org.mandas.docker.client.messages.swarm.ConfigCreateResponse;
import org.mandas.docker.client.messages.swarm.ConfigSpec;
import org.mandas.docker.client.messages.swarm.Node;
import org.mandas.docker.client.messages.swarm.NodeInfo;
import org.mandas.docker.client.messages.swarm.NodeSpec;
import org.mandas.docker.client.messages.swarm.Secret;
import org.mandas.docker.client.messages.swarm.SecretCreateResponse;
import org.mandas.docker.client.messages.swarm.SecretSpec;
import org.mandas.docker.client.messages.swarm.Service;
import org.mandas.docker.client.messages.swarm.ServiceSpec;
import org.mandas.docker.client.messages.swarm.Swarm;
import org.mandas.docker.client.messages.swarm.SwarmInit;
import org.mandas.docker.client.messages.swarm.SwarmJoin;
import org.mandas.docker.client.messages.swarm.SwarmSpec;
import org.mandas.docker.client.messages.swarm.Task;
import org.mandas.docker.client.messages.swarm.UnlockKey;
import org.mandas.docker.client.npipe.NpipeConnectionSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDockerClient
implements DockerClient,
Closeable {
    private static final String UNIX_SCHEME = "unix";
    private static final String NPIPE_SCHEME = "npipe";
    private static final Logger log = LoggerFactory.getLogger(DefaultDockerClient.class);
    static final long NO_TIMEOUT = 0L;
    private static final long DEFAULT_CONNECT_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(5L);
    private static final long DEFAULT_READ_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(30L);
    private static final int DEFAULT_CONNECTION_POOL_SIZE = 100;
    private final ClientConfig defaultConfig = new ClientConfig(new Class[]{ObjectMapperProvider.class, JacksonFeature.class, LogsResponseReader.class, ProgressResponseReader.class});
    private static final Pattern CONTAINER_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9][a-zA-Z0-9_.-]+$");
    private static final GenericType<List<Container>> CONTAINER_LIST = new GenericType<List<Container>>(){};
    private static final GenericType<List<ContainerChange>> CONTAINER_CHANGE_LIST = new GenericType<List<ContainerChange>>(){};
    private static final GenericType<List<Image>> IMAGE_LIST = new GenericType<List<Image>>(){};
    private static final GenericType<List<Network>> NETWORK_LIST = new GenericType<List<Network>>(){};
    private static final GenericType<List<ImageSearchResult>> IMAGES_SEARCH_RESULT_LIST = new GenericType<List<ImageSearchResult>>(){};
    private static final GenericType<List<RemovedImage>> REMOVED_IMAGE_LIST = new GenericType<List<RemovedImage>>(){};
    private static final GenericType<List<ImageHistory>> IMAGE_HISTORY_LIST = new GenericType<List<ImageHistory>>(){};
    private static final GenericType<List<Service>> SERVICE_LIST = new GenericType<List<Service>>(){};
    private static final GenericType<Distribution> DISTRIBUTION = new GenericType<Distribution>(){};
    private static final GenericType<List<Task>> TASK_LIST = new GenericType<List<Task>>(){};
    private static final GenericType<List<Node>> NODE_LIST = new GenericType<List<Node>>(){};
    private static final GenericType<List<Config>> CONFIG_LIST = new GenericType<List<Config>>(){};
    private static final GenericType<List<Secret>> SECRET_LIST = new GenericType<List<Secret>>(){};
    private final Client client;
    private final URI uri;
    private final String apiVersion;
    private final RegistryAuthSupplier registryAuthSupplier;
    private final Map<String, Object> headers;

    Client getClient() {
        return this.client;
    }

    public DefaultDockerClient(String uri) {
        this(URI.create(uri.replaceAll("^unix:///", "unix://localhost/")));
    }

    public DefaultDockerClient(URI uri) {
        this(new Builder().uri(uri));
    }

    public DefaultDockerClient(URI uri, DockerCertificatesStore dockerCertificatesStore) {
        this(new Builder().uri(uri).dockerCertificates(dockerCertificatesStore));
    }

    protected DefaultDockerClient(Builder builder) {
        Objects.requireNonNull(builder.uri, "uri");
        URI originalUri = builder.uri;
        Objects.requireNonNull(originalUri.getScheme(), "url has null scheme");
        this.apiVersion = builder.apiVersion();
        if (builder.dockerCertificatesStore != null && !originalUri.getScheme().equals("https")) {
            throw new IllegalArgumentException("An HTTPS URI for DOCKER_HOST must be provided to use Docker client certificates");
        }
        this.uri = originalUri.getScheme().equals(UNIX_SCHEME) ? UnixConnectionSocketFactory.sanitizeUri(originalUri) : (originalUri.getScheme().equals(NPIPE_SCHEME) ? NpipeConnectionSocketFactory.sanitizeUri(originalUri) : originalUri);
        HttpClientConnectionManager cm = this.getConnectionManager(builder);
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout((int)builder.connectTimeoutMillis).setConnectTimeout((int)builder.connectTimeoutMillis).setSocketTimeout((int)builder.readTimeoutMillis).build();
        ClientConfig config = this.updateProxy(this.defaultConfig, builder).connectorProvider((ConnectorProvider)new ApacheConnectorProvider()).property("jersey.config.apache.client.connectionManager", (Object)cm).property("jersey.config.apache.client.connectionManagerShared", (Object)"true").property("jersey.config.apache.client.requestConfig", (Object)requestConfig);
        this.registryAuthSupplier = builder.registryAuthSupplier == null ? new FixedRegistryAuthSupplier() : builder.registryAuthSupplier;
        if (builder.getRequestEntityProcessing() != null) {
            config.property("jersey.config.client.request.entity.processing", (Object)builder.requestEntityProcessing);
        }
        this.client = ClientBuilder.newBuilder().withConfig((Configuration)config).build();
        this.headers = new HashMap<String, Object>(builder.headers());
    }

    private ClientConfig updateProxy(ClientConfig config, Builder builder) {
        String proxyHost;
        if (builder.useProxy() && (proxyHost = System.getProperty("http.proxyHost")) != null) {
            boolean skipProxy = false;
            String nonProxyHosts = System.getProperty("http.nonProxyHosts");
            if (nonProxyHosts != null) {
                nonProxyHosts = StringUtils.strip((String)nonProxyHosts, (String)"\"");
                String host = this.getHost();
                for (String nonProxyHost : nonProxyHosts.split("\\|")) {
                    if (!host.matches(this.toRegExp(nonProxyHost))) continue;
                    skipProxy = true;
                    break;
                }
            }
            if (!skipProxy) {
                String proxyPassword;
                String proxyPort = System.getProperty("http.proxyPort");
                Objects.requireNonNull(proxyPort, "http.proxyPort");
                config.property("jersey.config.client.proxy.uri", (Object)((!proxyHost.startsWith("http") ? "http://" : "") + proxyHost + ":" + proxyPort));
                String proxyUser = System.getProperty("http.proxyUser");
                if (proxyUser != null) {
                    config.property("jersey.config.client.proxy.username", (Object)proxyUser);
                }
                if ((proxyPassword = System.getProperty("http.proxyPassword")) != null) {
                    config.property("jersey.config.client.proxy.password", (Object)proxyPassword);
                }
                config.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.BUFFERED);
            }
        }
        return config;
    }

    private String toRegExp(String hostnameWithWildcards) {
        return hostnameWithWildcards.replace(".", "\\.").replace("*", ".*");
    }

    @Override
    public String getHost() {
        return Optional.ofNullable(this.uri.getHost()).orElse("localhost");
    }

    private HttpClientConnectionManager getConnectionManager(Builder builder) {
        if (builder.uri.getScheme().equals(NPIPE_SCHEME)) {
            BasicHttpClientConnectionManager bm = new BasicHttpClientConnectionManager(this.getSchemeRegistry(builder));
            return bm;
        }
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(this.getSchemeRegistry(builder));
        cm.setMaxTotal(builder.connectionPoolSize);
        cm.setDefaultMaxPerRoute(cm.getMaxTotal());
        return cm;
    }

    private Registry<ConnectionSocketFactory> getSchemeRegistry(Builder builder) {
        SSLConnectionSocketFactory https = builder.dockerCertificatesStore == null ? SSLConnectionSocketFactory.getSocketFactory() : new SSLConnectionSocketFactory(builder.dockerCertificatesStore.sslContext(), builder.dockerCertificatesStore.hostnameVerifier());
        RegistryBuilder registryBuilder = RegistryBuilder.create().register("https", (Object)https).register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        if (builder.uri.getScheme().equals(UNIX_SCHEME)) {
            registryBuilder.register(UNIX_SCHEME, (Object)new UnixConnectionSocketFactory(builder.uri));
        }
        if (builder.uri.getScheme().equals(NPIPE_SCHEME)) {
            registryBuilder.register(NPIPE_SCHEME, (Object)new NpipeConnectionSocketFactory(builder.uri));
        }
        return registryBuilder.build();
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public String ping() throws DockerException, InterruptedException {
        WebTarget resource = this.client.target(this.uri).path("_ping");
        return this.request("GET", String.class, resource, resource.request());
    }

    @Override
    public Version version() throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("version");
        return this.request("GET", Version.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
    }

    @Override
    public int auth(RegistryAuth registryAuth) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("auth");
        Response response = this.request("POST", Response.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}), Entity.json((Object)registryAuth));
        return response.getStatus();
    }

    @Override
    public Info info() throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("info");
        return this.request("GET", Info.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
    }

    @Override
    public List<Container> listContainers(DockerClient.ListContainersParam ... params) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("containers").path("json");
        resource = this.addParameters(resource, params);
        try {
            return this.request("GET", CONTAINER_LIST, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 400: {
                    throw new BadParamException(this.getQueryParamMap(resource), (Throwable)e);
                }
            }
            throw e;
        }
    }

    private WebTarget addParameters(WebTarget resource, DockerClient.Param ... params) throws DockerException {
        HashMap<String, List<String>> filters = new HashMap<String, List<String>>();
        for (DockerClient.Param param : params) {
            if (param instanceof DockerClient.FilterParam) {
                List<String> filterValueList = filters.containsKey(param.name()) ? (List)filters.get(param.name()) : new ArrayList<String>();
                filterValueList.add(param.value());
                filters.put(param.name(), filterValueList);
                continue;
            }
            resource = resource.queryParam(this.urlEncode(param.name()), new Object[]{this.urlEncode(param.value())});
        }
        if (!filters.isEmpty()) {
            resource = resource.queryParam("filters", new Object[]{this.urlEncodeFilters(filters)});
        }
        return resource;
    }

    private Map<String, String> getQueryParamMap(WebTarget resource) {
        String queryParams = resource.getUri().getQuery();
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        if (queryParams != null) {
            for (String queryParam : queryParams.split("&")) {
                String[] kv = queryParam.split("=");
                paramsMap.put(kv[0], kv[1]);
            }
        }
        return paramsMap;
    }

    private String urlEncode(String unencoded) throws DockerException {
        try {
            String encode = URLEncoder.encode(unencoded, StandardCharsets.UTF_8.name());
            return encode.replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new DockerException(e);
        }
    }

    private String urlEncodeFilters(Map<String, List<String>> filters) throws DockerException {
        try {
            String unencodedFilters = ObjectMapperProvider.objectMapper().writeValueAsString(filters);
            if (!unencodedFilters.isEmpty()) {
                return this.urlEncode(unencodedFilters);
            }
        }
        catch (IOException e) {
            throw new DockerException(e);
        }
        return null;
    }

    @Override
    public List<Image> listImages(DockerClient.ListImagesParam ... params) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("images").path("json");
        resource = this.addParameters(resource, params);
        return this.request("GET", IMAGE_LIST, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
    }

    @Override
    public ContainerCreation createContainer(ContainerConfig config) throws DockerException, InterruptedException {
        return this.createContainer(config, null);
    }

    @Override
    public ContainerCreation createContainer(ContainerConfig config, String name) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("containers").path("create");
        if (name != null) {
            if (!CONTAINER_NAME_PATTERN.matcher(name).matches()) {
                throw new IllegalArgumentException(String.format("Invalid container name: \"%s\"", name));
            }
            resource = resource.queryParam("name", new Object[]{name});
        }
        log.debug("Creating container with ContainerConfig: {}", (Object)config);
        try {
            return this.request("POST", ContainerCreation.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}), Entity.json((Object)config));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ImageNotFoundException(config.image(), e);
                }
                case 406: {
                    throw new DockerException("Impossible to attach. Container not running.", e);
                }
            }
            throw e;
        }
    }

    @Override
    public void startContainer(String containerId) throws DockerException, InterruptedException {
        Objects.requireNonNull(containerId, "containerId");
        log.info("Starting container with Id: {}", (Object)containerId);
        this.containerAction(containerId, "start");
    }

    private void containerAction(String containerId, String action) throws DockerException, InterruptedException {
        this.containerAction(containerId, action, (MultivaluedMap<String, String>)new MultivaluedHashMap());
    }

    private void containerAction(String containerId, String action, MultivaluedMap<String, String> queryParameters) throws DockerException, InterruptedException {
        try {
            WebTarget resource = this.resource().path("containers").path(containerId).path(action);
            for (Map.Entry queryParameter : queryParameters.entrySet()) {
                for (String parameterValue : (List)queryParameter.getValue()) {
                    resource = resource.queryParam((String)queryParameter.getKey(), new Object[]{parameterValue});
                }
            }
            this.request("POST", resource, resource.request());
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public void pauseContainer(String containerId) throws DockerException, InterruptedException {
        Objects.requireNonNull(containerId, "containerId");
        this.containerAction(containerId, "pause");
    }

    @Override
    public void unpauseContainer(String containerId) throws DockerException, InterruptedException {
        Objects.requireNonNull(containerId, "containerId");
        this.containerAction(containerId, "unpause");
    }

    @Override
    public void restartContainer(String containerId) throws DockerException, InterruptedException {
        this.restartContainer(containerId, 10);
    }

    @Override
    public void restartContainer(String containerId, int secondsToWaitBeforeRestart) throws DockerException, InterruptedException {
        Objects.requireNonNull(containerId, "containerId");
        Objects.requireNonNull(Integer.valueOf(secondsToWaitBeforeRestart), "secondsToWait");
        MultivaluedHashMap queryParameters = new MultivaluedHashMap();
        queryParameters.add((Object)"t", (Object)String.valueOf(secondsToWaitBeforeRestart));
        this.containerAction(containerId, "restart", (MultivaluedMap<String, String>)queryParameters);
    }

    @Override
    public void killContainer(String containerId) throws DockerException, InterruptedException {
        Objects.requireNonNull(containerId, "containerId");
        this.containerAction(containerId, "kill");
    }

    @Override
    public void killContainer(String containerId, DockerClient.Signal signal) throws DockerException, InterruptedException {
        Objects.requireNonNull(containerId, "containerId");
        MultivaluedHashMap queryParameters = new MultivaluedHashMap();
        queryParameters.add((Object)"signal", (Object)signal.getName());
        this.containerAction(containerId, "kill", (MultivaluedMap<String, String>)queryParameters);
    }

    @Override
    public Distribution getDistribution(String imageName) throws DockerException, InterruptedException {
        Objects.requireNonNull(imageName, "containerName");
        WebTarget resource = this.resource().path("distribution").path(imageName).path("json");
        return this.request("GET", DISTRIBUTION, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
    }

    @Override
    public void stopContainer(String containerId, int secondsToWaitBeforeKilling) throws DockerException, InterruptedException {
        try {
            WebTarget resource = ((WebTarget)this.resource().property("jersey.config.client.readTimeout", (Object)0)).path("containers").path(containerId).path("stop").queryParam("t", new Object[]{String.valueOf(secondsToWaitBeforeKilling)});
            this.request("POST", resource, resource.request());
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 304: {
                    return;
                }
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public ContainerExit waitContainer(String containerId) throws DockerException, InterruptedException {
        try {
            WebTarget resource = ((WebTarget)this.resource().property("jersey.config.client.readTimeout", (Object)0)).path("containers").path(containerId).path("wait");
            return this.request("POST", ContainerExit.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public void removeContainer(String containerId) throws DockerException, InterruptedException {
        this.removeContainer(containerId, new DockerClient.RemoveContainerParam[0]);
    }

    @Override
    public void removeContainer(String containerId, DockerClient.RemoveContainerParam ... params) throws DockerException, InterruptedException {
        try {
            WebTarget resource = this.resource().path("containers").path(containerId);
            for (DockerClient.RemoveContainerParam param : params) {
                resource = resource.queryParam(param.name(), new Object[]{param.value()});
            }
            this.request("DELETE", resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 400: {
                    throw new BadParamException(this.getQueryParamMap(this.resource()), (Throwable)e);
                }
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public InputStream exportContainer(String containerId) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("containers").path(containerId).path("export");
        try {
            return this.request("GET", InputStream.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public InputStream archiveContainer(String containerId, String path) throws DockerException, InterruptedException {
        String apiVersion = this.version().apiVersion();
        int versionComparison = VersionCompare.compareVersion(apiVersion, "1.20");
        if (versionComparison < 0) {
            throw new UnsupportedApiVersionException(apiVersion);
        }
        WebTarget resource = this.resource().path("containers").path(containerId).path("archive").queryParam("path", new Object[]{path});
        try {
            return this.request("GET", InputStream.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public TopResults topContainer(String containerId) throws DockerException, InterruptedException {
        return this.topContainer(containerId, null);
    }

    @Override
    public TopResults topContainer(String containerId, String psArgs) throws DockerException, InterruptedException {
        try {
            WebTarget resource = this.resource().path("containers").path(containerId).path("top");
            if (psArgs != null && !"".equals(psArgs.trim())) {
                resource = resource.queryParam("ps_args", new Object[]{psArgs});
            }
            return this.request("GET", TopResults.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public void copyToContainer(Path directory, String containerId, String path) throws DockerException, InterruptedException, IOException {
        try (CompressedDirectory compressedDirectory = CompressedDirectory.create(directory);
             InputStream fileStream = Files.newInputStream(compressedDirectory.file(), new OpenOption[0]);){
            this.copyToContainer(fileStream, containerId, path);
        }
    }

    @Override
    public void copyToContainer(InputStream tarStream, String containerId, String path) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("containers").path(containerId).path("archive").queryParam("noOverwriteDirNonDir", new Object[]{true}).queryParam("path", new Object[]{path});
        try {
            this.request("PUT", String.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}), Entity.entity((Object)tarStream, (String)"application/tar"));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 400: {
                    throw new BadParamException(this.getQueryParamMap(resource), (Throwable)e);
                }
                case 403: {
                    throw new PermissionException("Volume or container rootfs is marked as read-only.", e);
                }
                case 404: {
                    throw new NotFoundException(String.format("Either container %s or path %s not found.", containerId, path), e);
                }
            }
            throw e;
        }
    }

    @Override
    public List<ContainerChange> inspectContainerChanges(String containerId) throws DockerException, InterruptedException {
        try {
            WebTarget resource = this.resource().path("containers").path(containerId).path("changes");
            return this.request("GET", CONTAINER_CHANGE_LIST, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public ContainerInfo inspectContainer(String containerId) throws DockerException, InterruptedException {
        try {
            WebTarget resource = this.resource().path("containers").path(containerId).path("json");
            return this.request("GET", ContainerInfo.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public ContainerCreation commitContainer(String containerId, String repo, String tag, ContainerConfig config, String comment, String author) throws DockerException, InterruptedException {
        Objects.requireNonNull(containerId, "containerId");
        Objects.requireNonNull(repo, "repo");
        Objects.requireNonNull(config, "containerConfig");
        WebTarget resource = this.resource().path("commit").queryParam("container", new Object[]{containerId}).queryParam("repo", new Object[]{repo});
        if (author != null && !"".equals(author.trim())) {
            resource = resource.queryParam("author", new Object[]{author});
        }
        if (comment != null && !"".equals(comment.trim())) {
            resource = resource.queryParam("comment", new Object[]{comment});
        }
        if (tag != null && !"".equals(tag.trim())) {
            resource = resource.queryParam("tag", new Object[]{tag});
        }
        log.debug("Committing container id: {} to repository: {} with ContainerConfig: {}", new Object[]{containerId, repo, config});
        try {
            return this.request("POST", ContainerCreation.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}), Entity.json((Object)config));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public void renameContainer(String containerId, String name) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("containers").path(containerId).path("rename");
        if (name == null) {
            throw new IllegalArgumentException("Cannot rename container to null");
        }
        if (!CONTAINER_NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException(String.format("Invalid container name: \"%s\"", name));
        }
        resource = resource.queryParam("name", new Object[]{name});
        log.info("Renaming container with id {}. New name {}.", (Object)containerId, (Object)name);
        try {
            this.request("POST", resource, resource.request());
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
                case 409: {
                    throw new ContainerRenameConflictException(containerId, name, e);
                }
            }
            throw e;
        }
    }

    @Override
    public ContainerUpdate updateContainer(String containerId, HostConfig config) throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.22");
        try {
            WebTarget resource = this.resource().path("containers").path(containerId).path("update");
            return this.request("POST", ContainerUpdate.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}), Entity.json((Object)config));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId);
                }
            }
            throw e;
        }
    }

    @Override
    public List<ImageSearchResult> searchImages(String term) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("images").path("search").queryParam("term", new Object[]{term});
        return this.request("GET", IMAGES_SEARCH_RESULT_LIST, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
    }

    @Override
    public Set<String> load(InputStream imagePayload) throws DockerException, InterruptedException {
        return this.load(imagePayload, new LoggingLoadHandler());
    }

    @Override
    public Set<String> load(InputStream imagePayload, ProgressHandler handler) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("images").path("load").queryParam("quiet", new Object[]{"false"});
        LoadProgressHandler loadProgressHandler = new LoadProgressHandler(handler);
        Entity entity = Entity.entity((Object)imagePayload, (String)"application/octet-stream");
        try {
            Set set;
            block11: {
                ProgressStream load = this.request("POST", ProgressStream.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}), entity);
                try {
                    load.tail(loadProgressHandler, "POST", resource.getUri());
                    set = loadProgressHandler.getImageNames();
                    if (load == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (load != null) {
                            try {
                                load.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new DockerException(e);
                    }
                }
                load.close();
            }
            return set;
        }
        finally {
            IOUtils.closeQuietly((Closeable)imagePayload);
        }
    }

    @Override
    public void create(String image, InputStream imagePayload) throws DockerException, InterruptedException {
        this.create(image, imagePayload, new LoggingPullHandler("image stream"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(String image, InputStream imagePayload, ProgressHandler handler) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("images").path("create");
        resource = resource.queryParam("fromSrc", new Object[]{"-"}).queryParam("tag", new Object[]{image});
        CreateProgressHandler createProgressHandler = new CreateProgressHandler(handler);
        Entity entity = Entity.entity((Object)imagePayload, (String)"application/octet-stream");
        try {
            this.requestAndTail("POST", createProgressHandler, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}), entity);
            this.tag(createProgressHandler.getImageId(), image, true);
        }
        finally {
            IOUtils.closeQuietly((Closeable)imagePayload);
        }
    }

    @Override
    public InputStream save(String ... images) throws DockerException, IOException, InterruptedException {
        WebTarget resource;
        if (images.length == 1) {
            resource = this.resource().path("images").path(images[0]).path("get");
        } else {
            resource = this.resource().path("images").path("get");
            if (images.length > 1) {
                for (String image : images) {
                    if (image == null || "".equals(image.trim())) continue;
                    resource = resource.queryParam("names", new Object[]{this.urlEncode(image)});
                }
            }
        }
        return this.request("GET", InputStream.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
    }

    @Override
    public InputStream saveMultiple(String ... images) throws DockerException, IOException, InterruptedException {
        WebTarget resource = this.resource().path("images").path("get");
        for (String image : images) {
            resource.queryParam("names", new Object[]{this.urlEncode(image)});
        }
        return this.request("GET", InputStream.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("X-Registry-Auth", (Object)this.authHeader(this.registryAuthSupplier.authFor(images[0]))));
    }

    @Override
    public void pull(String image) throws DockerException, InterruptedException {
        this.pull(image, new LoggingPullHandler(image));
    }

    @Override
    public void pull(String image, ProgressHandler handler) throws DockerException, InterruptedException {
        this.pull(image, this.registryAuthSupplier.authFor(image), handler);
    }

    @Override
    public void pull(String image, RegistryAuth registryAuth) throws DockerException, InterruptedException {
        this.pull(image, registryAuth, new LoggingPullHandler(image));
    }

    @Override
    public void pull(String image, RegistryAuth registryAuth, ProgressHandler handler) throws DockerException, InterruptedException {
        ImageRef imageRef = new ImageRef(image);
        WebTarget resource = this.resource().path("images").path("create");
        resource = resource.queryParam("fromImage", new Object[]{imageRef.getImage()});
        if (imageRef.getTag() != null) {
            resource = resource.queryParam("tag", new Object[]{imageRef.getTag()});
        }
        try {
            this.requestAndTail("POST", handler, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("X-Registry-Auth", (Object)this.authHeader(registryAuth)));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ImageNotFoundException(image, e);
                }
            }
            throw e;
        }
    }

    @Override
    public void push(String image) throws DockerException, InterruptedException {
        this.push(image, new LoggingPushHandler(image));
    }

    @Override
    public void push(String image, RegistryAuth registryAuth) throws DockerException, InterruptedException {
        this.push(image, new LoggingPushHandler(image), registryAuth);
    }

    @Override
    public void push(String image, ProgressHandler handler) throws DockerException, InterruptedException {
        this.push(image, handler, this.registryAuthSupplier.authFor(image));
    }

    @Override
    public void push(String image, ProgressHandler handler, RegistryAuth registryAuth) throws DockerException, InterruptedException {
        ImageRef imageRef = new ImageRef(image);
        WebTarget resource = this.resource().path("images").path(imageRef.getImage()).path("push");
        if (imageRef.getTag() != null) {
            resource = resource.queryParam("tag", new Object[]{imageRef.getTag()});
        }
        try {
            this.requestAndTail("POST", handler, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("X-Registry-Auth", (Object)this.authHeader(registryAuth)));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ImageNotFoundException(image, e);
                }
            }
            throw e;
        }
    }

    @Override
    public void tag(String image, String name) throws DockerException, InterruptedException {
        this.tag(image, name, false);
    }

    @Override
    public void tag(String image, String name, boolean force) throws DockerException, InterruptedException {
        ImageRef imageRef = new ImageRef(name);
        WebTarget resource = this.resource().path("images").path(image).path("tag");
        resource = resource.queryParam("repo", new Object[]{imageRef.getImage()});
        if (imageRef.getTag() != null) {
            resource = resource.queryParam("tag", new Object[]{imageRef.getTag()});
        }
        if (force) {
            resource = resource.queryParam("force", new Object[]{true});
        }
        try {
            this.request("POST", resource, resource.request());
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 400: {
                    throw new BadParamException(this.getQueryParamMap(resource), (Throwable)e);
                }
                case 404: {
                    throw new ImageNotFoundException(image, e);
                }
                case 409: {
                    throw new ConflictException(e);
                }
            }
            throw e;
        }
    }

    @Override
    public String build(Path directory, DockerClient.BuildParam ... params) throws DockerException, InterruptedException, IOException {
        return this.build(directory, null, new LoggingBuildHandler(), params);
    }

    @Override
    public String build(Path directory, String name, DockerClient.BuildParam ... params) throws DockerException, InterruptedException, IOException {
        return this.build(directory, name, new LoggingBuildHandler(), params);
    }

    @Override
    public String build(Path directory, ProgressHandler handler, DockerClient.BuildParam ... params) throws DockerException, InterruptedException, IOException {
        return this.build(directory, null, handler, params);
    }

    @Override
    public String build(Path directory, String name, ProgressHandler handler, DockerClient.BuildParam ... params) throws DockerException, InterruptedException, IOException {
        return this.build(directory, name, null, handler, params);
    }

    @Override
    public String build(Path directory, String name, String dockerfile, ProgressHandler handler, DockerClient.BuildParam ... params) throws DockerException, InterruptedException, IOException {
        Objects.requireNonNull(handler, "handler");
        WebTarget resource = ((WebTarget)this.resource().property("jersey.config.client.readTimeout", (Object)0)).path("build");
        for (DockerClient.BuildParam param : params) {
            resource = resource.queryParam(param.name(), new Object[]{param.value()});
        }
        if (name != null) {
            resource = resource.queryParam("t", new Object[]{name});
        }
        if (dockerfile != null) {
            resource = resource.queryParam("dockerfile", new Object[]{dockerfile});
        }
        RegistryConfigs registryConfigs = this.registryAuthSupplier.authForBuild();
        BuildProgressHandler buildHandler = new BuildProgressHandler(handler);
        try (CompressedDirectory compressedDirectory = CompressedDirectory.create(directory);){
            String string;
            block15: {
                InputStream fileStream = Files.newInputStream(compressedDirectory.file(), new OpenOption[0]);
                try {
                    this.requestAndTail("POST", buildHandler, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("X-Registry-Config", (Object)this.authRegistryHeader(registryConfigs)), Entity.entity((Object)fileStream, (String)"application/tar"));
                    string = buildHandler.getImageId();
                    if (fileStream == null) break block15;
                }
                catch (Throwable throwable) {
                    if (fileStream != null) {
                        try {
                            fileStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                fileStream.close();
            }
            return string;
        }
    }

    @Override
    public ImageInfo inspectImage(String image) throws DockerException, InterruptedException {
        try {
            WebTarget resource = this.resource().path("images").path(image).path("json");
            return this.request("GET", ImageInfo.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ImageNotFoundException(image, e);
                }
            }
            throw e;
        }
    }

    @Override
    public List<RemovedImage> removeImage(String image) throws DockerException, InterruptedException {
        return this.removeImage(image, false, false);
    }

    @Override
    public List<RemovedImage> removeImage(String image, boolean force, boolean noPrune) throws DockerException, InterruptedException {
        try {
            WebTarget resource = this.resource().path("images").path(image).queryParam("force", new Object[]{String.valueOf(force)}).queryParam("noprune", new Object[]{String.valueOf(noPrune)});
            return this.request("DELETE", REMOVED_IMAGE_LIST, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ImageNotFoundException(image, e);
                }
                case 409: {
                    throw new ConflictException(e);
                }
            }
            throw e;
        }
    }

    @Override
    public List<ImageHistory> history(String image) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("images").path(image).path("history");
        try {
            return this.request("GET", IMAGE_HISTORY_LIST, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ImageNotFoundException(image, e);
                }
            }
            throw e;
        }
    }

    @Override
    public LogStream logs(String containerId, DockerClient.LogsParam ... params) throws DockerException, InterruptedException {
        WebTarget resource = ((WebTarget)this.resource().property("jersey.config.client.readTimeout", (Object)0)).path("containers").path(containerId).path("logs");
        for (DockerClient.LogsParam param : params) {
            resource = resource.queryParam(param.name(), new Object[]{param.value()});
        }
        return this.getLogStream("GET", resource, containerId);
    }

    @Override
    public EventStream events(DockerClient.EventsParam ... params) throws DockerException, InterruptedException {
        WebTarget resource = ((WebTarget)this.resource().property("jersey.config.client.readTimeout", (Object)0)).path("events");
        resource = this.addParameters(resource, params);
        try {
            CloseableHttpClient client = (CloseableHttpClient)ApacheConnectorProvider.getHttpClient((Configurable)this.client);
            CloseableHttpResponse response = client.execute((HttpUriRequest)new HttpGet(resource.getUri()));
            return new EventStream(response, ObjectMapperProvider.objectMapper());
        }
        catch (IOException exception) {
            throw new DockerException(exception);
        }
    }

    @Override
    public LogStream attachContainer(String containerId, DockerClient.AttachParameter ... params) throws DockerException, InterruptedException {
        Objects.requireNonNull(containerId, "containerId");
        WebTarget resource = ((WebTarget)this.resource().property("jersey.config.client.readTimeout", (Object)0)).path("containers").path(containerId).path("attach");
        for (DockerClient.AttachParameter param : params) {
            resource = resource.queryParam(param.name().toLowerCase(Locale.ROOT), new Object[]{String.valueOf(true)});
        }
        return this.getLogStream("POST", resource, containerId);
    }

    private LogStream getLogStream(String method, WebTarget resource, String containerId) throws DockerException, InterruptedException {
        try {
            Invocation.Builder request = resource.request(new String[]{"application/vnd.docker.raw-stream"});
            return this.request(method, LogStream.class, resource, request);
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 400: {
                    throw new BadParamException(this.getQueryParamMap(resource), (Throwable)e);
                }
                case 404: {
                    throw new ContainerNotFoundException(containerId);
                }
            }
            throw e;
        }
    }

    private LogStream getServiceLogStream(String method, WebTarget resource, String serviceId) throws DockerException, InterruptedException {
        try {
            Invocation.Builder request = resource.request(new String[]{"application/vnd.docker.raw-stream"});
            return this.request(method, LogStream.class, resource, request);
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 400: {
                    throw new BadParamException(this.getQueryParamMap(resource), (Throwable)e);
                }
                case 404: {
                    throw new ServiceNotFoundException(serviceId);
                }
            }
            throw e;
        }
    }

    @Override
    public ExecCreation execCreate(String containerId, String[] cmd, DockerClient.ExecCreateParam ... params) throws DockerException, InterruptedException {
        ContainerInfo containerInfo = this.inspectContainer(containerId);
        if (!containerInfo.state().running()) {
            throw new IllegalStateException("Container " + containerId + " is not running.");
        }
        WebTarget resource = this.resource().path("containers").path(containerId).path("exec");
        StringWriter writer = new StringWriter();
        try (JsonGenerator generator = ObjectMapperProvider.objectMapper().getFactory().createGenerator((Writer)writer);){
            generator.writeStartObject();
            for (DockerClient.ExecCreateParam param : params) {
                if (param.value().equals("true") || param.value().equals("false")) {
                    generator.writeBooleanField(param.name(), Boolean.valueOf(param.value()).booleanValue());
                    continue;
                }
                generator.writeStringField(param.name(), param.value());
            }
            generator.writeArrayFieldStart("Cmd");
            for (String s : cmd) {
                generator.writeString(s);
            }
            generator.writeEndArray();
            generator.writeEndObject();
        }
        catch (IOException e) {
            throw new DockerException(e);
        }
        try {
            return this.request("POST", ExecCreation.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}), Entity.json((Object)writer.toString()));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
                case 409: {
                    throw new ExecCreateConflictException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public LogStream execStart(String execId, DockerClient.ExecStartParameter ... params) throws DockerException, InterruptedException {
        WebTarget resource = ((WebTarget)this.resource().property("jersey.config.client.readTimeout", (Object)0)).path("exec").path(execId).path("start");
        StringWriter writer = new StringWriter();
        try (JsonGenerator generator = ObjectMapperProvider.objectMapper().getFactory().createGenerator((Writer)writer);){
            generator.writeStartObject();
            for (DockerClient.ExecStartParameter param : params) {
                generator.writeBooleanField(param.getName(), true);
            }
            generator.writeEndObject();
        }
        catch (IOException e) {
            throw new DockerException(e);
        }
        try {
            return this.request("POST", LogStream.class, resource, resource.request(new String[]{"application/vnd.docker.raw-stream"}), Entity.json((Object)writer.toString()));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ExecNotFoundException(execId, e);
                }
                case 409: {
                    throw new ExecStartConflictException(execId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public Swarm inspectSwarm() throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.24");
        WebTarget resource = this.resource().path("swarm");
        return this.request("GET", Swarm.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
    }

    @Override
    public String initSwarm(SwarmInit swarmInit) throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.24");
        try {
            WebTarget resource = this.resource().path("swarm").path("init");
            return this.request("POST", String.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}), Entity.json((Object)swarmInit));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 400: {
                    throw new DockerException("bad parameter", e);
                }
                case 500: {
                    throw new DockerException("server error", e);
                }
                case 503: {
                    throw new DockerException("node is already part of a swarm", e);
                }
            }
            throw e;
        }
    }

    @Override
    public void joinSwarm(SwarmJoin swarmJoin) throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.24");
        try {
            WebTarget resource = this.resource().path("swarm").path("join");
            this.request("POST", String.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}), Entity.json((Object)swarmJoin));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 400: {
                    throw new DockerException("bad parameter", e);
                }
                case 500: {
                    throw new DockerException("server error", e);
                }
                case 503: {
                    throw new DockerException("node is already part of a swarm", e);
                }
            }
            throw e;
        }
    }

    @Override
    public void leaveSwarm() throws DockerException, InterruptedException {
        this.leaveSwarm(false);
    }

    @Override
    public void leaveSwarm(boolean force) throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.24");
        try {
            WebTarget resource = this.resource().path("swarm").path("leave").queryParam("force", new Object[]{force});
            this.request("POST", String.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 500: {
                    throw new DockerException("server error", e);
                }
                case 503: {
                    throw new DockerException("node is not part of a swarm", e);
                }
            }
            throw e;
        }
    }

    @Override
    public void updateSwarm(Long version, boolean rotateWorkerToken, boolean rotateManagerToken, boolean rotateManagerUnlockKey, SwarmSpec spec) throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.24");
        try {
            WebTarget resource = this.resource().path("swarm").path("update").queryParam("version", new Object[]{version}).queryParam("rotateWorkerToken", new Object[]{rotateWorkerToken}).queryParam("rotateManagerToken", new Object[]{rotateManagerToken}).queryParam("rotateManagerUnlockKey", new Object[]{rotateManagerUnlockKey});
            this.request("POST", String.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}), Entity.json((Object)spec));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 400: {
                    throw new DockerException("bad parameter", e);
                }
            }
            throw e;
        }
    }

    @Override
    public void updateSwarm(Long version, boolean rotateWorkerToken, boolean rotateManagerToken, SwarmSpec spec) throws DockerException, InterruptedException {
        this.updateSwarm(version, rotateWorkerToken, rotateWorkerToken, false, spec);
    }

    @Override
    public void updateSwarm(Long version, boolean rotateWorkerToken, SwarmSpec spec) throws DockerException, InterruptedException {
        this.updateSwarm(version, rotateWorkerToken, false, false, spec);
    }

    @Override
    public void updateSwarm(Long version, SwarmSpec spec) throws DockerException, InterruptedException {
        this.updateSwarm(version, false, false, false, spec);
    }

    @Override
    public UnlockKey unlockKey() throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.24");
        try {
            WebTarget resource = this.resource().path("swarm").path("unlockkey");
            return this.request("GET", UnlockKey.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 500: {
                    throw new DockerException("server error", e);
                }
                case 503: {
                    throw new DockerException("node is not part of a swarm", e);
                }
            }
            throw e;
        }
    }

    @Override
    public void unlock(UnlockKey unlockKey) throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.24");
        try {
            WebTarget resource = this.resource().path("swarm").path("unlock");
            this.request("POST", String.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}), Entity.json((Object)unlockKey));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 500: {
                    throw new DockerException("server error", e);
                }
                case 503: {
                    throw new DockerException("node is not part of a swarm", e);
                }
            }
            throw e;
        }
    }

    @Override
    public ServiceCreateResponse createService(ServiceSpec spec) throws DockerException, InterruptedException {
        return this.createService(spec, this.registryAuthSupplier.authForSwarm());
    }

    @Override
    public ServiceCreateResponse createService(ServiceSpec spec, RegistryAuth config) throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.24");
        WebTarget resource = this.resource().path("services").path("create");
        try {
            return this.request("POST", ServiceCreateResponse.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("X-Registry-Auth", (Object)this.authHeader(config)), Entity.json((Object)spec));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 406: {
                    throw new DockerException("Server error or node is not part of swarm.", e);
                }
                case 409: {
                    throw new DockerException("Name conflicts with an existing object.", e);
                }
            }
            throw e;
        }
    }

    @Override
    public Service inspectService(String serviceId) throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.24");
        try {
            WebTarget resource = this.resource().path("services").path(serviceId);
            return this.request("GET", Service.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ServiceNotFoundException(serviceId);
                }
            }
            throw e;
        }
    }

    @Override
    public void updateService(String serviceId, Long version, ServiceSpec spec) throws DockerException, InterruptedException {
        this.updateService(serviceId, version, spec, this.registryAuthSupplier.authForSwarm());
    }

    @Override
    public void updateService(String serviceId, Long version, ServiceSpec spec, RegistryAuth config) throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.24");
        try {
            WebTarget resource = this.resource().path("services").path(serviceId).path("update");
            resource = resource.queryParam("version", new Object[]{version});
            this.request("POST", String.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("X-Registry-Auth", (Object)this.authHeader(config)), Entity.json((Object)spec));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ServiceNotFoundException(serviceId);
                }
            }
            throw e;
        }
    }

    @Override
    public List<Service> listServices() throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.24");
        WebTarget resource = this.resource().path("services");
        return this.request("GET", SERVICE_LIST, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
    }

    @Override
    public List<Service> listServices(Service.Criteria criteria) throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.24");
        HashMap<String, List<String>> filters = new HashMap<String, List<String>>();
        if (criteria.serviceId() != null) {
            filters.put("id", Collections.singletonList(criteria.serviceId()));
        }
        if (criteria.serviceName() != null) {
            filters.put("name", Collections.singletonList(criteria.serviceName()));
        }
        ArrayList<String> labels = new ArrayList<String>();
        for (Map.Entry<String, String> input : criteria.labels().entrySet()) {
            if ("".equals(input.getValue())) {
                labels.add(input.getKey());
                continue;
            }
            labels.add(String.format("%s=%s", input.getKey(), input.getValue()));
        }
        if (!labels.isEmpty()) {
            filters.put("label", labels);
        }
        WebTarget resource = this.resource().path("services");
        resource = resource.queryParam("filters", new Object[]{this.urlEncodeFilters(filters)});
        return this.request("GET", SERVICE_LIST, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
    }

    @Override
    public void removeService(String serviceId) throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.24");
        try {
            WebTarget resource = this.resource().path("services").path(serviceId);
            this.request("DELETE", resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ServiceNotFoundException(serviceId);
                }
            }
            throw e;
        }
    }

    @Override
    public LogStream serviceLogs(String serviceId, DockerClient.LogsParam ... params) throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.25");
        WebTarget resource = ((WebTarget)this.resource().property("jersey.config.client.readTimeout", (Object)0)).path("services").path(serviceId).path("logs");
        for (DockerClient.LogsParam param : params) {
            resource = resource.queryParam(param.name(), new Object[]{param.value()});
        }
        return this.getServiceLogStream("GET", resource, serviceId);
    }

    @Override
    public Task inspectTask(String taskId) throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.24");
        try {
            WebTarget resource = this.resource().path("tasks").path(taskId);
            return this.request("GET", Task.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new TaskNotFoundException(taskId);
                }
            }
            throw e;
        }
    }

    @Override
    public List<Task> listTasks() throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.24");
        WebTarget resource = this.resource().path("tasks");
        return this.request("GET", TASK_LIST, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
    }

    @Override
    public List<Task> listTasks(Task.Criteria criteria) throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.24");
        HashMap<String, List<String>> filters = new HashMap<String, List<String>>();
        if (criteria.taskId() != null) {
            filters.put("id", Collections.singletonList(criteria.taskId()));
        }
        if (criteria.taskName() != null) {
            filters.put("name", Collections.singletonList(criteria.taskName()));
        }
        if (criteria.serviceName() != null) {
            filters.put("service", Collections.singletonList(criteria.serviceName()));
        }
        if (criteria.nodeId() != null) {
            filters.put("node", Collections.singletonList(criteria.nodeId()));
        }
        if (criteria.label() != null) {
            filters.put("label", Collections.singletonList(criteria.label()));
        }
        if (criteria.desiredState() != null) {
            filters.put("desired-state", Collections.singletonList(criteria.desiredState()));
        }
        WebTarget resource = this.resource().path("tasks");
        resource = resource.queryParam("filters", new Object[]{this.urlEncodeFilters(filters)});
        return this.request("GET", TASK_LIST, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
    }

    @Override
    public List<Config> listConfigs() throws DockerException, InterruptedException {
        return this.listConfigs(null);
    }

    @Override
    public List<Config> listConfigs(Config.Criteria criteria) throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.30");
        WebTarget resource = this.resource().path("configs");
        if (criteria != null) {
            HashMap<String, List<String>> filters = new HashMap<String, List<String>>();
            if (criteria.configId() != null) {
                filters.put("id", Collections.singletonList(criteria.configId()));
            }
            if (criteria.label() != null) {
                filters.put("label", Collections.singletonList(criteria.label()));
            }
            if (criteria.name() != null) {
                filters.put("name", Collections.singletonList(criteria.name()));
            }
            resource = resource.queryParam("filters", new Object[]{this.urlEncodeFilters(filters)});
        }
        try {
            return this.request("GET", CONFIG_LIST, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 503: {
                    throw new NonSwarmNodeException("node is not part of a swarm", e);
                }
            }
            throw e;
        }
    }

    @Override
    public ConfigCreateResponse createConfig(ConfigSpec config) throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.30");
        WebTarget resource = this.resource().path("configs").path("create");
        try {
            return this.request("POST", ConfigCreateResponse.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}), Entity.json((Object)config));
        }
        catch (DockerRequestException ex) {
            switch (ex.status()) {
                case 503: {
                    throw new NonSwarmNodeException("Server not part of swarm.", ex);
                }
                case 409: {
                    throw new ConflictException("Name conflicts with an existing object.", ex);
                }
            }
            throw ex;
        }
    }

    @Override
    public Config inspectConfig(String configId) throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.30");
        WebTarget resource = this.resource().path("configs").path(configId);
        try {
            return this.request("GET", Config.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException ex) {
            switch (ex.status()) {
                case 404: {
                    throw new NotFoundException("Config " + configId + " not found.", ex);
                }
                case 503: {
                    throw new NonSwarmNodeException("Config not part of swarm.", ex);
                }
            }
            throw ex;
        }
    }

    @Override
    public void deleteConfig(String configId) throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.30");
        WebTarget resource = this.resource().path("configs").path(configId);
        try {
            this.request("DELETE", resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException ex) {
            switch (ex.status()) {
                case 404: {
                    throw new NotFoundException("Config " + configId + " not found.", ex);
                }
                case 503: {
                    throw new NonSwarmNodeException("Config not part of a swarm.", ex);
                }
            }
            throw ex;
        }
    }

    @Override
    public void updateConfig(String configId, Long version, ConfigSpec nodeSpec) throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.30");
        WebTarget resource = this.resource().path("configs").path(configId).path("update").queryParam("version", new Object[]{version});
        try {
            this.request("POST", String.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}), Entity.json((Object)nodeSpec));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new NotFoundException("Config " + configId + " not found.");
                }
                case 503: {
                    throw new NonSwarmNodeException("Config not part of a swarm.", e);
                }
            }
            throw e;
        }
    }

    @Override
    public List<Node> listNodes() throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.24");
        WebTarget resource = this.resource().path("nodes");
        return this.request("GET", NODE_LIST, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
    }

    @Override
    public List<Node> listNodes(Node.Criteria criteria) throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.24");
        HashMap<String, List<String>> filters = new HashMap<String, List<String>>();
        if (criteria.nodeId() != null) {
            filters.put("id", Collections.singletonList(criteria.nodeId()));
        }
        if (criteria.label() != null) {
            filters.put("label", Collections.singletonList(criteria.label()));
        }
        if (criteria.membership() != null) {
            filters.put("membership", Collections.singletonList(criteria.membership()));
        }
        if (criteria.nodeName() != null) {
            filters.put("name", Collections.singletonList(criteria.nodeName()));
        }
        if (criteria.nodeRole() != null) {
            filters.put("role", Collections.singletonList(criteria.nodeRole()));
        }
        WebTarget resource = this.resource().path("nodes");
        resource = resource.queryParam("filters", new Object[]{this.urlEncodeFilters(filters)});
        return this.request("GET", NODE_LIST, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
    }

    @Override
    public NodeInfo inspectNode(String nodeId) throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.24");
        WebTarget resource = this.resource().path("nodes").path(nodeId);
        try {
            return this.request("GET", NodeInfo.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new NodeNotFoundException(nodeId);
                }
                case 503: {
                    throw new NonSwarmNodeException("Node " + nodeId + " is not in a swarm", e);
                }
            }
            throw e;
        }
    }

    @Override
    public void updateNode(String nodeId, Long version, NodeSpec nodeSpec) throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.24");
        WebTarget resource = this.resource().path("nodes").path(nodeId).path("update").queryParam("version", new Object[]{version});
        try {
            this.request("POST", String.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}), Entity.json((Object)nodeSpec));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new NodeNotFoundException(nodeId);
                }
                case 503: {
                    throw new NonSwarmNodeException("Node " + nodeId + " is not a swarm node", e);
                }
            }
            throw e;
        }
    }

    @Override
    public void deleteNode(String nodeId) throws DockerException, InterruptedException {
        this.deleteNode(nodeId, false);
    }

    @Override
    public void deleteNode(String nodeId, boolean force) throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.24");
        WebTarget resource = this.resource().path("nodes").path(nodeId).queryParam("force", new Object[]{String.valueOf(force)});
        try {
            this.request("DELETE", resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new NodeNotFoundException(nodeId);
                }
                case 503: {
                    throw new NonSwarmNodeException("Node " + nodeId + " is not a swarm node", e);
                }
            }
            throw e;
        }
    }

    @Override
    public void execResizeTty(String execId, Integer height, Integer width) throws DockerException, InterruptedException {
        this.checkTtyParams(height, width);
        WebTarget resource = this.resource().path("exec").path(execId).path("resize");
        if (height != null && height > 0) {
            resource = resource.queryParam("h", new Object[]{height});
        }
        if (width != null && width > 0) {
            resource = resource.queryParam("w", new Object[]{width});
        }
        try {
            this.request("POST", resource, resource.request(new MediaType[]{MediaType.TEXT_PLAIN_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ExecNotFoundException(execId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public ExecState execInspect(String execId) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("exec").path(execId).path("json");
        try {
            return this.request("GET", ExecState.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ExecNotFoundException(execId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public ContainerStats stats(String containerId) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("containers").path(containerId).path("stats").queryParam("stream", new Object[]{"0"});
        try {
            return this.request("GET", ContainerStats.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public void resizeTty(String containerId, Integer height, Integer width) throws DockerException, InterruptedException {
        this.checkTtyParams(height, width);
        WebTarget resource = this.resource().path("containers").path(containerId).path("resize");
        if (height != null && height > 0) {
            resource = resource.queryParam("h", new Object[]{height});
        }
        if (width != null && width > 0) {
            resource = resource.queryParam("w", new Object[]{width});
        }
        try {
            this.request("POST", resource, resource.request(new MediaType[]{MediaType.TEXT_PLAIN_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new ContainerNotFoundException(containerId, e);
                }
            }
            throw e;
        }
    }

    private void checkTtyParams(Integer height, Integer width) throws BadParamException {
        if (height == null && width == null || height != null && height == 0 || width != null && width == 0) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("h", height == null ? null : height.toString());
            paramMap.put("w", width == null ? null : width.toString());
            throw new BadParamException(paramMap, "Either width or height must be non-null and > 0");
        }
    }

    @Override
    public List<Network> listNetworks(DockerClient.ListNetworksParam ... params) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("networks");
        resource = this.addParameters(resource, params);
        return this.request("GET", NETWORK_LIST, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
    }

    @Override
    public Network inspectNetwork(String networkId) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("networks").path(networkId);
        try {
            return this.request("GET", Network.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new NetworkNotFoundException(networkId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public NetworkCreation createNetwork(NetworkConfig networkConfig) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("networks").path("create");
        try {
            return this.request("POST", NetworkCreation.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}), Entity.json((Object)networkConfig));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new NotFoundException("Plugin not found", e);
                }
            }
            throw e;
        }
    }

    @Override
    public void removeNetwork(String networkId) throws DockerException, InterruptedException {
        try {
            WebTarget resource = this.resource().path("networks").path(networkId);
            this.request("DELETE", resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new NetworkNotFoundException(networkId, e);
                }
            }
            throw e;
        }
    }

    @Override
    public void connectToNetwork(String containerId, String networkId) throws DockerException, InterruptedException {
        this.connectToNetwork(networkId, NetworkConnection.builder().containerId(containerId).build());
    }

    @Override
    public void connectToNetwork(String networkId, NetworkConnection networkConnection) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("networks").path(networkId).path("connect");
        try {
            this.request("POST", String.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}), Entity.json((Object)networkConnection));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    String message = String.format("Container %s or network %s not found.", networkConnection.containerId(), networkId);
                    throw new NotFoundException(message, e);
                }
            }
            throw e;
        }
    }

    @Override
    public void disconnectFromNetwork(String containerId, String networkId) throws DockerException, InterruptedException {
        this.disconnectFromNetwork(containerId, networkId, false);
    }

    @Override
    public void disconnectFromNetwork(String containerId, String networkId, boolean force) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("networks").path(networkId).path("disconnect");
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("Container", containerId);
        request.put("Force", force);
        try {
            this.request("POST", String.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}), Entity.json(request));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    String message = String.format("Container %s or network %s not found.", containerId, networkId);
                    throw new NotFoundException(message, e);
                }
            }
            throw e;
        }
    }

    @Override
    public Volume createVolume() throws DockerException, InterruptedException {
        return this.createVolume(Volume.builder().build());
    }

    @Override
    public Volume createVolume(Volume volume) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("volumes").path("create");
        return this.request("POST", Volume.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}), Entity.json((Object)volume));
    }

    @Override
    public Volume inspectVolume(String volumeName) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("volumes").path(volumeName);
        try {
            return this.request("GET", Volume.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new VolumeNotFoundException(volumeName, e);
                }
            }
            throw e;
        }
    }

    @Override
    public void removeVolume(Volume volume) throws DockerException, InterruptedException {
        this.removeVolume(volume.name());
    }

    @Override
    public void removeVolume(String volumeName) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("volumes").path(volumeName);
        try {
            this.request("DELETE", resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 404: {
                    throw new VolumeNotFoundException(volumeName, e);
                }
                case 409: {
                    throw new ConflictException("Volume is in use and cannot be removed", e);
                }
            }
            throw e;
        }
    }

    @Override
    public VolumeList listVolumes(DockerClient.ListVolumesParam ... params) throws DockerException, InterruptedException {
        WebTarget resource = this.resource().path("volumes");
        resource = this.addParameters(resource, params);
        return this.request("GET", VolumeList.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
    }

    @Override
    public List<Secret> listSecrets() throws DockerException, InterruptedException {
        return this.listSecrets(null);
    }

    @Override
    public List<Secret> listSecrets(Secret.Criteria criteria) throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.25");
        WebTarget resource = this.resource().path("secrets");
        if (criteria != null) {
            HashMap<String, List<String>> filters = new HashMap<String, List<String>>();
            if (criteria.id() != null) {
                filters.put("id", Collections.singletonList(criteria.id()));
            }
            if (criteria.label() != null) {
                filters.put("label", Collections.singletonList(criteria.label()));
            }
            if (criteria.name() != null) {
                filters.put("name", Collections.singletonList(criteria.name()));
            }
            resource = resource.queryParam("filters", new Object[]{this.urlEncodeFilters(filters)});
        }
        try {
            return this.request("GET", SECRET_LIST, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException e) {
            switch (e.status()) {
                case 503: {
                    throw new NonSwarmNodeException("node is not part of a swarm", e);
                }
            }
            throw e;
        }
    }

    @Override
    public SecretCreateResponse createSecret(SecretSpec secret) throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.25");
        WebTarget resource = this.resource().path("secrets").path("create");
        try {
            return this.request("POST", SecretCreateResponse.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}), Entity.json((Object)secret));
        }
        catch (DockerRequestException ex) {
            switch (ex.status()) {
                case 406: {
                    throw new NonSwarmNodeException("Server not part of swarm.", ex);
                }
                case 409: {
                    throw new ConflictException("Name conflicts with an existing object.", ex);
                }
            }
            throw ex;
        }
    }

    @Override
    public Secret inspectSecret(String secretId) throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.25");
        WebTarget resource = this.resource().path("secrets").path(secretId);
        try {
            return this.request("GET", Secret.class, resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException ex) {
            switch (ex.status()) {
                case 404: {
                    throw new NotFoundException("Secret " + secretId + " not found.", ex);
                }
                case 406: {
                    throw new NonSwarmNodeException("Server not part of swarm.", ex);
                }
            }
            throw ex;
        }
    }

    @Override
    public void deleteSecret(String secretId) throws DockerException, InterruptedException {
        this.assertApiVersionIsAbove("1.25");
        WebTarget resource = this.resource().path("secrets").path(secretId);
        try {
            this.request("DELETE", resource, resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}));
        }
        catch (DockerRequestException ex) {
            switch (ex.status()) {
                case 404: {
                    throw new NotFoundException("Secret " + secretId + " not found.", ex);
                }
            }
            throw ex;
        }
    }

    private WebTarget resource() {
        WebTarget target = this.client.target(this.uri);
        if (this.apiVersion != null && !"".equals(this.apiVersion.trim())) {
            return target.path(this.apiVersion);
        }
        return target;
    }

    private <T> T request(String method, GenericType<T> type, WebTarget resource, Invocation.Builder request) throws DockerException, InterruptedException {
        try {
            return (T)this.headers(request).async().method(method, type).get();
        }
        catch (ExecutionException | MultiException e) {
            throw this.propagate(method, resource, (Exception)e);
        }
    }

    private <T> T request(String method, Class<T> clazz, WebTarget resource, Invocation.Builder request) throws DockerException, InterruptedException {
        try {
            return (T)this.headers(request).async().method(method, clazz).get();
        }
        catch (ExecutionException | MultiException e) {
            throw this.propagate(method, resource, (Exception)e);
        }
    }

    private <T> T request(String method, Class<T> clazz, WebTarget resource, Invocation.Builder request, Entity<?> entity) throws DockerException, InterruptedException {
        try {
            return (T)this.headers(request).async().method(method, entity, clazz).get();
        }
        catch (ExecutionException | MultiException e) {
            throw this.propagate(method, resource, (Exception)e);
        }
    }

    private void request(String method, WebTarget resource, Invocation.Builder request) throws DockerException, InterruptedException {
        try {
            this.headers(request).async().method(method, String.class).get();
        }
        catch (ExecutionException | MultiException e) {
            throw this.propagate(method, resource, (Exception)e);
        }
    }

    private void tailResponse(String method, Response response, ProgressHandler handler, WebTarget resource) throws DockerException, InterruptedException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            ProgressStream stream = (ProgressStream)response.readEntity(ProgressStream.class);
            Future<Void> future = executor.submit(new ResponseTailReader(stream, handler, method, resource));
            future.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DockerException) {
                throw (DockerException)cause;
            }
            throw new DockerException(cause);
        }
        finally {
            executor.shutdownNow();
            try {
                response.close();
            }
            catch (ProcessingException processingException) {}
        }
    }

    private void requestAndTail(String method, ProgressHandler handler, WebTarget resource, Invocation.Builder request, Entity<?> entity) throws DockerException, InterruptedException {
        Response response = this.request(method, Response.class, resource, request, entity);
        this.tailResponse(method, response, handler, resource);
    }

    private void requestAndTail(String method, ProgressHandler handler, WebTarget resource, Invocation.Builder request) throws DockerException, InterruptedException {
        Response response = this.request(method, Response.class, resource, request);
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw new DockerRequestException(method, resource.getUri(), response.getStatus(), (String)response.readEntity(String.class), null);
        }
        this.tailResponse(method, response, handler, resource);
    }

    private Invocation.Builder headers(Invocation.Builder request) {
        Set<Map.Entry<String, Object>> entries = this.headers.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            request.header(entry.getKey(), entry.getValue());
        }
        return request;
    }

    private RuntimeException propagate(String method, WebTarget resource, Exception ex) throws DockerException, InterruptedException {
        Throwable cause = ex.getCause();
        if (ex instanceof MultiException) {
            cause = cause.getCause();
        }
        Response response = null;
        if (cause instanceof ResponseProcessingException) {
            response = ((ResponseProcessingException)cause).getResponse();
        } else if (cause instanceof WebApplicationException) {
            response = ((WebApplicationException)cause).getResponse();
        } else if (cause instanceof ProcessingException && cause.getCause() != null) {
            cause = cause.getCause();
        }
        if (response != null) {
            throw new DockerRequestException(method, resource.getUri(), response.getStatus(), (String)response.readEntity(String.class), cause);
        }
        if (cause instanceof SocketTimeoutException || cause instanceof ConnectTimeoutException) {
            throw new DockerTimeoutException(method, resource.getUri(), ex);
        }
        if (cause instanceof InterruptedIOException || cause instanceof InterruptedException) {
            throw new InterruptedException("Interrupted: " + method + " " + resource);
        }
        throw new DockerException(ex);
    }

    private String authHeader(RegistryAuth registryAuth) throws DockerException {
        if (registryAuth == null) {
            return "null";
        }
        try {
            return Base64.encodeBase64String((byte[])ObjectMapperProvider.objectMapper().writeValueAsBytes((Object)registryAuth));
        }
        catch (JsonProcessingException ex) {
            throw new DockerException("Could not encode X-Registry-Auth header", ex);
        }
    }

    private String authRegistryHeader(RegistryConfigs registryConfigs) throws DockerException {
        if (registryConfigs == null) {
            return null;
        }
        try {
            String authRegistryJson = ObjectMapperProvider.objectMapper().writeValueAsString(registryConfigs.configs());
            String apiVersion = this.version().apiVersion();
            int versionComparison = VersionCompare.compareVersion(apiVersion, "1.19");
            if (versionComparison < 0) {
                authRegistryJson = "{\"configs\":" + authRegistryJson + "}";
            } else if (versionComparison == 0) {
                authRegistryJson = "{\"auths\":" + authRegistryJson + "}";
            }
            return Base64.encodeBase64String((byte[])authRegistryJson.getBytes(StandardCharsets.UTF_8));
        }
        catch (JsonProcessingException | InterruptedException ex) {
            throw new DockerException("Could not encode X-Registry-Config header", ex);
        }
    }

    private void assertApiVersionIsAbove(String minimumVersion) throws DockerException, InterruptedException {
        String apiVersion = this.version().apiVersion();
        int versionComparison = VersionCompare.compareVersion(apiVersion, minimumVersion);
        if (versionComparison < 0) {
            throw new UnsupportedApiVersionException(apiVersion);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder fromEnv() throws DockerCertificateException {
        String endpoint = DockerHost.endpointFromEnv();
        Path dockerCertPath = Paths.get(Arrays.asList(DockerHost.certPathFromEnv(), DockerHost.configPathFromEnv(), DockerHost.defaultCertPath()).stream().filter(cert -> cert != null).findFirst().orElseThrow(() -> new NoSuchElementException("Cannot find docker certificated path")), new String[0]);
        Builder builder = new Builder();
        Optional<DockerCertificatesStore> certs = DockerCertificates.builder().dockerCertPath(dockerCertPath).build();
        if (endpoint.startsWith("unix://")) {
            builder.uri(endpoint);
        } else if (endpoint.startsWith("npipe://")) {
            builder.uri(endpoint);
        } else {
            String stripped = endpoint.replaceAll(".*://", "");
            String scheme = certs.isPresent() ? "https" : "http";
            URI initialUri = URI.create(scheme + "://" + stripped);
            if (initialUri.getPort() == -1 && initialUri.getHost() == null) {
                initialUri = URI.create(scheme + "://" + DockerHost.defaultAddress() + ":" + DockerHost.defaultPort());
            } else if (initialUri.getHost() == null) {
                initialUri = URI.create(scheme + "://" + DockerHost.defaultAddress() + ":" + initialUri.getPort());
            } else if (initialUri.getPort() == -1) {
                initialUri = URI.create(scheme + "://" + initialUri.getHost() + ":" + DockerHost.defaultPort());
            }
            builder.uri(initialUri);
        }
        if (certs.isPresent()) {
            builder.dockerCertificates(certs.get());
        }
        return builder;
    }

    static /* synthetic */ long access$1300() {
        return DEFAULT_CONNECT_TIMEOUT_MILLIS;
    }

    static /* synthetic */ long access$1400() {
        return DEFAULT_READ_TIMEOUT_MILLIS;
    }

    private static class BuildProgressHandler
    implements ProgressHandler {
        private final ProgressHandler delegate;
        private String imageId;

        private BuildProgressHandler(ProgressHandler delegate) {
            this.delegate = delegate;
        }

        private String getImageId() {
            if (this.imageId == null) {
                throw new IllegalStateException("Could not acquire image ID or digest following build");
            }
            return this.imageId;
        }

        @Override
        public void progress(ProgressMessage message) throws DockerException {
            this.delegate.progress(message);
            String id = message.buildImageId();
            if (id != null) {
                this.imageId = id;
            }
        }
    }

    public static class Builder {
        public static final String ERROR_MESSAGE = "LOGIC ERROR: DefaultDockerClient does not support being built with both `registryAuth` and `registryAuthSupplier`. Please build with at most one of these options.";
        private URI uri;
        private String apiVersion;
        private long connectTimeoutMillis = DefaultDockerClient.access$1300();
        private long readTimeoutMillis = DefaultDockerClient.access$1400();
        private int connectionPoolSize = 100;
        private DockerCertificatesStore dockerCertificatesStore;
        private boolean useProxy = true;
        private RegistryAuthSupplier registryAuthSupplier;
        private Map<String, Object> headers = new HashMap<String, Object>();
        private RequestEntityProcessing requestEntityProcessing;

        public URI uri() {
            return this.uri;
        }

        public Builder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder uri(String uri) {
            return this.uri(URI.create(uri));
        }

        public Builder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public String apiVersion() {
            return this.apiVersion;
        }

        public long connectTimeoutMillis() {
            return this.connectTimeoutMillis;
        }

        public Builder connectTimeoutMillis(long connectTimeoutMillis) {
            this.connectTimeoutMillis = connectTimeoutMillis;
            return this;
        }

        public long readTimeoutMillis() {
            return this.readTimeoutMillis;
        }

        public Builder readTimeoutMillis(long readTimeoutMillis) {
            this.readTimeoutMillis = readTimeoutMillis;
            return this;
        }

        public DockerCertificatesStore dockerCertificates() {
            return this.dockerCertificatesStore;
        }

        public Builder dockerCertificates(DockerCertificatesStore dockerCertificatesStore) {
            this.dockerCertificatesStore = dockerCertificatesStore;
            return this;
        }

        public int connectionPoolSize() {
            return this.connectionPoolSize;
        }

        public Builder connectionPoolSize(int connectionPoolSize) {
            this.connectionPoolSize = connectionPoolSize;
            return this;
        }

        public boolean useProxy() {
            return this.useProxy;
        }

        public Builder useProxy(boolean useProxy) {
            this.useProxy = useProxy;
            return this;
        }

        public Builder registryAuthSupplier(RegistryAuthSupplier registryAuthSupplier) {
            if (this.registryAuthSupplier != null) {
                throw new IllegalStateException(ERROR_MESSAGE);
            }
            this.registryAuthSupplier = registryAuthSupplier;
            return this;
        }

        public Builder header(String name, Object value) {
            this.headers.put(name, value);
            return this;
        }

        public Map<String, Object> headers() {
            return this.headers;
        }

        public Builder useRequestEntityProcessing(RequestEntityProcessing requestEntityProcessing) {
            this.requestEntityProcessing = requestEntityProcessing;
            return this;
        }

        public RequestEntityProcessing getRequestEntityProcessing() {
            return this.requestEntityProcessing;
        }

        public DefaultDockerClient build() {
            if (this.registryAuthSupplier == null) {
                this.registryAuthSupplier(new ConfigFileRegistryAuthSupplier());
            }
            return new DefaultDockerClient(this);
        }
    }

    private static class CreateProgressHandler
    implements ProgressHandler {
        private static final int EXPECTED_CHARACTER_NUM1 = 64;
        private static final int EXPECTED_CHARACTER_NUM2 = 71;
        private final ProgressHandler delegate;
        private String imageId;

        private CreateProgressHandler(ProgressHandler delegate) {
            this.delegate = delegate;
        }

        private String getImageId() {
            if (this.imageId == null) {
                throw new IllegalStateException("Could not acquire image ID or digest following create");
            }
            return this.imageId;
        }

        @Override
        public void progress(ProgressMessage message) throws DockerException {
            this.delegate.progress(message);
            String status = message.status();
            if (status != null && (status.length() == 64 || status.length() == 71)) {
                this.imageId = message.status();
            }
        }
    }

    private static class LoadProgressHandler
    implements ProgressHandler {
        private static final Pattern IMAGE_STREAM_PATTERN = Pattern.compile("Loaded image: (?<image>.+)\n");
        private final ProgressHandler delegate;
        private Set<String> imageNames;

        private LoadProgressHandler(ProgressHandler delegate) {
            this.delegate = delegate;
            this.imageNames = new HashSet<String>();
        }

        private Set<String> getImageNames() {
            return Collections.unmodifiableSet(new HashSet<String>(this.imageNames));
        }

        @Override
        public void progress(ProgressMessage message) throws DockerException {
            Matcher streamMatcher;
            this.delegate.progress(message);
            String stream = message.stream();
            if (stream != null && (streamMatcher = IMAGE_STREAM_PATTERN.matcher(stream)).matches()) {
                this.imageNames.add(streamMatcher.group("image"));
            }
        }
    }

    private static class ResponseTailReader
    implements Callable<Void> {
        private final ProgressStream stream;
        private final ProgressHandler handler;
        private final String method;
        private final WebTarget resource;

        public ResponseTailReader(ProgressStream stream, ProgressHandler handler, String method, WebTarget resource) {
            this.stream = stream;
            this.handler = handler;
            this.method = method;
            this.resource = resource;
        }

        @Override
        public Void call() throws DockerException, InterruptedException, IOException {
            this.stream.tail(this.handler, this.method, this.resource.getUri());
            return null;
        }
    }
}

