/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc;

import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.AbstractRemoteServiceServlet;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.RPCServletUtils;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyLoader;
import com.google.gwt.user.server.rpc.SerializationPolicyProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RemoteServiceServlet
extends AbstractRemoteServiceServlet
implements SerializationPolicyProvider {
    private final Map<String, SerializationPolicy> serializationPolicyCache = new HashMap<String, SerializationPolicy>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SerializationPolicy loadSerializationPolicy(HttpServlet servlet, HttpServletRequest request, String moduleBaseURL, String strongName) {
        String contextPath = request.getContextPath();
        String modulePath = null;
        if (moduleBaseURL != null) {
            try {
                modulePath = new URL(moduleBaseURL).getPath();
            }
            catch (MalformedURLException ex) {
                servlet.log("Malformed moduleBaseURL: " + moduleBaseURL, (Throwable)ex);
            }
        }
        SerializationPolicy serializationPolicy = null;
        if (modulePath == null || !modulePath.startsWith(contextPath)) {
            String message = "ERROR: The module path requested, " + modulePath + ", is not in the same web application as this servlet, " + contextPath + ".  Your module may not be properly configured or your client and server code maybe out of date.";
            servlet.log(message, null);
        } else {
            String contextRelativePath = modulePath.substring(contextPath.length());
            String serializationPolicyFilePath = SerializationPolicyLoader.getSerializationPolicyFileName(contextRelativePath + strongName);
            InputStream is = servlet.getServletContext().getResourceAsStream(serializationPolicyFilePath);
            try {
                if (is != null) {
                    try {
                        serializationPolicy = SerializationPolicyLoader.loadFromStream(is, null);
                    }
                    catch (ParseException e) {
                        servlet.log("ERROR: Failed to parse the policy file '" + serializationPolicyFilePath + "'", (Throwable)e);
                    }
                    catch (IOException e) {
                        servlet.log("ERROR: Could not read the policy file '" + serializationPolicyFilePath + "'", (Throwable)e);
                    }
                } else {
                    String message = "ERROR: The serialization policy file '" + serializationPolicyFilePath + "' was not found; did you forget to include it in this deployment?";
                    servlet.log(message);
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return serializationPolicy;
    }

    public final SerializationPolicy getSerializationPolicy(String moduleBaseURL, String strongName) {
        SerializationPolicy serializationPolicy = this.getCachedSerializationPolicy(moduleBaseURL, strongName);
        if (serializationPolicy != null) {
            return serializationPolicy;
        }
        serializationPolicy = this.doGetSerializationPolicy(this.getThreadLocalRequest(), moduleBaseURL, strongName);
        if (serializationPolicy == null) {
            this.log("WARNING: Failed to get the SerializationPolicy '" + strongName + "' for module '" + moduleBaseURL + "'; a legacy, 1.3.3 compatible, serialization policy will be used.  You may experience SerializationExceptions as a result.", null);
            serializationPolicy = RPC.getDefaultSerializationPolicy();
        }
        this.putCachedSerializationPolicy(moduleBaseURL, strongName, serializationPolicy);
        return serializationPolicy;
    }

    public String processCall(String payload) throws SerializationException {
        try {
            RPCRequest rpcRequest = RPC.decodeRequest(payload, this.getClass(), this);
            this.onAfterRequestDeserialized(rpcRequest);
            return RPC.invokeAndEncodeResponse(this, rpcRequest.getMethod(), rpcRequest.getParameters(), rpcRequest.getSerializationPolicy(), rpcRequest.getFlags());
        }
        catch (IncompatibleRemoteServiceException ex) {
            this.log("An IncompatibleRemoteServiceException was thrown while processing this call.", ex);
            return RPC.encodeResponseForFailure(null, ex);
        }
    }

    public final void processPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, SerializationException {
        String requestPayload = this.readContent(request);
        this.onBeforeRequestDeserialized(requestPayload);
        String responsePayload = this.processCall(requestPayload);
        this.onAfterResponseSerialized(responsePayload);
        this.writeResponse(request, response, responsePayload);
    }

    protected SerializationPolicy doGetSerializationPolicy(HttpServletRequest request, String moduleBaseURL, String strongName) {
        return RemoteServiceServlet.loadSerializationPolicy(this, request, moduleBaseURL, strongName);
    }

    protected void onAfterResponseSerialized(String serializedResponse) {
    }

    protected void onBeforeRequestDeserialized(String serializedRequest) {
    }

    protected boolean shouldCompressResponse(HttpServletRequest request, HttpServletResponse response, String responsePayload) {
        return RPCServletUtils.exceedsUncompressedContentLengthLimit(responsePayload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SerializationPolicy getCachedSerializationPolicy(String moduleBaseURL, String strongName) {
        Map<String, SerializationPolicy> map = this.serializationPolicyCache;
        synchronized (map) {
            return this.serializationPolicyCache.get(moduleBaseURL + strongName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putCachedSerializationPolicy(String moduleBaseURL, String strongName, SerializationPolicy serializationPolicy) {
        Map<String, SerializationPolicy> map = this.serializationPolicyCache;
        synchronized (map) {
            this.serializationPolicyCache.put(moduleBaseURL + strongName, serializationPolicy);
        }
    }

    private void writeResponse(HttpServletRequest request, HttpServletResponse response, String responsePayload) throws IOException {
        boolean gzipEncode = RPCServletUtils.acceptsGzipEncoding(request) && this.shouldCompressResponse(request, response, responsePayload);
        RPCServletUtils.writeResponse(this.getServletContext(), response, responsePayload, gzipEncode);
    }
}

