/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.merrimac.dialogs;

import java.util.List;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.Messages;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.TextAndButtonObjectEditor;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.osgi.util.NLS;

public abstract class UniqueNameEditor<T extends EObject>
extends TextAndButtonObjectEditor {
    public UniqueNameEditor(AbstractDetailComposite parent, T object, EStructuralFeature feature) {
        super(parent, (EObject)object, feature);
    }

    protected abstract List<T> getEObjectList();

    protected String validateName(String name) {
        return null;
    }

    protected boolean isNullAllowed() {
        return false;
    }

    @Override
    protected void buttonClicked(int buttonId) {
        String text = this.getText();
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || newText.isEmpty()) {
                    if (UniqueNameEditor.this.isNullAllowed()) {
                        return null;
                    }
                    return Messages.UniqueNameEditor_Name_is_Null;
                }
                String message = UniqueNameEditor.this.validateName(newText);
                if (message != null) {
                    return message;
                }
                for (EObject o : UniqueNameEditor.this.getEObjectList()) {
                    String name;
                    if (o == UniqueNameEditor.this.object || !(o.eGet(UniqueNameEditor.this.feature) instanceof String) || !newText.equals(name = (String)o.eGet(UniqueNameEditor.this.feature))) continue;
                    return NLS.bind((String)Messages.UniqueNameEditor_Duplicate_Name, (Object)newText);
                }
                return null;
            }
        };
        InputDialog dialog = new InputDialog(this.parent.getShell(), Messages.UniqueNameEditor_Edit_Name, NLS.bind((String)Messages.UniqueNameEditor_Enter_New_Name_for, (Object)this.getObjectName(this.object)), text, validator);
        if (dialog.open() == 0) {
            this.setValue(dialog.getValue());
        }
    }

    private String getObjectName(EObject o) {
        return String.valueOf(ModelUtil.getLabel(o)) + " \"" + ModelUtil.getDisplayName(o) + "\"";
    }
}

