/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property.dialogs;

import java.util.Map;
import org.eclipse.bpmn2.modeler.ui.property.dialogs.Messages;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NamespacesEditingDialog
extends InputDialog {
    Text namespaceText;
    String namespace;
    Text namespaceErrorText;
    Map<String, String> map;

    public NamespacesEditingDialog(Shell shell, String title, final Map<String, String> map, final String prefix, String namespace) {
        super(shell, title, Messages.NamespacesEditingDialog_Prefix, prefix, new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || newText.isEmpty()) {
                    return Messages.NamespacesEditingDialog_Invalid_Empty_Prefix;
                }
                if (newText.equals(prefix)) {
                    return null;
                }
                if (map.containsKey(newText)) {
                    return NLS.bind((String)Messages.NamespacesEditingDialog_Invalid_Duplicate_Prefix, (Object)newText);
                }
                return null;
            }
        });
        this.namespace = namespace;
        this.map = map;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.getChildren();
        if (this.namespace != null) {
            Label label = new Label(composite, 64);
            label.setText(Messages.NamespacesEditingDialog_Namespace);
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
            this.namespaceText = new Text(composite, this.getInputTextStyle());
            this.namespaceText.setText(this.namespace);
            this.namespaceText.setLayoutData((Object)new GridData(768));
            this.namespaceText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NamespacesEditingDialog.this.validateInput();
                }
            });
            this.namespaceErrorText = new Text(composite, 72);
            this.namespaceErrorText.setLayoutData((Object)new GridData(768));
            this.namespaceErrorText.setBackground(this.namespaceErrorText.getDisplay().getSystemColor(22));
        }
        return composite;
    }

    protected void validateInput() {
        super.validateInput();
        if (this.namespaceText != null) {
            String msg = null;
            String ns = this.namespaceText.getText();
            if (ns == null || ns.isEmpty()) {
                msg = Messages.NamespacesEditingDialog_Invalid_Empty_Namespace;
            }
            try {
                URI.createURI((String)ns);
            }
            catch (Exception exception) {
                msg = Messages.NamespacesEditingDialog_Invalid_Namespace_URI;
            }
            this.namespaceErrorText.setText(msg == null ? "" : msg);
            Button button = this.getButton(0);
            if (button != null && button.isEnabled()) {
                button.setEnabled(msg == null);
            }
        }
    }

    protected void buttonPressed(int buttonId) {
        this.namespace = buttonId == 0 ? this.namespaceText.getText() : null;
        super.buttonPressed(buttonId);
    }

    public String getPrefix() {
        return this.getValue();
    }

    public String getNamespace() {
        return this.namespace;
    }
}

