/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.autotools.ui.editors.outline;

import java.util.ArrayList;
import org.eclipse.cdt.autotools.ui.editors.AutoconfEditor;
import org.eclipse.cdt.autotools.ui.editors.outline.AutoconfContentProvider;
import org.eclipse.cdt.autotools.ui.editors.outline.AutoconfLabelProvider;
import org.eclipse.cdt.autotools.ui.editors.parser.AutoconfElement;
import org.eclipse.cdt.internal.autotools.ui.editors.LexicalSortingAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class AutoconfContentOutlinePage
extends ContentOutlinePage {
    private ITextEditor editor;
    private IEditorInput input;
    private LexicalSortingAction sortAction;

    public AutoconfContentOutlinePage(AutoconfEditor editor) {
        this.editor = editor;
    }

    public void setInput(IEditorInput editorInput) {
        this.input = editorInput;
        this.update();
    }

    protected ISelection updateSelection(ISelection sel) {
        ArrayList<AutoconfElement> newSelection = new ArrayList<AutoconfElement>();
        if (sel instanceof IStructuredSelection) {
            for (Object o : (IStructuredSelection)sel) {
                if (!(o instanceof AutoconfElement)) continue;
                newSelection.add((AutoconfElement)o);
            }
        }
        return new StructuredSelection(newSelection);
    }

    public void update() {
        Control control;
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
            control.getDisplay().asyncExec(() -> {
                if (!control.isDisposed()) {
                    ISelection sel = viewer.getSelection();
                    viewer.setSelection(this.updateSelection(sel));
                    viewer.refresh();
                }
            });
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new AutoconfContentProvider(this.editor));
        viewer.setLabelProvider((IBaseLabelProvider)new AutoconfLabelProvider());
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.input != null) {
            viewer.setInput((Object)this.input);
        }
        this.sortAction.setTreeViewer(viewer);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this.editor.resetHighlightRange();
        } else {
            AutoconfElement element = (AutoconfElement)((IStructuredSelection)selection).getFirstElement();
            try {
                int offset = element.getStartOffset();
                int length = element.getEndOffset() - offset;
                this.editor.setHighlightRange(offset, length, true);
                this.editor.selectAndReveal(offset, length);
            }
            catch (IllegalArgumentException x) {
                this.editor.resetHighlightRange();
            }
        }
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        IToolBarManager toolBarManager = pageSite.getActionBars().getToolBarManager();
        this.sortAction = new LexicalSortingAction();
        toolBarManager.add((IAction)this.sortAction);
    }
}

