/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.docker.launcher;

import org.eclipse.cdt.internal.docker.launcher.BaseDatabindingModel;
import org.eclipse.cdt.internal.docker.launcher.ExposedPortModel;
import org.eclipse.cdt.internal.docker.launcher.Messages;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ContainerPortDialog
extends Dialog {
    private static final String PORT_TYPE = "tcp";
    private final ContainerPortDialogModel model;
    private final DataBindingContext dbc = new DataBindingContext();

    public ContainerPortDialog(Shell parentShell) {
        super(parentShell);
        this.model = new ContainerPortDialogModel();
    }

    public ContainerPortDialog(Shell parentShell, ExposedPortModel selectedContainerPort) {
        super(parentShell);
        this.model = new ContainerPortDialogModel(selectedContainerPort.getContainerPort(), selectedContainerPort.getHostAddress(), selectedContainerPort.getHostPort());
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        shell.setText(Messages.ContainerPortDialog_shellTitle);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            button.setEnabled(false);
        }
        return button;
    }

    protected Point getInitialSize() {
        return new Point(400, super.getInitialSize().y);
    }

    protected Control createDialogArea(Composite parent) {
        int COLUMNS = 2;
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).span(2, 1).grab(true, true).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).applyTo(container);
        Label explanationLabel = new Label(container, 0);
        explanationLabel.setText(Messages.ContainerPortDialog_explanationLabel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(false, false).applyTo((Control)explanationLabel);
        Label containerLabel = new Label(container, 0);
        containerLabel.setText(Messages.ContainerPortDialog_containerLabel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)containerLabel);
        Text containerPortText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)containerPortText);
        Label hostAddressLabel = new Label(container, 0);
        hostAddressLabel.setText(Messages.ContainerPortDialog_hostAddressLabel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)hostAddressLabel);
        Text hostAddressText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)hostAddressText);
        Label hostPortLabel = new Label(container, 0);
        hostPortLabel.setText(Messages.ContainerPortDialog_hostPortLabel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)hostPortLabel);
        Text hostPortText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)hostPortText);
        Label errorMessageLabel = new Label(container, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(true, false).applyTo((Control)errorMessageLabel);
        ISWTObservableValue containerPortObservable = WidgetProperties.text((int)24).observe((Widget)containerPortText);
        this.dbc.bindValue((IObservableValue)containerPortObservable, BeanProperties.value(ContainerPortDialogModel.class, (String)"containerPort").observe((Object)this.model));
        ISWTObservableValue hostAddressObservable = WidgetProperties.text((int)24).observe((Widget)hostAddressText);
        this.dbc.bindValue((IObservableValue)hostAddressObservable, BeanProperties.value(ContainerPortDialogModel.class, (String)"hostAddress").observe((Object)this.model));
        ISWTObservableValue hostPortObservable = WidgetProperties.text((int)24).observe((Widget)hostPortText);
        this.dbc.bindValue((IObservableValue)hostPortObservable, BeanProperties.value(ContainerPortDialogModel.class, (String)"hostPort").observe((Object)this.model));
        containerPortObservable.addValueChangeListener(this.onContainerPortSettingsChanged());
        hostPortObservable.addValueChangeListener(this.onContainerPortSettingsChanged());
        hostAddressObservable.addValueChangeListener(this.onContainerPortSettingsChanged());
        return container;
    }

    private IValueChangeListener<String> onContainerPortSettingsChanged() {
        return event -> this.validateInput();
    }

    private void validateInput() {
        String containerPort = this.model.getContainerPort();
        if (containerPort == null || containerPort.isEmpty()) {
            this.setOkButtonEnabled(false);
        } else {
            this.setOkButtonEnabled(true);
        }
    }

    private void setOkButtonEnabled(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
    }

    public ExposedPortModel getPort() {
        return new ExposedPortModel(this.model.getContainerPort(), PORT_TYPE, this.model.getHostAddress(), this.model.getHostPort());
    }

    class ContainerPortDialogModel
    extends BaseDatabindingModel {
        public static final String CONTAINER_PORT = "containerPort";
        public static final String HOST_ADDRESS = "hostAddress";
        public static final String HOST_PORT = "hostPort";
        private String containerPort;
        private String hostAddress;
        private String hostPort;

        public ContainerPortDialogModel() {
        }

        public ContainerPortDialogModel(String containerPort, String hostAddress, String hostPort) {
            this.containerPort = containerPort;
            this.hostAddress = hostAddress;
            this.hostPort = hostPort;
        }

        public String getContainerPort() {
            return this.containerPort;
        }

        public void setContainerPort(String containerPort) {
            this.containerPort = containerPort;
            this.firePropertyChange(CONTAINER_PORT, this.containerPort, this.containerPort);
        }

        public String getHostAddress() {
            return this.hostAddress;
        }

        public void setHostAddress(String hostName) {
            this.hostAddress = hostName;
            this.firePropertyChange(HOST_ADDRESS, this.hostAddress, this.hostAddress);
        }

        public String getHostPort() {
            return this.hostPort;
        }

        public void setHostPort(String hostPort) {
            this.hostPort = hostPort;
            this.firePropertyChange(HOST_PORT, this.hostPort, this.hostPort);
        }
    }
}

