/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.actions;

import java.util.ResourceBundle;
import org.eclipse.cdt.make.internal.ui.actions.FoldingMessages;
import org.eclipse.cdt.make.internal.ui.editor.MakefileEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.ui.texteditor.TextOperationAction;

public class FoldingActionGroup
extends ActionGroup {
    private ProjectionViewer fViewer;
    private IProjectionListener fProjectionListener;
    private TextOperationAction fToggle;
    private TextOperationAction fExpand;
    private TextOperationAction fCollapse;
    private TextOperationAction fExpandAll;
    private TextOperationAction fCollapseAll;
    private PreferenceAction fRestoreDefaults;

    public FoldingActionGroup(final ITextEditor editor, ITextViewer viewer) {
        if (!(viewer instanceof ProjectionViewer)) {
            this.fToggle = null;
            this.fExpand = null;
            this.fCollapse = null;
            this.fExpandAll = null;
            this.fCollapseAll = null;
            this.fRestoreDefaults = null;
            this.fProjectionListener = null;
            return;
        }
        this.fViewer = (ProjectionViewer)viewer;
        this.fProjectionListener = new IProjectionListener(){

            public void projectionEnabled() {
                FoldingActionGroup.this.update();
            }

            public void projectionDisabled() {
                FoldingActionGroup.this.update();
            }
        };
        this.fViewer.addProjectionListener(this.fProjectionListener);
        this.fToggle = new TextOperationAction(FoldingMessages.getResourceBundle(), "Projection.Toggle.", editor, 19, true);
        this.fToggle.setActionDefinitionId("org.eclipse.ui.edit.text.folding.toggle");
        editor.setAction("FoldingToggle", (IAction)this.fToggle);
        this.fExpandAll = new TextOperationAction(FoldingMessages.getResourceBundle(), "Projection.ExpandAll.", editor, 20, true);
        this.fExpandAll.setActionDefinitionId("org.eclipse.ui.edit.text.folding.expand_all");
        editor.setAction("FoldingExpandAll", (IAction)this.fExpandAll);
        this.fCollapseAll = new TextOperationAction(FoldingMessages.getResourceBundle(), "Projection.CollapseAll.", editor, 21, true);
        this.fCollapseAll.setActionDefinitionId("org.eclipse.ui.edit.text.folding.collapse_all");
        editor.setAction("FoldingCollapseAll", (IAction)this.fCollapseAll);
        this.fExpand = new TextOperationAction(FoldingMessages.getResourceBundle(), "Projection.Expand.", editor, 17, true);
        this.fExpand.setActionDefinitionId("org.eclipse.ui.edit.text.folding.expand");
        editor.setAction("FoldingExpand", (IAction)this.fExpand);
        this.fCollapse = new TextOperationAction(FoldingMessages.getResourceBundle(), "Projection.Collapse.", editor, 18, true);
        this.fCollapse.setActionDefinitionId("org.eclipse.ui.edit.text.folding.collapse");
        editor.setAction("FoldingCollapse", (IAction)this.fCollapse);
        this.fRestoreDefaults = new FoldingAction(this, FoldingMessages.getResourceBundle(), "Projection.Restore."){

            public void run() {
                if (editor instanceof MakefileEditor) {
                    MakefileEditor makefileEditor = (MakefileEditor)editor;
                    makefileEditor.resetProjection();
                }
            }
        };
        this.fRestoreDefaults.setActionDefinitionId("org.eclipse.ui.edit.text.folding.restore");
        editor.setAction("FoldingRestore", (IAction)this.fRestoreDefaults);
    }

    protected boolean isEnabled() {
        return this.fViewer != null;
    }

    public void dispose() {
        if (this.isEnabled()) {
            this.fViewer.removeProjectionListener(this.fProjectionListener);
            this.fViewer = null;
        }
        super.dispose();
    }

    protected void update() {
        if (this.isEnabled()) {
            this.fToggle.update();
            this.fToggle.setChecked(this.fViewer.isProjectionMode());
            this.fExpand.update();
            this.fExpandAll.update();
            this.fCollapse.update();
            this.fCollapseAll.update();
            this.fRestoreDefaults.update();
        }
    }

    public void fillMenu(IMenuManager manager) {
        if (this.isEnabled()) {
            this.update();
            manager.add((IAction)this.fToggle);
            manager.add((IAction)this.fExpandAll);
            manager.add((IAction)this.fExpand);
            manager.add((IAction)this.fCollapse);
            manager.add((IAction)this.fCollapseAll);
            manager.add((IAction)this.fRestoreDefaults);
        }
    }

    public void updateActionBars() {
        this.update();
    }

    private class FoldingAction
    extends PreferenceAction {
        FoldingAction(ResourceBundle bundle, String prefix) {
            super(bundle, prefix, 1);
        }

        public void update() {
            this.setEnabled(FoldingActionGroup.this.isEnabled() && FoldingActionGroup.this.fViewer.isProjectionMode());
        }
    }

    private static abstract class PreferenceAction
    extends ResourceAction
    implements IUpdate {
        PreferenceAction(ResourceBundle bundle, String prefix, int style) {
            super(bundle, prefix, style);
            this.update();
        }
    }
}

