/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.buildconsole;

import java.net.URI;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.core.resources.ResourcesUtil;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsolePage;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsolePartitioner;
import org.eclipse.cdt.internal.ui.buildconsole.ConsoleMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IBuildConsoleManager;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class CopyBuildLogAction
extends Action {
    private BuildConsolePage fConsolePage;

    public CopyBuildLogAction(BuildConsolePage page) {
        this.setToolTipText(ConsoleMessages.CopyLog_ActionTooltip);
        CPluginImages.setImageDescriptors((IAction)this, "lcl16/", "org.eclipse.cdt.ui.save_console.gif");
        this.fConsolePage = page;
    }

    public void run() {
        IBuildConsoleManager consoleManager = this.fConsolePage.getConsole().getConsoleManager();
        IProject project = this.fConsolePage.getProject();
        IConsole console = consoleManager.getProjectConsole(project);
        Shell shell = Display.getCurrent().getActiveShell();
        if (console instanceof BuildConsolePartitioner) {
            URI srcURI = ((BuildConsolePartitioner)console).getLogURI();
            if (srcURI == null) {
                MessageDialog.openWarning((Shell)shell, (String)ConsoleMessages.CopyLog_UnavailableLog, (String)ConsoleMessages.CopyLog_BuildNotLogged);
                return;
            }
            IFileStore srcStore = null;
            try {
                srcStore = EFS.getStore((URI)srcURI);
            }
            catch (CoreException e) {
                CUIPlugin.log(e);
                MessageDialog.openError((Shell)shell, (String)ConsoleMessages.CopyLog_UnavailableLog, (String)(String.valueOf(ConsoleMessages.CopyLog_UnableToAccess) + srcURI));
                return;
            }
            if (!srcStore.fetchInfo().exists()) {
                MessageDialog.openError((Shell)shell, (String)ConsoleMessages.CopyLog_UnavailableLog, (String)ConsoleMessages.CopyLog_LogFileIsNotAvailable);
                return;
            }
            FileDialog dialog = new FileDialog(shell, 0);
            dialog.setText(ConsoleMessages.CopyLog_ChooseDestination);
            String destLocation = dialog.open();
            if (destLocation != null) {
                URI destURI = URIUtil.toURI((String)destLocation);
                if (destURI == null) {
                    MessageDialog.openError((Shell)shell, (String)ConsoleMessages.CopyLog_UnavailableLog, (String)(String.valueOf(ConsoleMessages.CopyLog_InvalidDestination) + destLocation));
                    return;
                }
                try {
                    try {
                        IFileStore destStore = EFS.getStore((URI)destURI);
                        srcStore.copy(destStore, 2, null);
                    }
                    catch (CoreException e) {
                        CUIPlugin.log(e);
                        MessageDialog.openError((Shell)shell, (String)ConsoleMessages.CopyLog_ErrorCopyingFile, (String)(String.valueOf(ConsoleMessages.CopyLog_ErrorWhileCopyingLog) + e.getLocalizedMessage()));
                        ResourcesUtil.refreshWorkspaceFiles((URI)destURI);
                    }
                }
                finally {
                    ResourcesUtil.refreshWorkspaceFiles((URI)destURI);
                }
            }
        } else {
            MessageDialog.openWarning((Shell)shell, (String)ConsoleMessages.CopyLog_UnavailableLog, (String)ConsoleMessages.CopyLog_BuildNotLogged);
        }
    }
}

