/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog;

import java.sql.Connection;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.ibm.catalog.ICatalogAuthorizationIdentifier;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogUser;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWOverwriteStatus;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.impl.GroupImpl;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LUWCatalogGroup
extends GroupImpl
implements ICatalogObject,
ICatalogAuthorizationIdentifier {
    private boolean receivedPrivilegesLoaded = false;
    private boolean receivedRoleAuthorizationLoaded = false;

    public void refresh() {
        if (this.receivedPrivilegesLoaded) {
            this.receivedPrivilegesLoaded = false;
            this.getReceivedPrivilege().clear();
        }
        if (this.receivedRoleAuthorizationLoaded) {
            this.receivedRoleAuthorization.clear();
            this.receivedRoleAuthorizationLoaded = false;
        }
        this.getGrantedPrivilege().clear();
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getDatabase();
        return ((LUWCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getDatabase();
    }

    public EList getReceivedRoleAuthorization() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getReceivedRoleAuthorization();
        }
        if (!this.receivedRoleAuthorizationLoaded) {
            this.loadReceivedRoleAuthorization();
        }
        return this.receivedRoleAuthorization;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 13) {
            this.getReceivedPrivilege();
        } else if (id == 10) {
            this.getReceivedRoleAuthorization();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadReceivedPrivilege() {
        if (this.receivedPrivilegesLoaded) {
            return;
        }
        this.receivedPrivilegesLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogUser.loadReceivedPrivilege(this.getConnection(), super.getReceivedPrivilege(), (AuthorizationIdentifier)this, "G");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadReceivedRoleAuthorization() {
        if (this.receivedRoleAuthorizationLoaded) {
            return;
        }
        this.receivedRoleAuthorizationLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        LUWCatalogUser.loadReceivedRoleAuthorization(this.getConnection(), super.getReceivedRoleAuthorization(), (AuthorizationIdentifier)this);
        this.eSetDeliver(deliver);
    }

    public EList getCatalogReceivedPrivileges() {
        this.loadReceivedPrivilege();
        return this.receivedPrivilege;
    }
}

