/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.commonui.privilege.IPrivilegeState;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.commonui.privilege.PrivilegeState;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseAuthorizedObject;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybasePrivilege;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Group;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Role;
import org.eclipse.datatools.modelbase.sql.accesscontrol.RoleAuthorization;
import org.eclipse.datatools.modelbase.sql.accesscontrol.User;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.sqltools.sql.util.ModelUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class PrivilegesUtil {
    public static List getAuthorizationIdentifiers(SQLObject obj) {
        EObject db;
        EStructuralFeature feature;
        Catalog catalog = ModelUtil.getCatalog((EObject)obj);
        List authIds = null;
        if (catalog != null && (feature = catalog.eClass().getEStructuralFeature("authorizationIds")) != null) {
            authIds = (List)catalog.eGet(feature);
        }
        if ((authIds == null || authIds.isEmpty()) && (db = ContainmentServiceImpl.INSTANCE.getRootElement((EObject)obj)) instanceof Database) {
            authIds = ((Database)db).getAuthorizationIds();
        }
        return authIds;
    }

    public static List getReceivedSQLObjectPrivileges(AuthorizationIdentifier authid, SQLObject obj) {
        ArrayList<SybasePrivilege> matchedPrivileges = new ArrayList<SybasePrivilege>();
        EList privs = new ArrayList();
        privs = obj instanceof SybaseAuthorizedObject ? ((SybaseAuthorizedObject)obj).getPrivileges() : authid.getReceivedPrivilege();
        for (SybasePrivilege p : privs) {
            if (p.getObject() != obj || p.getGrantee() != authid) continue;
            matchedPrivileges.add(p);
        }
        return matchedPrivileges;
    }

    public static Privilege getPrivilege(AuthorizationIdentifier authid, SQLObject obj, String action) {
        List matchedPrivileges = PrivilegesUtil.getReceivedSQLObjectPrivileges(authid, obj);
        Privilege matchedP = null;
        for (Privilege p : matchedPrivileges) {
            if (!p.getAction().toLowerCase().equals(action.toLowerCase())) continue;
            matchedP = p;
            break;
        }
        return matchedP;
    }

    public static List getBelongedGroups(User user, List authids) {
        ArrayList belongedGroups = new ArrayList();
        PrivilegesUtil.getBelongedGroups(user, authids, belongedGroups);
        return belongedGroups;
    }

    public static void getBelongedGroups(User user, List authids, List belongedGroups) {
        for (AuthorizationIdentifier authid : authids) {
            Group g;
            if (!(authid instanceof Group) || belongedGroups.contains(authid) || !(g = (Group)authid).getUser().contains((Object)user)) continue;
            belongedGroups.add(g);
            if (!(g instanceof User)) continue;
            PrivilegesUtil.getBelongedGroups((User)g, authids, belongedGroups);
        }
    }

    public static Privilege[] getUserInheritedPrivilege(List authids, User user, SQLObject obj, String action) {
        Privilege[] p = PrivilegesUtil.getInheritedGroupPrivilege(authids, user, obj, action);
        if (p == null) {
            p = PrivilegesUtil.getReceivedRolePrivilege((AuthorizationIdentifier)user, obj, action);
        }
        return p;
    }

    public static Privilege[] getReceivedRolePrivilege(AuthorizationIdentifier user, SQLObject obj, String action) {
        ArrayList<Privilege> ps = new ArrayList<Privilege>();
        Privilege p = null;
        EList roles = user.getReceivedRoleAuthorization();
        for (RoleAuthorization authid : roles) {
            p = PrivilegesUtil.getPrivilege((AuthorizationIdentifier)authid.getRole(), obj, action);
            if (p == null) continue;
            ps.add(p);
        }
        return ps.toArray(new Privilege[ps.size()]);
    }

    public static Privilege[] getInheritedGroupPrivilege(List authids, User user, SQLObject obj, String action) {
        ArrayList<Privilege> ps = new ArrayList<Privilege>();
        Privilege p = null;
        List belongedGroups = PrivilegesUtil.getBelongedGroups(user, authids);
        for (AuthorizationIdentifier authid : belongedGroups) {
            p = PrivilegesUtil.getPrivilege(authid, obj, action);
            if (p == null) continue;
            ps.add(p);
        }
        return ps.toArray(new Privilege[ps.size()]);
    }

    private static int getPrivilegeState(Privilege p) {
        if (p == null) {
            return 0;
        }
        boolean revoked = false;
        int pState = 0;
        EStructuralFeature feature = p.eClass().getEStructuralFeature("revoked");
        if (feature != null) {
            revoked = (Boolean)p.eGet(feature);
        }
        pState = revoked ? 4 : (p.isGrantable() ? 2 : 1);
        return pState;
    }

    public static boolean hasInheritedPrivilege(List authids, AuthorizationIdentifier authid, SQLObject sqlObj, String action) {
        Privilege[] ps = PrivilegesUtil.getInheritedPrivilege(authids, authid, sqlObj, action);
        return ps != null && ps.length > 0;
    }

    public static Privilege[] getInheritedPrivilege(List authids, AuthorizationIdentifier authid, SQLObject sqlObj, String action) {
        if (!(authid instanceof User)) {
            Privilege[] ps = PrivilegesUtil.getReceivedRolePrivilege(authid, sqlObj, action);
            return ps;
        }
        User user = (User)authid;
        Privilege[] ps = PrivilegesUtil.getUserInheritedPrivilege(authids, user, sqlObj, action);
        return ps;
    }

    public static IPrivilegeState getPrivilegeState(List authids, AuthorizationIdentifier authid, SQLObject sqlObj, String action) {
        User user;
        Privilege[] ps;
        Privilege[] ps2;
        Privilege p = PrivilegesUtil.getPrivilege(authid, sqlObj, action);
        int pState = 0;
        if (p == null && (ps2 = PrivilegesUtil.getInheritedPrivilege(authids, authid, sqlObj, action)) != null && ps2.length > 0) {
            pState = 3;
        }
        if (pState == 0) {
            pState = PrivilegesUtil.getPrivilegeState(p);
        }
        if (pState == 4 && authid instanceof User && ((ps = PrivilegesUtil.getInheritedPrivilege(authids, (AuthorizationIdentifier)(user = (User)authid), sqlObj, action)) == null || ps.length == 0)) {
            pState = 0;
        }
        int type = 0;
        if (authid instanceof Group) {
            type = 1;
        } else if (authid instanceof Role) {
            type = 2;
        }
        return PrivilegeState.get(pState, type);
    }

    public static String getInheritedPrivilegeDspString(Privilege[] ps) {
        if (ps != null && ps.length > 0) {
            boolean isGrantable = false;
            int i = 0;
            while (i < ps.length) {
                if (ps[i].isGrantable()) {
                    isGrantable = true;
                    break;
                }
                ++i;
            }
            String displayStr = "";
            displayStr = isGrantable ? IPrivilegeState.PRIVILEGES_DISPLAY_NAME[2] : IPrivilegeState.PRIVILEGES_DISPLAY_NAME[1];
            displayStr = String.valueOf(displayStr) + "(" + IPrivilegeState.INHERITED_PRIVILEGE_STATE.getDisplayString() + ")";
            return displayStr;
        }
        return IPrivilegeState.INHERITED_PRIVILEGE_STATE.getDisplayString();
    }

    public static AuthorizationIdentifier getOriginalAuthid(AuthorizationIdentifier authid, List authids) {
        for (AuthorizationIdentifier item : authids) {
            if (!item.getName().equals(authid.getName()) || item.eClass() != authid.eClass()) continue;
            return item;
        }
        return null;
    }

    public static String getDisplayString(List authids, AuthorizationIdentifier authid, SQLObject sqlObj, String action, Privilege p) {
        String initialDisplayString = null;
        IPrivilegeState pState = PrivilegesUtil.getPrivilegeState(authids, authid, sqlObj, action);
        if (pState.getCode() == 3) {
            Privilege[] ps = PrivilegesUtil.getInheritedPrivilege(authids, authid, sqlObj, action);
            initialDisplayString = PrivilegesUtil.getInheritedPrivilegeDspString(ps);
        } else {
            initialDisplayString = pState.getDisplayString();
        }
        return initialDisplayString;
    }
}

