/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.activestatedebugger.preferences;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.PreferenceMessages;
import org.eclipse.dltk.ui.environment.EnvironmentPathBlock;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TclLoggingPathBlock
extends EnvironmentPathBlock {
    private Map<String, Boolean> enableLogging = new HashMap<String, Boolean>();

    public void setEnableLogging(Map<String, Boolean> values) {
        this.enableLogging.clear();
        this.enableLogging.putAll(values);
        this.getViewer().refresh();
    }

    public Map<String, Boolean> getEnableLogging() {
        return Collections.unmodifiableMap(this.enableLogging);
    }

    protected EnvironmentPathBlock.PathLabelProvider createPathLabelProvider() {
        return new TclLoggingPathLabelProvider();
    }

    protected void initColumns(TableViewer viewer, PixelConverter conv) {
        TableViewerEditor.create((TableViewer)viewer, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)viewer), (int)64);
        this.initEnvironmentColumn(viewer, conv);
        this.initEnableLoggingColumn(viewer, conv);
        this.initPathColumn(viewer, conv);
    }

    protected void initEnableLoggingColumn(TableViewer viewer, PixelConverter conv) {
        TableViewerColumn enableColumn = new TableViewerColumn(viewer, 0);
        enableColumn.getColumn().setText(PreferenceMessages.TclLoggingPathBlock_enable);
        enableColumn.getColumn().setWidth(conv.convertWidthInCharsToPixels(12));
        enableColumn.setEditingSupport((EditingSupport)new EnableEditingSupport((ColumnViewer)viewer));
    }

    private class EnableEditingSupport
    extends EditingSupport {
        private final ComboBoxCellEditor editor;

        private EnableEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new ComboBoxCellEditor((Composite)viewer.getControl(), new String[]{PreferenceMessages.TclLoggingPathBlock_No, PreferenceMessages.TclLoggingPathBlock_Yes}, 8);
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            Boolean value = (Boolean)TclLoggingPathBlock.this.enableLogging.get(((IEnvironment)element).getId());
            return value == null || value != false ? 1 : 0;
        }

        protected void setValue(Object element, Object value) {
            TclLoggingPathBlock.this.enableLogging.put(((IEnvironment)element).getId(), (Integer)value != 0);
            this.getViewer().refresh();
            TclLoggingPathBlock.this.fireValueChanged();
        }
    }

    private class TclLoggingPathLabelProvider
    extends EnvironmentPathBlock.PathLabelProvider {
        public TclLoggingPathLabelProvider() {
            super((EnvironmentPathBlock)TclLoggingPathBlock.this, 2);
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 1) {
                Boolean value = (Boolean)TclLoggingPathBlock.this.enableLogging.get(((IEnvironment)element).getId());
                return value == null || value != false ? PreferenceMessages.TclLoggingPathBlock_Yes : PreferenceMessages.TclLoggingPathBlock_No;
            }
            return super.getColumnText(element, columnIndex);
        }
    }
}

