/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.externalchecker.core;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.validators.core.IValidatorOutput;
import org.eclipse.dltk.validators.core.IValidatorReporter;
import org.eclipse.dltk.validators.core.SourceModuleValidatorWorker;
import org.eclipse.dltk.validators.internal.externalchecker.core.ExternalChecker;
import org.eclipse.dltk.validators.internal.externalchecker.core.ExternalCheckerDelegate;
import org.eclipse.dltk.validators.internal.externalchecker.core.Messages;

public class ExternalSourceModuleWorker
extends SourceModuleValidatorWorker {
    private ExternalCheckerDelegate delegate;

    public ExternalSourceModuleWorker(IEnvironment environment, ExternalChecker externalChecker) {
        this.delegate = new ExternalCheckerDelegate(environment, externalChecker);
    }

    public void clean(IResource[] resources) {
        super.clean(resources);
    }

    protected IValidatorReporter createValidatorReporter() {
        return this.delegate.createValidatorReporter();
    }

    protected String getTaskName() {
        return Messages.ExternalChecker_checkingWithExternalExecutable;
    }

    protected String getMarkerId() {
        return this.delegate.getMarkerId();
    }

    protected String getNullResourceMessage() {
        return Messages.ExternalChecker_sourceModuleResourceIsNull;
    }

    protected String getPluginId() {
        return "org.eclipse.dltk.validators.externalchecker";
    }

    protected boolean isValidatorConfigured() {
        return this.delegate.isValidatorConfigured();
    }

    protected boolean isValidSourceModule(ISourceModule module) {
        IResource resource = module.getResource();
        return this.delegate.isValidExtension(resource.getFileExtension());
    }

    protected void runValidator(ISourceModule module, IValidatorOutput console, IValidatorReporter reporter, IProgressMonitor monitor) throws CoreException {
        this.delegate.runValidator(module.getResource(), console, problem -> {
            IMarker iMarker = reporter.report(module, problem);
        });
    }
}

