/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.swt.internal.reference.table;

import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.spi.common.ui.composites.SelectModelElementCompositeImpl;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContextFactory;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReferenceSegment;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VFeatureDomainModelReferenceSegment;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.reporting.InvalidGridDescriptionReport;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.model.VTableDomainModelReference;
import org.eclipse.emf.ecp.view.spi.table.swt.TableControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.util.swt.ImageRegistryService;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.emf.DomainModelReferenceConverterEMF;
import org.eclipse.emfforms.spi.core.services.databinding.emf.DomainModelReferenceSegmentConverterEMF;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsDMRSegmentExpander;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.core.services.label.NoLabelFoundException;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.emfforms.spi.swt.table.ColumnConfigurationBuilder;
import org.eclipse.emfforms.spi.swt.table.TableViewerCompositeBuilder;
import org.eclipse.emfforms.spi.swt.table.TableViewerSWTBuilder;
import org.eclipse.emfforms.swt.internal.reference.table.DelegatingDmrSegmentConverter;
import org.eclipse.emfforms.swt.internal.reference.table.DelegatingDomainModelReferenceConverter;
import org.eclipse.emfforms.swt.internal.reference.table.DummyDomainExpander;
import org.eclipse.emfforms.view.spi.multisegment.model.MultiSegmentUtil;
import org.eclipse.emfforms.view.spi.multisegment.model.VMultiDomainModelReferenceSegment;
import org.eclipse.emfforms.view.spi.multisegment.model.VMultisegmentFactory;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

public class TableSelectionCompositeImpl
extends SelectModelElementCompositeImpl {
    private static final String SELECTION_NS_URI = "http://www.eclipse.org/emf/ecp/view/reference/table/selection";
    private static final EPackage SELECTION_PACKAGE = EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/emf/ecp/view/reference/table/selection");
    private static final EClass SELECTION_CLASS = (EClass)SELECTION_PACKAGE.getEClassifier("Selection");
    private static final EStructuralFeature SELECTION_EXTENT = SELECTION_CLASS.getEStructuralFeature("extent");
    private final Collection<? extends EObject> extent;
    private final VTableControl tableControl;
    private final EObject owner;
    private ViewModelContext context;
    private VDomainModelReference realDMR;
    private ServiceRegistration<DomainModelReferenceConverterEMF> dmrConverter;
    private ServiceRegistration<DomainModelReferenceSegmentConverterEMF> segmentConverter;
    private ServiceRegistration<EMFFormsDMRSegmentExpander> segmentExpander;

    public TableSelectionCompositeImpl(Collection<? extends EObject> extent, VTableControl tableControl, EObject owner, EReference reference) {
        super(extent, reference.isMany());
        this.extent = extent;
        this.tableControl = tableControl;
        this.owner = owner;
    }

    public void dispose() {
        if (this.context != null) {
            this.context.dispose();
            this.context = null;
        }
        if (this.dmrConverter != null) {
            this.dmrConverter.unregister();
        }
        if (this.segmentConverter != null) {
            this.segmentConverter.unregister();
        }
        if (this.segmentExpander != null) {
            this.segmentExpander.unregister();
        }
        super.dispose();
    }

    protected TableViewer createViewer(Composite composite) {
        VFeaturePathDomainModelReference extentDMR;
        EObject selectionExtent = this.createSelectionExtent();
        VView tableView = VViewFactory.eINSTANCE.createView();
        tableView.getChildren().add((Object)this.tableControl);
        tableView.setReadonly(true);
        if (this.tableControl.getDomainModelReference() == null) {
            extentDMR = this.createLegacyExtentDmr(selectionExtent);
            this.realDMR = this.tableControl.getDomainModelReference();
            this.tableControl.setDomainModelReference((VDomainModelReference)extentDMR);
            this.registerDMRConverter(selectionExtent, extentDMR);
        } else if (!this.tableControl.getDomainModelReference().getSegments().isEmpty()) {
            VMultiDomainModelReferenceSegment realMultiSeg = (VMultiDomainModelReferenceSegment)MultiSegmentUtil.getMultiSegment((VDomainModelReference)this.tableControl.getDomainModelReference()).orElseThrow(() -> new IllegalArgumentException("the table model's dmr is segment based but doesn't have a multi segment."));
            this.adaptRealSegmentDmr(realMultiSeg);
            VDomainModelReference ex = this.configureSegmentExtentDmr(selectionExtent, realMultiSeg);
            this.tableControl.setDomainModelReference(ex);
        } else if (this.tableControl.getDomainModelReference() instanceof VTableDomainModelReference) {
            extentDMR = this.createLegacyExtentDmr(selectionExtent);
            VTableDomainModelReference dmr = (VTableDomainModelReference)this.tableControl.getDomainModelReference();
            this.realDMR = dmr.getDomainModelReference();
            dmr.setDomainModelReference((VDomainModelReference)extentDMR);
            this.registerDMRConverter(selectionExtent, extentDMR);
        } else {
            throw new IllegalArgumentException("table model has no table DMR");
        }
        this.context = ViewModelContextFactory.INSTANCE.createViewModelContext((VElement)tableView, this.owner);
        PrivateTableRenderer renderer = new PrivateTableRenderer(this.context, this.tableControl);
        Control control = renderer.render(composite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).minSize(0, 150).span(2, 1).applyTo(control);
        TableViewer result = renderer.getTableViewer();
        return result;
    }

    private VFeaturePathDomainModelReference createLegacyExtentDmr(EObject selectionExtent) {
        VFeaturePathDomainModelReference extentDMR = VViewFactory.eINSTANCE.createFeaturePathDomainModelReference();
        extentDMR.setDomainModelEFeature((EStructuralFeature)selectionExtent.eClass().getEReferences().get(0));
        return extentDMR;
    }

    private void adaptRealSegmentDmr(VMultiDomainModelReferenceSegment realMultiSeg) {
        this.realDMR = this.tableControl.getDomainModelReference();
        this.realDMR.getSegments().remove((Object)realMultiSeg);
        VFeatureDomainModelReferenceSegment realReplace = VViewFactory.eINSTANCE.createFeatureDomainModelReferenceSegment();
        realReplace.setDomainModelFeature(realMultiSeg.getDomainModelFeature());
        this.realDMR.getSegments().add((Object)realReplace);
    }

    private VDomainModelReference configureSegmentExtentDmr(EObject selectionExtent, VMultiDomainModelReferenceSegment realMultiSegment) {
        VDomainModelReference extentDmr = VViewFactory.eINSTANCE.createDomainModelReference();
        VMultiDomainModelReferenceSegment extentSegment = VMultisegmentFactory.eINSTANCE.createMultiDomainModelReferenceSegment();
        EReference extentRef = (EReference)selectionExtent.eClass().getEReferences().get(0);
        extentSegment.setDomainModelFeature(extentRef.getName());
        extentSegment.getChildDomainModelReferences().addAll((Collection)realMultiSegment.getChildDomainModelReferences());
        extentDmr.getSegments().add((Object)extentSegment);
        this.registerSegmentServices(selectionExtent, (VFeatureDomainModelReferenceSegment)extentSegment, (EStructuralFeature)extentRef);
        return extentDmr;
    }

    protected CellLabelProvider createColumnLabelProvider(final ILabelProvider delegate) {
        return new ColumnLabelProvider(){

            public String getText(Object element) {
                return delegate.getText(element);
            }

            public Image getImage(Object element) {
                return delegate.getImage(element);
            }
        };
    }

    private EObject createSelectionExtent() {
        EObject result = SELECTION_PACKAGE.getEFactoryInstance().create(SELECTION_CLASS);
        EList selectionExtent = (EList)result.eGet(SELECTION_EXTENT);
        selectionExtent.addAll(this.extent);
        return result;
    }

    private void registerDMRConverter(EObject source, VFeaturePathDomainModelReference dmr) {
        DelegatingDomainModelReferenceConverter delegator = new DelegatingDomainModelReferenceConverter(dmr, __ -> source);
        BundleContext ctx = FrameworkUtil.getBundle(TableSelectionCompositeImpl.class).getBundleContext();
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
        properties.put("service.ranking", Integer.MAX_VALUE);
        this.dmrConverter = ctx.registerService(DomainModelReferenceConverterEMF.class, (Object)delegator, properties);
    }

    private void registerSegmentServices(EObject source, VFeatureDomainModelReferenceSegment segment, EStructuralFeature segmentFeature) {
        DelegatingDmrSegmentConverter delegator = new DelegatingDmrSegmentConverter(segment, segmentFeature, __ -> source);
        DummyDomainExpander expander = new DummyDomainExpander((VDomainModelReferenceSegment)segment);
        BundleContext ctx = FrameworkUtil.getBundle(TableSelectionCompositeImpl.class).getBundleContext();
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
        properties.put("service.ranking", Integer.MAX_VALUE);
        this.segmentConverter = ctx.registerService(DomainModelReferenceSegmentConverterEMF.class, (Object)delegator, properties);
        this.segmentExpander = ctx.registerService(EMFFormsDMRSegmentExpander.class, (Object)expander, properties);
    }

    private final class PrivateTableRenderer
    extends TableControlSWTRenderer {
        private final EMFFormsLocalizationService l10n;
        private final EMFFormsLabelProvider labels;

        PrivateTableRenderer(ViewModelContext context, VTableControl vTable) {
            super(vTable, context, (ReportService)context.getService(ReportService.class), (EMFFormsDatabindingEMF)context.getService(EMFFormsDatabindingEMF.class), (EMFFormsLabelProvider)context.getService(EMFFormsLabelProvider.class), (VTViewTemplateProvider)context.getService(VTViewTemplateProvider.class), (ImageRegistryService)context.getService(ImageRegistryService.class), (EMFFormsEditSupport)context.getService(EMFFormsEditSupport.class), (EMFFormsLocalizationService)context.getService(EMFFormsLocalizationService.class));
            this.l10n = (EMFFormsLocalizationService)context.getService(EMFFormsLocalizationService.class);
            this.labels = (EMFFormsLabelProvider)context.getService(EMFFormsLabelProvider.class);
        }

        protected TableViewer getTableViewer() {
            return (TableViewer)super.getTableViewer();
        }

        protected TableViewerCompositeBuilder createTableViewerCompositeBuilder() {
            return new MinimalCompositeBuilder();
        }

        protected int addAdditionalColumns(TableViewerSWTBuilder tableViewerSWTBuilder) {
            ColumnConfigurationBuilder columnBuilder = ColumnConfigurationBuilder.usingDefaults().labelProvider(TableSelectionCompositeImpl.this.createColumnLabelProvider(TableSelectionCompositeImpl.this.getLabelProvider())).minWidth(50).weight(100).resizable(true).text(this.getSelectionColumnTitle()).tooltip(this.getSelectionColumnTooltip());
            tableViewerSWTBuilder.addColumn(columnBuilder.build());
            return 1;
        }

        private IObservableValue<String> getSelectionColumnTitle() {
            String result = this.l10n.getString(TableSelectionCompositeImpl.class, "selectionColumn");
            return Observables.constantObservableValue((Realm)Realm.getDefault(), (Object)result, String.class);
        }

        private IObservableValue<String> getSelectionColumnTooltip() {
            IObservableValue<String> featureName = this.getRealDMRDisplayName();
            return ComputedValue.create(() -> NLS.bind((String)this.l10n.getString(TableSelectionCompositeImpl.class, "selectionTooltip"), (Object)featureName.getValue()));
        }

        private IObservableValue<String> getRealDMRDisplayName() {
            IObservableValue result;
            try {
                result = this.labels.getDisplayName(TableSelectionCompositeImpl.this.realDMR, TableSelectionCompositeImpl.this.owner);
            }
            catch (NoLabelFoundException e) {
                result = Observables.constantObservableValue((Realm)Realm.getDefault(), (Object)this.l10n.getString(TableSelectionCompositeImpl.class, "reference"), String.class);
            }
            return result;
        }

        Control render(Composite parent) {
            Control result = null;
            this.init();
            SWTGridDescription grid = this.getGridDescription(GridDescriptionFactory.INSTANCE.createEmptyGridDescription());
            if (grid.getGrid().isEmpty()) {
                this.getReportService().report((AbstractReport)new InvalidGridDescriptionReport("grid has no cells"));
            }
            try {
                result = this.renderTableControl((SWTGridCell)grid.getGrid().get(0), parent);
                this.finalizeRendering(parent);
            }
            catch (NoPropertyDescriptorFoundExeption | NoRendererFoundException e) {
                this.getReportService().report((AbstractReport)new RenderingFailedReport(e));
            }
            return result;
        }

        private final class MinimalCompositeBuilder
        extends TableControlSWTRenderer.TableControlSWTRendererCompositeBuilder {
            private MinimalCompositeBuilder() {
                super((TableControlSWTRenderer)PrivateTableRenderer.this);
            }

            protected Label createTitleLabel(Composite parentComposite, Color background) {
                return null;
            }

            protected Label createValidationLabel(Composite topComposite) {
                return null;
            }

            protected Composite createButtonComposite(Composite parentComposite) {
                return null;
            }

            public Optional<Label> getTitleLabel() {
                return Optional.empty();
            }

            public Optional<List<Control>> getValidationControls() {
                return Optional.empty();
            }

            public Optional<Composite> getButtonComposite() {
                return Optional.empty();
            }
        }
    }
}

