(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "./languageService"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.DockerfileLanguageServiceFactory = exports.CommandIds = void 0;
    var languageService_1 = require("./languageService");
    var CommandIds;
    (function (CommandIds) {
        CommandIds["LOWERCASE"] = "docker.command.convertToLowercase";
        CommandIds["UPPERCASE"] = "docker.command.convertToUppercase";
        CommandIds["EXTRA_ARGUMENT"] = "docker.command.removeExtraArgument";
        CommandIds["DIRECTIVE_TO_BACKTICK"] = "docker.command.directiveToBacktick";
        CommandIds["DIRECTIVE_TO_BACKSLASH"] = "docker.command.directiveToBackslash";
        CommandIds["FLAG_TO_CHOWN"] = "docker.command.flagToChown";
        CommandIds["FLAG_TO_COPY_FROM"] = "docker.command.flagToCopyFrom";
        CommandIds["FLAG_TO_HEALTHCHECK_INTERVAL"] = "docker.command.flagToHealthcheckInterval";
        CommandIds["FLAG_TO_HEALTHCHECK_RETRIES"] = "docker.command.flagToHealthcheckRetries";
        CommandIds["FLAG_TO_HEALTHCHECK_START_PERIOD"] = "docker.command.flagToHealthcheckStartPeriod";
        CommandIds["FLAG_TO_HEALTHCHECK_TIMEOUT"] = "docker.command.flagToHealthcheckTimeout";
        CommandIds["REMOVE_EMPTY_CONTINUATION_LINE"] = "docker.command.removeEmptyContinuationLine";
        CommandIds["CONVERT_TO_AS"] = "docker.command.convertToAS";
    })(CommandIds = exports.CommandIds || (exports.CommandIds = {}));
    var DockerfileLanguageServiceFactory;
    (function (DockerfileLanguageServiceFactory) {
        function createLanguageService() {
            return new languageService_1.LanguageService();
        }
        DockerfileLanguageServiceFactory.createLanguageService = createLanguageService;
    })(DockerfileLanguageServiceFactory = exports.DockerfileLanguageServiceFactory || (exports.DockerfileLanguageServiceFactory = {}));
});
